/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;

@Dependent
public class ActionColumnSynchronizer
extends BaseColumnSynchronizer<BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData> {
    @Override
    public boolean handlesAppend(Synchronizer.MetaData metaData) throws ModelSynchronizer.MoveColumnVetoException {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof ActionCol52;
    }

    @Override
    public void append(BaseColumnSynchronizer.ColumnMetaData metaData) throws ModelSynchronizer.MoveColumnVetoException {
        if (!this.handlesAppend(metaData)) {
            return;
        }
        ActionCol52 column = (ActionCol52)metaData.getColumn();
        this.model.getActionCols().add(column);
        this.synchroniseAppendColumn((BaseColumn)column);
    }

    @Override
    public boolean handlesUpdate(Synchronizer.MetaData metaData) throws ModelSynchronizer.MoveColumnVetoException {
        return false;
    }

    @Override
    public List<BaseColumnFieldDiff> update(BaseColumnSynchronizer.ColumnMetaData originalMetaData, BaseColumnSynchronizer.ColumnMetaData editedMetaData) throws ModelSynchronizer.MoveColumnVetoException {
        return Collections.emptyList();
    }

    @Override
    public boolean handlesDelete(Synchronizer.MetaData metaData) throws ModelSynchronizer.MoveColumnVetoException {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof ActionCol52;
    }

    @Override
    public void delete(BaseColumnSynchronizer.ColumnMetaData metaData) throws ModelSynchronizer.MoveColumnVetoException {
        if (!this.handlesDelete(metaData)) {
            return;
        }
        ActionCol52 column = (ActionCol52)metaData.getColumn();
        int columnIndex = this.model.getExpandedColumns().indexOf(column);
        this.model.getActionCols().remove(column);
        this.synchroniseDeleteColumn(columnIndex);
    }

    @Override
    public boolean handlesMoveColumnsTo(List<? extends Synchronizer.MetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        for (Synchronizer.MetaData metaData2 : metaData) {
            if (!(metaData2 instanceof BaseSynchronizer.MoveColumnToMetaData)) {
                return false;
            }
            Object column = ((BaseSynchronizer.MoveColumnToMetaData)metaData2).getColumn();
            if (column instanceof ActionCol52) continue;
            return false;
        }
        if (this.isBRLFragment(metaData)) {
            return true;
        }
        if (metaData.size() > 1) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        return true;
    }

    @Override
    public void moveColumnsTo(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        if (!this.handlesMoveColumnsTo(metaData)) {
            return;
        }
        if (this.isBRLFragment(metaData)) {
            this.doMoveBRLFragment(metaData);
        } else if (this.isSingleAction(metaData)) {
            this.doMoveSingleAction(metaData.get(0));
        } else {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
    }

    private boolean isBRLFragment(List<? extends Synchronizer.MetaData> metaData) {
        if (!metaData.stream().allMatch(c -> c instanceof BaseSynchronizer.MoveColumnToMetaData)) {
            return false;
        }
        if (!metaData.stream().allMatch(c -> ((BaseSynchronizer.MoveColumnToMetaData)c).getColumn() instanceof BRLActionVariableColumn)) {
            return false;
        }
        BaseSynchronizer.MoveColumnToMetaData md = (BaseSynchronizer.MoveColumnToMetaData)metaData.get(0);
        BRLActionVariableColumn srcModelColumn = (BRLActionVariableColumn)md.getColumn();
        BRLActionColumn srcModelPattern = this.model.getBRLColumn(srcModelColumn);
        return srcModelPattern.getChildColumns().size() == metaData.size();
    }

    private boolean isSingleAction(List<BaseSynchronizer.MoveColumnToMetaData> metaData) {
        if (metaData.size() != 1) {
            return false;
        }
        if (metaData.get(0).getColumn() instanceof BRLActionVariableColumn) {
            return false;
        }
        return metaData.get(0).getColumn() instanceof ActionCol52;
    }

    private void doMoveBRLFragment(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        BaseSynchronizer.MoveColumnToMetaData md = metaData.get(0);
        BRLActionVariableColumn srcModelColumn = (BRLActionVariableColumn)md.getColumn();
        BRLActionColumn srcModelBRLFragment = this.model.getBRLColumn(srcModelColumn);
        if (srcModelBRLFragment == null) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        List srcModelBRLFragmentColumns = srcModelBRLFragment.getChildColumns();
        int srcModelBRLFragmentColumnsCount = srcModelBRLFragmentColumns.size();
        if (srcModelBRLFragmentColumnsCount == 0) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        if (srcModelBRLFragmentColumnsCount != metaData.size()) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        int tgtColumnIndex = md.getTargetColumnIndex();
        int tgtActionIndex = this.findTargetActionIndex(md);
        List allModelColumns = this.model.getExpandedColumns();
        this.moveModelData(tgtColumnIndex, allModelColumns.indexOf(srcModelBRLFragmentColumns.get(0)), allModelColumns.indexOf(srcModelBRLFragmentColumns.get(0)) + srcModelBRLFragmentColumnsCount - 1);
        this.model.getActionCols().remove(srcModelBRLFragment);
        this.model.getActionCols().add(tgtActionIndex, srcModelBRLFragment);
    }

    private void doMoveSingleAction(BaseSynchronizer.MoveColumnToMetaData metaData) throws ModelSynchronizer.MoveColumnVetoException {
        ActionCol52 srcModelColumn = (ActionCol52)metaData.getColumn();
        List srcModelActionColumns = this.model.getActionCols();
        int srcModelActionColumnCount = srcModelActionColumns.size();
        if (srcModelActionColumnCount == 0) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        int minColumnIndex = this.getMinActionColumnIndex();
        int maxColumnIndex = this.getMaxActionColumnIndex();
        int tgtColumnIndex = metaData.getTargetColumnIndex();
        int tgtActionIndex = this.findTargetActionIndex(metaData);
        int srcColumnIndex = metaData.getSourceColumnIndex();
        if (tgtColumnIndex < minColumnIndex || tgtColumnIndex > maxColumnIndex) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        this.moveModelData(tgtColumnIndex, srcColumnIndex, srcColumnIndex);
        srcModelActionColumns.remove(srcModelColumn);
        srcModelActionColumns.add(tgtActionIndex, srcModelColumn);
    }

    private int getMinActionColumnIndex() {
        List allModelColumns = this.model.getExpandedColumns();
        List modelActionColumns = this.model.getActionCols();
        ActionCol52 actionCol = (ActionCol52)modelActionColumns.get(0);
        if (actionCol instanceof BRLActionColumn) {
            BRLActionColumn brlActionCol = (BRLActionColumn)actionCol;
            List brlActionColChildren = brlActionCol.getChildColumns();
            return allModelColumns.indexOf(brlActionColChildren.get(0));
        }
        return allModelColumns.indexOf(actionCol);
    }

    private int getMaxActionColumnIndex() {
        List allModelColumns = this.model.getExpandedColumns();
        List modelActionColumns = this.model.getActionCols();
        ActionCol52 actionCol = (ActionCol52)modelActionColumns.get(modelActionColumns.size() - 1);
        if (actionCol instanceof BRLActionColumn) {
            BRLActionColumn brlActionCol = (BRLActionColumn)actionCol;
            List brlActionColChildren = brlActionCol.getChildColumns();
            return allModelColumns.indexOf(brlActionColChildren.get(brlActionColChildren.size() - 1));
        }
        return allModelColumns.indexOf(actionCol);
    }

    private int findTargetActionIndex(BaseSynchronizer.MoveColumnToMetaData md) throws ModelSynchronizer.MoveColumnVetoException {
        int tgtActionIndex = -1;
        int tgtColumnIndex = md.getTargetColumnIndex();
        List allModelColumns = this.model.getExpandedColumns();
        List allModelActions = this.model.getActionCols();
        for (int actionIndex = 0; actionIndex < allModelActions.size(); ++actionIndex) {
            ActionCol52 ac = (ActionCol52)allModelActions.get(actionIndex);
            List<ActionCol52> children = this.getChildren(ac);
            if (children == null || children.isEmpty()) continue;
            BaseColumn firstChild = (BaseColumn)children.get(0);
            BaseColumn lastChild = (BaseColumn)children.get(children.size() - 1);
            int firstChildIndex = allModelColumns.indexOf(firstChild);
            int lastChildIndex = allModelColumns.indexOf(lastChild);
            if (tgtColumnIndex < firstChildIndex || tgtColumnIndex > lastChildIndex) continue;
            tgtActionIndex = actionIndex;
            break;
        }
        if (tgtActionIndex < 0) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        return tgtActionIndex;
    }

    private List<ActionCol52> getChildren(ActionCol52 ac) {
        ArrayList<ActionCol52> children = new ArrayList<ActionCol52>();
        if (ac instanceof BRLActionColumn) {
            children.addAll(((BRLActionColumn)ac).getChildColumns());
        } else {
            children.add(ac);
        }
        return children;
    }
}

