/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.Arrays;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

public abstract class BaseColumnSynchronizer<A extends ColumnMetaData, U extends ColumnMetaData, D extends ColumnMetaData>
extends BaseSynchronizer<A, U, D> {
    @Override
    public boolean handlesInsert(Synchronizer.MetaData metaData) throws ModelSynchronizer.MoveColumnVetoException {
        return false;
    }

    @Override
    public void insert(A metaData) throws ModelSynchronizer.MoveColumnVetoException {
    }

    protected void synchroniseAppendColumn(BaseColumn modelColumn) {
        int columnIndex = this.model.getExpandedColumns().indexOf(modelColumn);
        GridColumn<?> uiModelColumn = this.gridWidgetColumnFactory.convertColumn(modelColumn, this.access, this.view);
        this.uiModel.insertColumn(columnIndex, uiModelColumn);
        for (int rowIndex = 0; rowIndex < this.model.getData().size(); ++rowIndex) {
            DTCellValue52 modelCell = this.makeModelCellValue(modelColumn);
            List modelRow = (List)this.model.getData().get(rowIndex);
            modelRow.add(columnIndex, modelCell);
            if (!modelCell.hasValue()) continue;
            this.uiModel.setCellInternal(rowIndex, columnIndex, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, modelColumn, this.cellUtilities, this.columnUtilities));
        }
        this.uiModel.indexColumn(columnIndex);
    }

    protected void synchroniseAppendColumn(BaseColumn modelColumn, List<DTCellValue52> originalColumnData) {
        int columnIndex = this.model.getExpandedColumns().indexOf(modelColumn);
        GridColumn<?> uiModelColumn = this.gridWidgetColumnFactory.convertColumn(modelColumn, this.access, this.view);
        this.uiModel.insertColumn(columnIndex, uiModelColumn);
        for (int rowIndex = 0; rowIndex < this.model.getData().size(); ++rowIndex) {
            DTCellValue52 modelCell = originalColumnData.get(rowIndex);
            List modelRow = (List)this.model.getData().get(rowIndex);
            modelRow.add(columnIndex, modelCell);
            if (!modelCell.hasValue()) continue;
            this.uiModel.setCellInternal(rowIndex, columnIndex, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, modelColumn, this.cellUtilities, this.columnUtilities));
        }
        this.uiModel.indexColumn(columnIndex);
    }

    protected void synchroniseUpdateColumn(BaseColumn modelColumn) {
        int columnIndex = this.model.getExpandedColumns().indexOf(modelColumn);
        GridColumn<?> uiModelColumn = this.gridWidgetColumnFactory.convertColumn(modelColumn, this.access, this.view);
        this.uiModel.updateColumn(columnIndex, uiModelColumn);
        for (int rowIndex = 0; rowIndex < this.model.getData().size(); ++rowIndex) {
            List modelRow = (List)this.model.getData().get(rowIndex);
            DTCellValue52 modelCell = (DTCellValue52)modelRow.get(columnIndex);
            if (!modelCell.hasValue()) continue;
            this.uiModel.setCellInternal(rowIndex, columnIndex, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, modelColumn, this.cellUtilities, this.columnUtilities));
        }
        this.uiModel.indexColumn(columnIndex);
    }

    protected void synchroniseDeleteColumn(int columnIndex) {
        for (int rowIndex = 0; rowIndex < this.model.getData().size(); ++rowIndex) {
            List modelRow = (List)this.model.getData().get(rowIndex);
            modelRow.remove(columnIndex);
        }
        GridColumn uiModelColumn = (GridColumn)this.uiModel.getColumns().get(columnIndex);
        this.uiModel.deleteColumn(uiModelColumn);
    }

    protected void setColumnVisibility(BaseColumn modelColumn, boolean isHidden) {
        modelColumn.setHideColumn(isHidden);
        int iModelColumn = this.model.getExpandedColumns().indexOf(modelColumn);
        ((GridColumn)this.uiModel.getColumns().get(iModelColumn)).setVisible(!isHidden);
    }

    protected void setColumnHeader(BaseColumn modelColumn, String header) {
        modelColumn.setHeader(header);
        int iModelColumn = this.model.getExpandedColumns().indexOf(modelColumn);
        ((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(iModelColumn)).getHeaderMetaData().get(0)).setTitle(header);
    }

    protected void clearColumnData(BaseColumn column) {
        int columnIndex = this.model.getExpandedColumns().indexOf(column);
        for (List row : this.model.getData()) {
            DTCellValue52 dcv = (DTCellValue52)row.get(columnIndex);
            dcv.clearValues();
        }
    }

    protected void updateCellsForOptionValueList(BaseColumn originalColumn, BaseColumn editedColumn) {
        List<String> values = Arrays.asList(this.columnUtilities.getValueList(editedColumn));
        boolean clearExistingValues = values.size() > 0;
        int columnIndex = this.model.getExpandedColumns().indexOf(originalColumn);
        for (List row : this.model.getData()) {
            DTCellValue52 dcv = (DTCellValue52)row.get(columnIndex);
            if (!clearExistingValues || values.contains(dcv.getStringValue())) continue;
            dcv.clearValues();
        }
    }

    public static class ColumnMetaDataImpl
    implements ColumnMetaData<BaseColumn> {
        private final BaseColumn column;

        public ColumnMetaDataImpl(BaseColumn column) {
            this.column = (BaseColumn)PortablePreconditions.checkNotNull((String)"column", (Object)column);
        }

        @Override
        public BaseColumn getColumn() {
            return this.column;
        }
    }

    public static interface ColumnMetaData<C extends BaseColumn>
    extends Synchronizer.MetaData {
        public C getColumn();
    }
}

