/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiffImpl;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AfterColumnDeleted;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AfterColumnInserted;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.ValidateEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.cell.GridWidgetCellFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.GridWidgetColumnFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.ConditionColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.RowSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.SystemControlledColumnValuesSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.DependentEnumsUtilities;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AppendRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateColumnDataEvent;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;

@Dependent
public class ModelSynchronizerImpl
implements ModelSynchronizer {
    private GuidedDecisionTable52 model;
    private GuidedDecisionTableUiModel uiModel;
    private CellUtilities cellUtilities;
    private ColumnUtilities columnUtilities;
    private DependentEnumsUtilities dependentEnumsUtilities;
    private GridWidgetCellFactory gridWidgetCellFactory;
    private EventBus eventBus;
    private SystemControlledColumnValuesSynchronizer systemControlledColumnValuesSynchronizer;
    private final List<Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>> synchronizers = new ArrayList<Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>>();

    @Override
    public void setSynchronizers(List<Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>> synchronizers) {
        this.synchronizers.clear();
        Collections.sort(synchronizers, new Comparator<Synchronizer>(){

            @Override
            public int compare(Synchronizer o1, Synchronizer o2) {
                return o2.priority() - o1.priority();
            }
        });
        this.synchronizers.addAll(synchronizers);
    }

    @Override
    public void initialise(GuidedDecisionTable52 model, GuidedDecisionTableUiModel uiModel, CellUtilities cellUtilities, ColumnUtilities columnUtilities, DependentEnumsUtilities dependentEnumsUtilities, GridWidgetCellFactory gridWidgetCellFactory, GridWidgetColumnFactory gridWidgetColumnFactory, GuidedDecisionTableView view, BRLRuleModel rm, EventBus eventBus, GuidedDecisionTablePresenter.Access access) {
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.uiModel = (GuidedDecisionTableUiModel)((Object)PortablePreconditions.checkNotNull((String)"uiModel", (Object)((Object)uiModel)));
        this.cellUtilities = (CellUtilities)PortablePreconditions.checkNotNull((String)"cellUtilities", (Object)cellUtilities);
        this.columnUtilities = (ColumnUtilities)((Object)PortablePreconditions.checkNotNull((String)"columnUtilities", (Object)((Object)columnUtilities)));
        this.dependentEnumsUtilities = (DependentEnumsUtilities)PortablePreconditions.checkNotNull((String)"dependentEnumsUtilities", (Object)dependentEnumsUtilities);
        this.gridWidgetCellFactory = (GridWidgetCellFactory)PortablePreconditions.checkNotNull((String)"gridWidgetCellFactory", (Object)gridWidgetCellFactory);
        this.eventBus = (EventBus)PortablePreconditions.checkNotNull((String)"eventBus", (Object)eventBus);
        this.systemControlledColumnValuesSynchronizer = new SystemControlledColumnValuesSynchronizer(model, uiModel, gridWidgetCellFactory, cellUtilities, columnUtilities);
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            synchronizer.initialise(model, uiModel, cellUtilities, columnUtilities, gridWidgetCellFactory, gridWidgetColumnFactory, view, rm, eventBus, access);
        }
    }

    @Override
    public void setCell(GridData.Range rowRange, int columnIndex, GridCellValue<?> value) {
        int minRowIndex = rowRange.getMinRowIndex();
        int maxRowIndex = rowRange.getMaxRowIndex();
        for (int rowIndex = minRowIndex; rowIndex <= maxRowIndex; ++rowIndex) {
            List modelRow = (List)this.model.getData().get(rowIndex);
            DTCellValue52 modelCell = (DTCellValue52)modelRow.get(columnIndex);
            if (value == null) {
                modelCell.clearValues();
                continue;
            }
            modelRow.set(columnIndex, new DTCellValue52(value.getValue()));
        }
        Set<Integer> columnRange = this.updateDependentEnumerationColumns(rowRange, columnIndex);
        this.fireValidateEvent(rowRange, columnRange);
    }

    @Override
    public void deleteCell(GridData.Range rowRange, int columnIndex) {
        int minRowIndex = rowRange.getMinRowIndex();
        int maxRowIndex = rowRange.getMaxRowIndex();
        for (int rowIndex = minRowIndex; rowIndex <= maxRowIndex; ++rowIndex) {
            List modelRow = (List)this.model.getData().get(rowIndex);
            DTCellValue52 modelCell = (DTCellValue52)modelRow.get(columnIndex);
            modelCell.clearValues();
        }
        Set<Integer> columnRange = this.updateDependentEnumerationColumns(rowRange, columnIndex);
        this.fireValidateEvent(rowRange, columnRange);
    }

    private Set<Integer> updateDependentEnumerationColumns(GridData.Range rowRange, int columnIndex) {
        int minRowIndex = rowRange.getMinRowIndex();
        int maxRowIndex = rowRange.getMaxRowIndex();
        DependentEnumsUtilities.Context context = new DependentEnumsUtilities.Context(rowRange.getMinRowIndex(), columnIndex);
        Set<Integer> dependentColumnIndexes = this.dependentEnumsUtilities.getDependentColumnIndexes(context);
        for (int dependentColumnIndex : dependentColumnIndexes) {
            for (int rowIndex = minRowIndex; rowIndex <= maxRowIndex; ++rowIndex) {
                List modelRow = (List)this.model.getData().get(rowIndex);
                DTCellValue52 modelCell = (DTCellValue52)modelRow.get(dependentColumnIndex);
                modelCell.clearValues();
                this.uiModel.deleteCellInternal(rowIndex, dependentColumnIndex);
            }
            this.uiModel.indexColumn(dependentColumnIndex);
        }
        dependentColumnIndexes.add(columnIndex);
        return dependentColumnIndexes;
    }

    @Override
    public void appendColumn(BaseColumn column) throws ModelSynchronizer.MoveColumnVetoException {
        BaseColumnSynchronizer.ColumnMetaDataImpl metaData = new BaseColumnSynchronizer.ColumnMetaDataImpl(column);
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesAppend(metaData)) continue;
            synchronizer.append(metaData);
            break;
        }
        this.fireAfterColumnInsertedEvent(column);
    }

    @Override
    public void appendColumn(Pattern52 pattern, ConditionCol52 column) throws ModelSynchronizer.MoveColumnVetoException {
        ConditionColumnSynchronizer.PatternConditionMetaData metaData = new ConditionColumnSynchronizer.PatternConditionMetaData(pattern, column);
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesAppend(metaData)) continue;
            synchronizer.append(metaData);
            break;
        }
        this.fireAfterColumnInsertedEvent((BaseColumn)column);
    }

    @Override
    public void deleteColumn(BaseColumn column) throws ModelSynchronizer.MoveColumnVetoException {
        int columnIndex = this.model.getExpandedColumns().indexOf(column);
        BaseColumnSynchronizer.ColumnMetaDataImpl metaData = new BaseColumnSynchronizer.ColumnMetaDataImpl(column);
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesDelete(metaData)) continue;
            synchronizer.delete(metaData);
            break;
        }
        this.fireAfterColumnDeletedEvent(columnIndex);
    }

    @Override
    public List<BaseColumnFieldDiff> updateColumn(Pattern52 originalPattern, ConditionCol52 originalColumn, Pattern52 editedPattern, ConditionCol52 editedColumn) throws ModelSynchronizer.MoveColumnVetoException {
        ConditionColumnSynchronizer.PatternConditionMetaData originalMetaData = new ConditionColumnSynchronizer.PatternConditionMetaData(originalPattern, originalColumn);
        ConditionColumnSynchronizer.PatternConditionMetaData editedMetaData = new ConditionColumnSynchronizer.PatternConditionMetaData(editedPattern, editedColumn);
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesUpdate(originalMetaData)) continue;
            return synchronizer.update(originalMetaData, editedMetaData);
        }
        return Collections.emptyList();
    }

    @Override
    public List<BaseColumnFieldDiff> updateColumn(BaseColumn originalColumn, BaseColumn editedColumn) throws ModelSynchronizer.MoveColumnVetoException {
        BaseColumnSynchronizer.ColumnMetaDataImpl originalMetaData = new BaseColumnSynchronizer.ColumnMetaDataImpl(originalColumn);
        BaseColumnSynchronizer.ColumnMetaDataImpl editedMetaData = new BaseColumnSynchronizer.ColumnMetaDataImpl(editedColumn);
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesUpdate(originalMetaData)) continue;
            List<BaseColumnFieldDiff> diffs = synchronizer.update(originalMetaData, editedMetaData);
            boolean isSalienceUseRowNumberUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"useRowNumber", diffs);
            boolean isSalienceUseReverseOrderUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"reverseOrder", diffs);
            if (isSalienceUseRowNumberUpdated || isSalienceUseReverseOrderUpdated) {
                this.systemControlledColumnValuesSynchronizer.updateSystemControlledColumnValues();
            }
            return diffs;
        }
        return Collections.emptyList();
    }

    @Override
    public void appendRow() throws ModelSynchronizer.MoveColumnVetoException {
        RowSynchronizer.RowMetaDataImpl metaData = new RowSynchronizer.RowMetaDataImpl();
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesAppend(metaData)) continue;
            synchronizer.append(metaData);
            break;
        }
        this.fireAppendRowEvent();
        this.systemControlledColumnValuesSynchronizer.appendRow();
        this.fireUpdateColumnDataEvent();
    }

    @Override
    public void insertRow(int rowIndex) throws ModelSynchronizer.MoveColumnVetoException {
        RowSynchronizer.RowMetaDataImpl metaData = new RowSynchronizer.RowMetaDataImpl(rowIndex);
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesInsert(metaData)) continue;
            synchronizer.insert(metaData);
            break;
        }
        this.fireInsertRowEvent(rowIndex);
        this.systemControlledColumnValuesSynchronizer.insertRow(rowIndex);
        this.fireUpdateColumnDataEvent();
    }

    @Override
    public void deleteRow(int rowIndex) throws ModelSynchronizer.MoveColumnVetoException {
        RowSynchronizer.RowMetaDataImpl metaData = new RowSynchronizer.RowMetaDataImpl(rowIndex);
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesDelete(metaData)) continue;
            synchronizer.delete(metaData);
            break;
        }
        this.fireDeleteRowEvent(rowIndex);
        this.systemControlledColumnValuesSynchronizer.deleteRow(rowIndex);
        this.fireUpdateColumnDataEvent();
    }

    @Override
    public void moveColumnTo(final int targetColumnIndex, GridColumn<?> column) throws ModelSynchronizer.MoveColumnVetoException {
        final int sourceColumnIndex = this.uiModel.getColumns().indexOf(column);
        if (sourceColumnIndex == targetColumnIndex) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        final BaseColumn modelColumn = (BaseColumn)this.model.getExpandedColumns().get(sourceColumnIndex);
        ArrayList<BaseSynchronizer.MoveColumnToMetaData> metaData = new ArrayList<BaseSynchronizer.MoveColumnToMetaData>(){
            {
                this.add(new BaseSynchronizer.MoveColumnToMetaDataImpl<BaseColumn>(sourceColumnIndex, targetColumnIndex, modelColumn));
            }
        };
        ArrayList<Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>> handlers = new ArrayList<Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>>();
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesMoveColumnsTo((List<Synchronizer.MetaData>)metaData)) continue;
            handlers.add(synchronizer);
        }
        if (handlers.isEmpty()) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : handlers) {
            synchronizer.moveColumnsTo((List<? extends Synchronizer.MetaData>)metaData);
        }
    }

    @Override
    public void moveColumnsTo(int targetColumnIndex, List<GridColumn<?>> columns) throws ModelSynchronizer.MoveColumnVetoException {
        ArrayList<BaseSynchronizer.MoveColumnToMetaDataImpl<BaseColumn>> metaData = new ArrayList<BaseSynchronizer.MoveColumnToMetaDataImpl<BaseColumn>>();
        for (int index = 0; index < columns.size(); ++index) {
            GridColumn<?> column = columns.get(index);
            int sourceColumnIndex = this.uiModel.getColumns().indexOf(column);
            if (sourceColumnIndex == targetColumnIndex) {
                throw new ModelSynchronizer.MoveColumnVetoException();
            }
            BaseColumn modelColumn = (BaseColumn)this.model.getExpandedColumns().get(sourceColumnIndex);
            metaData.add(new BaseSynchronizer.MoveColumnToMetaDataImpl<BaseColumn>(sourceColumnIndex, targetColumnIndex + index, modelColumn));
        }
        Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> handler = null;
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesMoveColumnsTo(metaData)) continue;
            handler = synchronizer;
            break;
        }
        if (handler == null) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        handler.moveColumnsTo(metaData);
    }

    @Override
    public void moveRowsTo(int targetRowIndex, List<GridRow> rows) throws ModelSynchronizer.MoveColumnVetoException {
        ArrayList<BaseSynchronizer.MoveRowToMetaDataImpl> metaData = new ArrayList<BaseSynchronizer.MoveRowToMetaDataImpl>();
        for (int index = 0; index < rows.size(); ++index) {
            GridRow row = rows.get(index);
            int n = this.uiModel.getRows().indexOf(row);
            if (n == targetRowIndex) {
                throw new ModelSynchronizer.MoveColumnVetoException();
            }
            List modelRow = (List)this.model.getData().get(n);
            metaData.add(new BaseSynchronizer.MoveRowToMetaDataImpl(n, targetRowIndex + index, modelRow));
        }
        ArrayList<Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>> handlers = new ArrayList<Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData>>();
        for (Synchronizer<? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData, ? extends Synchronizer.MetaData> synchronizer : this.synchronizers) {
            if (!synchronizer.handlesMoveRowsTo(metaData)) continue;
            handlers.add(synchronizer);
        }
        if (handlers.isEmpty()) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        for (Synchronizer<Synchronizer.MetaData, Synchronizer.MetaData, Synchronizer.MetaData, Synchronizer.MetaData, Synchronizer.MetaData> synchronizer : handlers) {
            synchronizer.moveRowsTo(metaData);
        }
    }

    @Override
    public void updateSystemControlledColumnValues() {
        this.systemControlledColumnValuesSynchronizer.updateSystemControlledColumnValues();
    }

    @Override
    public void setCellOtherwiseState(int rowIndex, int columnIndex) {
        BaseColumn modelColumn = (BaseColumn)this.model.getExpandedColumns().get(columnIndex);
        DTCellValue52 modelCell = (DTCellValue52)((List)this.model.getData().get(rowIndex)).get(columnIndex);
        modelCell.clearValues();
        modelCell.setOtherwise(true);
        if (modelCell.hasValue()) {
            this.uiModel.setCellInternal(rowIndex, columnIndex, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, modelColumn, this.cellUtilities, this.columnUtilities));
        }
        this.uiModel.indexColumn(columnIndex);
    }

    protected void fireAfterColumnInsertedEvent(BaseColumn column) {
        this.eventBus.fireEvent((GwtEvent)new AfterColumnInserted(column));
    }

    protected void fireAfterColumnDeletedEvent(int columnIndex) {
        this.eventBus.fireEvent((GwtEvent)new AfterColumnDeleted(columnIndex, 1));
    }

    protected void fireAppendRowEvent() {
        this.eventBus.fireEvent((GwtEvent)new AppendRowEvent());
    }

    protected void fireDeleteRowEvent(int rowIndex) {
        this.eventBus.fireEvent((GwtEvent)new DeleteRowEvent(rowIndex));
    }

    protected void fireInsertRowEvent(int rowIndex) {
        this.eventBus.fireEvent((GwtEvent)new InsertRowEvent(rowIndex));
    }

    protected void fireValidateEvent(GridData.Range rowRange, Set<Integer> columnRange) {
        int minRowIndex = rowRange.getMinRowIndex();
        int maxRowIndex = rowRange.getMaxRowIndex();
        ArrayList<Coordinate> updates = new ArrayList<Coordinate>();
        for (Integer columnIndex : columnRange) {
            for (int rowIndex = minRowIndex; rowIndex <= maxRowIndex; ++rowIndex) {
                updates.add(new Coordinate(rowIndex, columnIndex.intValue()));
            }
        }
        ValidateEvent event = new ValidateEvent(updates);
        this.eventBus.fireEvent((GwtEvent)event);
    }

    protected void fireUpdateColumnDataEvent() {
        ArrayList<Object> columnData = new ArrayList<Object>();
        for (int rowIndex = 0; rowIndex < this.model.getData().size(); ++rowIndex) {
            columnData.add(null);
        }
        UpdateColumnDataEvent event = new UpdateColumnDataEvent(0, columnData);
        this.eventBus.fireEvent((GwtEvent)event);
    }
}

