/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.themes;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Line;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Point2DArray;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import java.util.Set;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.themes.GuidedDecisionTableTheme;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public class GuidedDecisionTableRenderer
extends BaseGridRenderer {
    private static final int HEADER_HEIGHT = 96;
    private Severity rowHighlightSeverity;
    private Set<Integer> rowHighlightRowIndexes;

    public GuidedDecisionTableRenderer(GuidedDecisionTableUiModel uiModel, GuidedDecisionTable52 model) {
        super((GridRendererTheme)new GuidedDecisionTableTheme(uiModel, model));
    }

    public double getHeaderHeight() {
        return 96.0;
    }

    public Group renderBody(GridData model, GridBodyRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        Group body = super.renderBody(model, context, rendererHelper, renderingInformation);
        if (this.rowHighlightRowIndexes != null && !this.rowHighlightRowIndexes.isEmpty()) {
            this.renderRowHighlights(body, model, context, rendererHelper, renderingInformation);
        }
        return body;
    }

    public Group renderSelector(double width, double height, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        Group g = new Group();
        Bounds bounds = this.getSelectorBounds(width, height, renderingInformation);
        MultiPath selector = (MultiPath)this.theme.getSelector().M(bounds.getX() + 0.5, bounds.getY() + 0.5).L(bounds.getX() + 0.5, height).L(width, height).L(width, bounds.getY() + 32.0).L(bounds.getX() + 200.0, bounds.getY() + 32.0).L(bounds.getX() + 200.0, bounds.getY() + 0.5).L(bounds.getX() + 200.0, bounds.getY() + 0.5).L(bounds.getX() + 0.5, bounds.getY() + 0.5).setListening(false);
        g.add((IPrimitive)selector);
        return g;
    }

    private Bounds getSelectorBounds(double width, double height, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        double boundsX = 0.0;
        double boundsY = 0.0;
        double boundsWidth = width;
        double boundsHeight = height;
        if (!floatingBlockInformation.getColumns().isEmpty()) {
            boundsX = floatingBlockInformation.getX();
            boundsWidth -= floatingBlockInformation.getX();
        }
        if (renderingInformation.isFloatingHeader()) {
            boundsY = bodyBlockInformation.getHeaderY();
            boundsHeight -= bodyBlockInformation.getHeaderY();
        }
        return new BaseBounds(boundsX, boundsY, boundsWidth, boundsHeight);
    }

    public Group renderHeaderBodyDivider(double width) {
        Group g = new Group();
        Line dividerLine1 = this.theme.getGridHeaderBodyDivider();
        Line dividerLine2 = this.theme.getGridHeaderBodyDivider();
        dividerLine1.setPoints(new Point2DArray(new Point2D(0.0, this.getHeaderHeight() - 1.5), new Point2D[]{new Point2D(width, this.getHeaderHeight() - 1.5)}));
        dividerLine2.setPoints(new Point2DArray(new Point2D(0.0, this.getHeaderHeight() + 0.5), new Point2D[]{new Point2D(width, this.getHeaderHeight() + 0.5)}));
        g.add((IPrimitive)dividerLine1);
        g.add((IPrimitive)dividerLine2);
        return g;
    }

    public void highlightRows(Severity rowHighlightSeverity, Set<Integer> rowHighlightRowIndexes) {
        this.rowHighlightSeverity = rowHighlightSeverity;
        this.rowHighlightRowIndexes = rowHighlightRowIndexes;
    }

    public void clearHighlights() {
        this.rowHighlightSeverity = null;
        this.rowHighlightRowIndexes = null;
    }

    void renderRowHighlights(Group body, GridData model, GridBodyRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        this.rowHighlightRowIndexes.stream().forEach(rowIndex -> {
            int _rowIndex = rowIndex - 1;
            int _visibleRowIndex = _rowIndex - renderingInformation.getMinVisibleRowIndex();
            if (_rowIndex >= 0 && _rowIndex < model.getRowCount() && _visibleRowIndex >= 0 && _visibleRowIndex < model.getRowCount()) {
                body.add((IPrimitive)this.makeRowHighlight(_rowIndex, _visibleRowIndex, model, context, rendererHelper));
            }
        });
    }

    Rectangle makeRowHighlight(int _rowIndex, int _visibleRowIndex, GridData model, GridBodyRenderContext context, BaseGridRendererHelper rendererHelper) {
        Rectangle r = (Rectangle)((Rectangle)((Rectangle)new Rectangle(0.0, 0.0).setAlpha(0.3)).setFillColor((IColor)ColorName.ORANGE)).setListening(false);
        r.setY(rendererHelper.getRowOffset(_visibleRowIndex));
        r.setWidth(rendererHelper.getWidth(context.getBlockColumns()));
        r.setHeight(model.getRow(_rowIndex).getHeight());
        switch (this.rowHighlightSeverity) {
            case NOTE: {
                r.setFillColor((IColor)ColorName.LIGHTBLUE);
                break;
            }
            case WARNING: {
                r.setFillColor((IColor)ColorName.ORANGE);
                break;
            }
            case ERROR: {
                r.setFillColor((IColor)ColorName.RED);
            }
        }
        return r;
    }
}

