/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard;

import com.google.gwt.user.client.ui.Widget;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AbstractGuidedDecisionTableWizardPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.ActionInsertFactFieldsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.ActionSetFieldsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.ColumnExpansionPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.FactPatternConstraintsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.FactPatternsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.ImportsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.RowExpander;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.SummaryPage;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.AbstractWizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;

@Dependent
public class NewGuidedDecisionTableWizard
extends AbstractWizard {
    @Inject
    private SummaryPage summaryPage;
    @Inject
    private ImportsPage importsPage;
    @Inject
    private ColumnExpansionPage columnExpansionPage;
    @Inject
    private FactPatternsPage factPatternsPage;
    @Inject
    private FactPatternConstraintsPage factPatternConstraintsPage;
    @Inject
    private ActionSetFieldsPage actionSetFieldsPage;
    @Inject
    private ActionInsertFactFieldsPage actionInsertFactFieldsPage;
    private final List<WizardPage> pages = new ArrayList<WizardPage>();
    private Path contextPath;
    private GuidedDecisionTable52 model;
    private AsyncPackageDataModelOracle oracle;
    private GuidedDecisionTableWizardHandler handler;

    @PostConstruct
    public void setupPages() {
        this.pages.add(this.summaryPage);
        this.pages.add(this.importsPage);
        this.pages.add(this.factPatternsPage);
        this.pages.add(this.factPatternConstraintsPage);
        this.pages.add(this.actionSetFieldsPage);
        this.pages.add(this.actionInsertFactFieldsPage);
        this.pages.add(this.columnExpansionPage);
    }

    public void setContent(Path contextPath, String baseFileName, GuidedDecisionTable52.TableFormat tableFormat, GuidedDecisionTable52.HitPolicy hitPolicy, AsyncPackageDataModelOracle oracle, GuidedDecisionTableWizardHandler handler) {
        this.model = new GuidedDecisionTable52();
        this.model.setTableFormat(tableFormat);
        this.model.setHitPolicy(hitPolicy);
        if (GuidedDecisionTable52.HitPolicy.RESOLVED_HIT.equals((Object)hitPolicy)) {
            MetadataCol52 metadataCol52 = new MetadataCol52();
            metadataCol52.setMetadata("ResolvedHitPriorityOverRow");
            this.model.getMetadataCols().add(metadataCol52);
        }
        this.contextPath = contextPath;
        this.oracle = oracle;
        this.handler = handler;
        Validator validator = new Validator(this.model.getConditions());
        for (WizardPage page : this.pages) {
            AbstractGuidedDecisionTableWizardPage dtp = (AbstractGuidedDecisionTableWizardPage)page;
            dtp.setContent(contextPath, baseFileName, tableFormat, hitPolicy, oracle, this.model, validator);
            dtp.initialise();
        }
    }

    public String getTitle() {
        return GuidedDecisionTableConstants.INSTANCE.DecisionTableWizard();
    }

    public List<WizardPage> getPages() {
        return this.pages;
    }

    public Widget getPageWidget(int pageNumber) {
        AbstractGuidedDecisionTableWizardPage dtp = (AbstractGuidedDecisionTableWizardPage)this.pages.get(pageNumber);
        Widget w = dtp.asWidget();
        dtp.prepareView();
        return w;
    }

    public int getPreferredHeight() {
        return 500;
    }

    public int getPreferredWidth() {
        return 1150;
    }

    public void isComplete(final Callback<Boolean> callback) {
        callback.callback((Object)true);
        for (WizardPage page : this.pages) {
            page.isComplete((Callback)new Callback<Boolean>(){

                public void callback(Boolean result) {
                    if (Boolean.FALSE.equals(result)) {
                        callback.callback((Object)false);
                    }
                }
            });
        }
    }

    public void complete() {
        for (WizardPage wizardPage : this.pages) {
            AbstractGuidedDecisionTableWizardPage gep = (AbstractGuidedDecisionTableWizardPage)wizardPage;
            gep.makeResult(this.model);
        }
        RowExpander re = new RowExpander(this.model, this.oracle);
        for (Object c : this.model.getExpandedColumns()) {
            re.setExpandColumn((BaseColumn)c, false);
        }
        List<ConditionCol52> list = this.columnExpansionPage.getColumnsToExpand();
        for (ConditionCol52 c : list) {
            re.setExpandColumn((BaseColumn)c, true);
        }
        int rowIndex = 0;
        RowExpander.RowIterator ri = re.iterator();
        while (ri.hasNext()) {
            Object row = ri.next();
            this.model.getData().add(row);
            ((DTCellValue52)((List)this.model.getData().get(rowIndex)).get(0)).setNumericValue(new BigDecimal(rowIndex + 1));
            ++rowIndex;
        }
        String baseFileName = this.summaryPage.getBaseFileName();
        Path contextPath = this.contextPath;
        this.model.setTableName(baseFileName);
        super.complete();
        this.handler.save(contextPath, baseFileName, this.model);
    }

    public void close() {
        super.close();
        this.handler.destroyWizard();
    }

    public static interface GuidedDecisionTableWizardHandler {
        public void save(Path var1, String var2, GuidedDecisionTable52 var3);

        public void destroyWizard();
    }
}

