/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.pages;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactFieldsPattern;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AbstractGuidedDecisionTableWizardPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.ActionInsertFactFieldsPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AvailableField;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.events.ActionInsertFactFieldsDefinedEvent;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.events.DuplicatePatternsEvent;
import org.kie.workbench.common.widgets.client.datamodel.ImportAddedEvent;
import org.kie.workbench.common.widgets.client.datamodel.ImportRemovedEvent;
import org.kie.workbench.common.widgets.client.widget.HumanReadableDataTypes;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class ActionInsertFactFieldsPage
extends AbstractGuidedDecisionTableWizardPage
implements ActionInsertFactFieldsPageView.Presenter {
    @Inject
    private ActionInsertFactFieldsPageView view;
    @Inject
    private Event<DuplicatePatternsEvent> duplicatePatternsEvent;
    @Inject
    private Event<ActionInsertFactFieldsDefinedEvent> actionInsertFactFieldsDefinedEvent;
    @Inject
    private Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;
    private Map<ActionInsertFactFieldsPattern, List<ActionInsertFactCol52>> patternToActionsMap = new IdentityHashMap<ActionInsertFactFieldsPattern, List<ActionInsertFactCol52>>();

    public String getTitle() {
        return GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardActionInsertFacts();
    }

    public void initialise() {
        this.view.init(this);
        this.view.setValidator(this.getValidator());
        this.patternToActionsMap.clear();
        this.getValidator().setPatternToActionInsertFactFieldsMap(this.patternToActionsMap);
        this.view.setDTCellValueWidgetFactory(DTCellValueWidgetFactory.getInstance(this.model, this.oracle, false, this.allowEmptyValues()));
        List<String> availableTypes = Arrays.asList(this.oracle.getFactTypes());
        this.view.setAvailableFactTypes(availableTypes);
        for (ActionCol52 a : this.model.getActionCols()) {
            if (!(a instanceof ActionInsertFactCol52)) continue;
            ActionInsertFactCol52 aif = (ActionInsertFactCol52)a;
            ActionInsertFactFieldsPattern p = this.lookupExistingInsertFactPattern(aif.getBoundName());
            List<ActionInsertFactCol52> actions = this.patternToActionsMap.get(p);
            this.getValidator().addActionPattern((Pattern52)p);
            actions.add(aif);
        }
        this.view.setChosenPatterns(new ArrayList<ActionInsertFactFieldsPattern>());
        this.view.setAvailableFields(new ArrayList<AvailableField>());
        this.view.setChosenFields(new ArrayList<ActionInsertFactCol52>());
        this.content.setWidget((IsWidget)this.view);
    }

    private ActionInsertFactFieldsPattern lookupExistingInsertFactPattern(String boundName) {
        for (ActionInsertFactFieldsPattern p : this.patternToActionsMap.keySet()) {
            if (!p.getBoundName().equals(boundName)) continue;
            return p;
        }
        ActionInsertFactFieldsPattern p = new ActionInsertFactFieldsPattern();
        this.patternToActionsMap.put(p, new ArrayList());
        return p;
    }

    public void prepareView() {
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean arePatternBindingsUnique = this.getValidator().arePatternBindingsUnique();
        DuplicatePatternsEvent event = new DuplicatePatternsEvent(arePatternBindingsUnique);
        this.duplicatePatternsEvent.fire((Object)event);
        boolean areActionInsertFieldsDefined = true;
        block0: for (List<ActionInsertFactCol52> actions : this.patternToActionsMap.values()) {
            for (ActionInsertFactCol52 a : actions) {
                if (this.getValidator().isActionValid((ActionCol52)a)) continue;
                areActionInsertFieldsDefined = false;
                continue block0;
            }
        }
        ActionInsertFactFieldsDefinedEvent eventFactFields = new ActionInsertFactFieldsDefinedEvent(areActionInsertFieldsDefined);
        this.actionInsertFactFieldsDefinedEvent.fire((Object)eventFactFields);
        callback.callback((Object)(arePatternBindingsUnique && areActionInsertFieldsDefined ? 1 : 0));
    }

    public void handleImportAddedEvent(@Observes ImportAddedEvent event) {
        if (!event.getDataModelOracle().equals(this.oracle)) {
            return;
        }
        List<String> availableTypes = Arrays.asList(this.oracle.getFactTypes());
        this.view.setAvailableFactTypes(availableTypes);
    }

    public void handleImportRemovedEvent(@Observes ImportRemovedEvent event) {
        if (!event.getDataModelOracle().equals(this.oracle)) {
            return;
        }
        List<String> availableTypes = Arrays.asList(this.oracle.getFactTypes());
        this.view.setAvailableFactTypes(availableTypes);
    }

    public void onDuplicatePatterns(@Observes DuplicatePatternsEvent event) {
        this.view.setArePatternBindingsUnique(event.getArePatternBindingsUnique());
    }

    public void onActionInsertFactFieldsDefined(@Observes ActionInsertFactFieldsDefinedEvent event) {
        this.view.setAreActionInsertFactFieldsDefined(event.getAreActionInsertFactFieldsDefined());
    }

    @Override
    public void addPattern(ActionInsertFactFieldsPattern pattern) {
        this.patternToActionsMap.put(pattern, new ArrayList());
        this.getValidator().addActionPattern((Pattern52)pattern);
    }

    @Override
    public void removePattern(ActionInsertFactFieldsPattern pattern) {
        this.patternToActionsMap.remove(pattern);
        this.getValidator().removeActionPattern((Pattern52)pattern);
    }

    @Override
    public void selectPattern(final ActionInsertFactFieldsPattern pattern) {
        final String type = pattern.getFactType();
        this.oracle.getFieldCompletions(type, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                ArrayList<AvailableField> availableFields = new ArrayList<AvailableField>();
                for (ModelField modelField : fields) {
                    String fieldName = modelField.getName();
                    String fieldType = ActionInsertFactFieldsPage.this.oracle.getFieldType(type, fieldName);
                    String fieldDisplayType = HumanReadableDataTypes.getUserFriendlyTypeName((String)fieldType);
                    AvailableField field = new AvailableField(fieldName, fieldType, fieldDisplayType, 1);
                    availableFields.add(field);
                }
                ActionInsertFactFieldsPage.this.view.setAvailableFields(availableFields);
                ArrayList<ActionInsertFactCol52> actionsForPattern = (ArrayList<ActionInsertFactCol52>)ActionInsertFactFieldsPage.this.patternToActionsMap.get(pattern);
                if (actionsForPattern == null) {
                    actionsForPattern = new ArrayList<ActionInsertFactCol52>();
                    ActionInsertFactFieldsPage.this.patternToActionsMap.put(pattern, actionsForPattern);
                }
                ActionInsertFactFieldsPage.this.view.setChosenFields(actionsForPattern);
            }
        });
    }

    @Override
    public void makeResult(GuidedDecisionTable52 model) {
        int fi = 1;
        for (Map.Entry<ActionInsertFactFieldsPattern, List<ActionInsertFactCol52>> ps : this.patternToActionsMap.entrySet()) {
            ActionInsertFactFieldsPattern p = ps.getKey();
            if (!this.getValidator().isPatternValid((Pattern52)p)) {
                String binding = "f" + fi++;
                p.setBoundName(binding);
                while (!this.getValidator().isPatternBindingUnique((Pattern52)p)) {
                    binding = "f" + fi++;
                    p.setBoundName(binding);
                }
            }
            String factType = p.getFactType();
            String boundName = p.getBoundName();
            boolean isLogicalInsert = p.isInsertedLogically();
            for (ActionInsertFactCol52 aif : ps.getValue()) {
                aif.setFactType(factType);
                aif.setBoundName(boundName);
                aif.setInsertLogical(isLogicalInsert);
                model.getActionCols().add(aif);
            }
        }
    }

    @Override
    public GuidedDecisionTable52.TableFormat getTableFormat() {
        return this.model.getTableFormat();
    }

    @Override
    public boolean hasEnums(ActionInsertFactCol52 selectedAction) {
        for (Map.Entry<ActionInsertFactFieldsPattern, List<ActionInsertFactCol52>> e : this.patternToActionsMap.entrySet()) {
            if (!e.getValue().contains(selectedAction)) continue;
            String factType = e.getKey().getFactType();
            String factField = selectedAction.getFactField();
            return this.oracle.hasEnums(factType, factField);
        }
        return false;
    }

    @Override
    public void assertDefaultValue(ActionInsertFactCol52 selectedAction) {
        List<String> valueList = Arrays.asList(this.columnUtilities.getValueList((BaseColumn)selectedAction));
        if (valueList.size() > 0) {
            String defaultValue = this.cellUtilities.asString(selectedAction.getDefaultValue());
            if (!valueList.contains(defaultValue)) {
                selectedAction.getDefaultValue().clearValues();
            }
        } else {
            DTCellValue52 defaultValue = selectedAction.getDefaultValue();
            DataType.DataTypes dataType = this.columnUtilities.getDataType((BaseColumn)selectedAction);
            this.cellUtilities.convertDTCellValueType(dataType, defaultValue);
        }
    }

    @Override
    public void stateChanged() {
        WizardPageStatusChangeEvent event = new WizardPageStatusChangeEvent((WizardPage)this);
        this.wizardPageStatusChangeEvent.fire((Object)event);
    }
}

