/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.pages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.rule.HasParameterizedOperator;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AvailableField;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.FactPatternConstraintsPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.MinimumWidthCellList;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.cells.AvailableFieldCell;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.cells.ConditionCell;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.cells.ConditionPatternCell;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.OperatorSelection;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.Radio;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.resources.WizardCellListResources;

@Dependent
public class FactPatternConstraintsPageViewImpl
extends Composite
implements FactPatternConstraintsPageView {
    private FactPatternConstraintsPageView.Presenter presenter;
    private Validator validator;
    private CellUtilities cellUtilities;
    private List<Pattern52> availablePatterns;
    private Pattern52 availablePatternsSelection;
    private MinimumWidthCellList<Pattern52> availablePatternsWidget;
    private Set<AvailableField> availableFieldsSelections;
    private MinimumWidthCellList<AvailableField> availableFieldsWidget;
    private List<ConditionCol52> chosenConditions;
    private ConditionCol52 chosenConditionsSelection;
    private Set<ConditionCol52> chosenConditionsSelections;
    private MinimumWidthCellList<ConditionCol52> chosenConditionsWidget;
    private boolean isOperatorValid;
    private DTCellValueWidgetFactory factory;
    @UiField
    protected ScrollPanel availablePatternsContainer;
    @UiField
    protected ScrollPanel availableFieldsContainer;
    @UiField
    protected ScrollPanel chosenConditionsContainer;
    @UiField
    protected Button btnAdd;
    @UiField
    protected Button btnRemove;
    @UiField
    VerticalPanel conditionDefinition;
    @UiField
    FormGroup calculationType;
    @UiField
    Radio optLiteral;
    @UiField
    Radio optFormula;
    @UiField
    Radio optPredicate;
    @UiField
    TextBox txtColumnHeader;
    @UiField
    HelpBlock txtColumnHeaderHelp;
    @UiField
    FormGroup columnHeaderContainer;
    @UiField
    TextBox txtPredicateExpression;
    @UiField
    FormGroup predicateExpressionContainer;
    @UiField
    FormGroup operatorContainer;
    @UiField
    SimplePanel ddOperatorContainer;
    @UiField
    HelpBlock ddOperatorContainerHelp;
    @UiField
    TextBox txtValueList;
    @UiField
    VerticalPanel criteriaExtendedEntry;
    @UiField
    VerticalPanel criteriaLimitedEntry;
    @UiField
    FormGroup limitedEntryValueContainer;
    @UiField
    SimplePanel limitedEntryValueWidgetContainer;
    @UiField
    FormGroup defaultValueContainer;
    @UiField
    SimplePanel defaultValueWidgetContainer;
    @UiField(provided=true)
    Button btnMoveUp = new Button(){
        {
            this.setIcon(IconType.ANGLE_UP);
        }
    };
    @UiField(provided=true)
    Button btnMoveDown = new Button(){
        {
            this.setIcon(IconType.ANGLE_DOWN);
        }
    };
    @Inject
    private ConditionPatternCell availableConditionsCell;
    @Inject
    private ConditionCell chosenConditionsCell;
    private static FactPatternConstraintsPageWidgetBinder uiBinder = (FactPatternConstraintsPageWidgetBinder)GWT.create(FactPatternConstraintsPageWidgetBinder.class);

    public FactPatternConstraintsPageViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @PostConstruct
    public void setup() {
        this.availablePatternsWidget = new MinimumWidthCellList(this.availableConditionsCell, (CellList.Resources)WizardCellListResources.INSTANCE);
        this.availableFieldsWidget = new MinimumWidthCellList(new AvailableFieldCell(), (CellList.Resources)WizardCellListResources.INSTANCE);
        this.chosenConditionsWidget = new MinimumWidthCellList(this.chosenConditionsCell, (CellList.Resources)WizardCellListResources.INSTANCE);
        this.initialiseAvailablePatterns();
        this.initialiseAvailableFields();
        this.initialiseChosenFields();
        this.initialiseCalculationTypes();
        this.initialiseColumnHeader();
        this.initialisePredicateExpression();
        this.initialiseValueList();
        this.initialiseShufflers();
    }

    @Override
    public void setValidator(Validator validator) {
        this.validator = validator;
        this.availableConditionsCell.setValidator(validator);
        this.chosenConditionsCell.setValidator(validator);
    }

    @Override
    public void setDTCellValueUtilities(CellUtilities cellUtils) {
        this.cellUtilities = cellUtils;
    }

    private void initialiseAvailablePatterns() {
        this.availablePatternsContainer.add(this.availablePatternsWidget);
        this.availablePatternsWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.availablePatternsWidget.setMinimumWidth(170);
        Label lstEmpty = new Label(GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardNoAvailablePatterns());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.availablePatternsWidget.setEmptyListWidget((Widget)lstEmpty);
        final SingleSelectionModel selectionModel = new SingleSelectionModel();
        this.availablePatternsWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                FactPatternConstraintsPageViewImpl.this.availablePatternsSelection = (Pattern52)selectionModel.getSelectedObject();
                FactPatternConstraintsPageViewImpl.this.presenter.selectPattern(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection);
            }
        });
    }

    private void initialiseAvailableFields() {
        this.availableFieldsContainer.add(this.availableFieldsWidget);
        this.availableFieldsWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.availableFieldsWidget.setMinimumWidth(170);
        Label lstEmpty = new Label(GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardNoAvailableFields());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.availableFieldsWidget.setEmptyListWidget((Widget)lstEmpty);
        final MultiSelectionModel selectionModel = new MultiSelectionModel();
        this.availableFieldsWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                FactPatternConstraintsPageViewImpl.this.availableFieldsSelections = selectionModel.getSelectedSet();
                FactPatternConstraintsPageViewImpl.this.btnAdd.setEnabled(FactPatternConstraintsPageViewImpl.this.availableFieldsSelections.size() > 0);
            }
        });
    }

    private void initialiseChosenFields() {
        this.chosenConditionsContainer.add(this.chosenConditionsWidget);
        this.chosenConditionsWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.chosenConditionsWidget.setMinimumWidth(170);
        Label lstEmpty = new Label(GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardNoChosenFields());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.chosenConditionsWidget.setEmptyListWidget((Widget)lstEmpty);
        final MultiSelectionModel selectionModel = new MultiSelectionModel();
        this.chosenConditionsWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                FactPatternConstraintsPageViewImpl.this.chosenConditionsSelections = new HashSet();
                Set selections = selectionModel.getSelectedSet();
                for (ConditionCol52 c : selections) {
                    FactPatternConstraintsPageViewImpl.this.chosenConditionsSelections.add(c);
                }
                this.chosenConditionsSelected(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelections);
            }

            private void chosenConditionsSelected(Set<ConditionCol52> cws) {
                FactPatternConstraintsPageViewImpl.this.btnRemove.setEnabled(true);
                if (cws.size() == 1) {
                    FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection = cws.iterator().next();
                    FactPatternConstraintsPageViewImpl.this.conditionDefinition.setVisible(true);
                    FactPatternConstraintsPageViewImpl.this.validateConditionHeader();
                    FactPatternConstraintsPageViewImpl.this.validateConditionOperator();
                    this.populateConditionDefinition();
                    FactPatternConstraintsPageViewImpl.this.enableMoveUpButton();
                    FactPatternConstraintsPageViewImpl.this.enableMoveDownButton();
                } else {
                    FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection = null;
                    FactPatternConstraintsPageViewImpl.this.conditionDefinition.setVisible(false);
                    FactPatternConstraintsPageViewImpl.this.optLiteral.setEnabled(false);
                    FactPatternConstraintsPageViewImpl.this.optFormula.setEnabled(false);
                    FactPatternConstraintsPageViewImpl.this.optPredicate.setEnabled(false);
                    FactPatternConstraintsPageViewImpl.this.txtColumnHeader.setEnabled(false);
                    FactPatternConstraintsPageViewImpl.this.txtValueList.setEnabled(false);
                    FactPatternConstraintsPageViewImpl.this.defaultValueContainer.setVisible(false);
                    FactPatternConstraintsPageViewImpl.this.btnMoveUp.setEnabled(false);
                    FactPatternConstraintsPageViewImpl.this.btnMoveDown.setEnabled(false);
                }
            }

            private void displayCalculationTypes(Pattern52 selectedPattern, ConditionCol52 selectedCondition) {
                boolean isPredicate = selectedCondition.getConstraintValueType() == 5;
                boolean hasEnum = FactPatternConstraintsPageViewImpl.this.presenter.hasEnum(selectedPattern, selectedCondition);
                FactPatternConstraintsPageViewImpl.this.calculationType.setVisible(!isPredicate);
                FactPatternConstraintsPageViewImpl.this.optLiteral.setEnabled(!isPredicate);
                FactPatternConstraintsPageViewImpl.this.optLiteral.setVisible(!isPredicate);
                FactPatternConstraintsPageViewImpl.this.optFormula.setEnabled(!isPredicate && !hasEnum);
                FactPatternConstraintsPageViewImpl.this.optFormula.setVisible(!isPredicate);
                FactPatternConstraintsPageViewImpl.this.operatorContainer.setVisible(!isPredicate);
                FactPatternConstraintsPageViewImpl.this.optPredicate.setEnabled(isPredicate);
                FactPatternConstraintsPageViewImpl.this.optPredicate.setVisible(isPredicate);
                FactPatternConstraintsPageViewImpl.this.txtPredicateExpression.setEnabled(isPredicate);
                FactPatternConstraintsPageViewImpl.this.predicateExpressionContainer.setVisible(isPredicate);
            }

            private void populateConditionDefinition() {
                FactPatternConstraintsPageViewImpl.this.txtColumnHeader.setEnabled(true);
                FactPatternConstraintsPageViewImpl.this.txtColumnHeader.setText(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.getHeader());
                FactPatternConstraintsPageViewImpl.this.presenter.getOperatorCompletions(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection, new Callback<String[]>(){

                    public void callback(String[] ops) {
                        this.doPopulateConditionDefinition(ops);
                    }
                });
            }

            private void doPopulateConditionDefinition(String[] ops) {
                CEPOperatorsDropdown ddOperator = new CEPOperatorsDropdown(ops, (HasParameterizedOperator)FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                FactPatternConstraintsPageViewImpl.this.ddOperatorContainer.setWidget((Widget)ddOperator);
                FactPatternConstraintsPageViewImpl.this.criteriaExtendedEntry.setVisible(FactPatternConstraintsPageViewImpl.this.presenter.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
                FactPatternConstraintsPageViewImpl.this.criteriaLimitedEntry.setVisible(FactPatternConstraintsPageViewImpl.this.presenter.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
                switch (FactPatternConstraintsPageViewImpl.this.presenter.getTableFormat()) {
                    case EXTENDED_ENTRY: {
                        FactPatternConstraintsPageViewImpl.this.txtValueList.setEnabled(!FactPatternConstraintsPageViewImpl.this.presenter.requiresValueList(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection));
                        FactPatternConstraintsPageViewImpl.this.txtValueList.setText(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.getValueList());
                        FactPatternConstraintsPageViewImpl.this.makeDefaultValueWidget();
                        FactPatternConstraintsPageViewImpl.this.defaultValueContainer.setVisible(FactPatternConstraintsPageViewImpl.this.validator.doesOperatorNeedValue(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection));
                        if (FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.getConstraintValueType() == 5) {
                            FactPatternConstraintsPageViewImpl.this.txtPredicateExpression.setText(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.getFactField());
                        }
                        ddOperator.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<OperatorSelection>(){

                            public void onValueChange(ValueChangeEvent<OperatorSelection> event) {
                                FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.setOperator(((OperatorSelection)event.getValue()).getValue());
                                boolean requiresValueList = FactPatternConstraintsPageViewImpl.this.presenter.requiresValueList(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                                FactPatternConstraintsPageViewImpl.this.txtValueList.setEnabled(requiresValueList);
                                if (!requiresValueList) {
                                    FactPatternConstraintsPageViewImpl.this.txtValueList.setText("");
                                } else {
                                    FactPatternConstraintsPageViewImpl.this.txtValueList.setText(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.getValueList());
                                }
                                FactPatternConstraintsPageViewImpl.this.presenter.stateChanged();
                                FactPatternConstraintsPageViewImpl.this.validateConditionOperator();
                                FactPatternConstraintsPageViewImpl.this.makeDefaultValueWidget();
                                FactPatternConstraintsPageViewImpl.this.defaultValueContainer.setVisible(FactPatternConstraintsPageViewImpl.this.validator.doesOperatorNeedValue(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection));
                            }
                        });
                        switch (FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.getConstraintValueType()) {
                            case 1: {
                                FactPatternConstraintsPageViewImpl.this.optLiteral.setValue(Boolean.valueOf(true));
                                this.displayCalculationTypes(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                                break;
                            }
                            case 3: {
                                FactPatternConstraintsPageViewImpl.this.optFormula.setValue(Boolean.valueOf(true));
                                this.displayCalculationTypes(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                                break;
                            }
                            case 5: {
                                FactPatternConstraintsPageViewImpl.this.optPredicate.setValue(Boolean.valueOf(true));
                                this.displayCalculationTypes(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                            }
                        }
                        break;
                    }
                    case LIMITED_ENTRY: {
                        FactPatternConstraintsPageViewImpl.this.calculationType.setVisible(false);
                        this.makeLimitedValueWidget();
                        ddOperator.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<OperatorSelection>(){

                            public void onValueChange(ValueChangeEvent<OperatorSelection> event) {
                                FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.setOperator(((OperatorSelection)event.getValue()).getValue());
                                FactPatternConstraintsPageViewImpl.this.validateConditionOperator();
                                this.makeLimitedValueWidget();
                                FactPatternConstraintsPageViewImpl.this.presenter.stateChanged();
                            }
                        });
                    }
                }
            }

            private void makeLimitedValueWidget() {
                if (!(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection instanceof LimitedEntryConditionCol52)) {
                    return;
                }
                LimitedEntryConditionCol52 lec = (LimitedEntryConditionCol52)FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection;
                boolean doesOperatorNeedValue = FactPatternConstraintsPageViewImpl.this.validator.doesOperatorNeedValue(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                if (!doesOperatorNeedValue) {
                    FactPatternConstraintsPageViewImpl.this.limitedEntryValueContainer.setVisible(false);
                    lec.setValue(null);
                    return;
                }
                FactPatternConstraintsPageViewImpl.this.limitedEntryValueContainer.setVisible(true);
                if (lec.getValue() == null) {
                    lec.setValue(FactPatternConstraintsPageViewImpl.this.factory.makeNewValue((DTColumnConfig52)FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection));
                }
                FactPatternConstraintsPageViewImpl.this.limitedEntryValueWidgetContainer.setWidget(FactPatternConstraintsPageViewImpl.this.factory.getWidget(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection, lec.getValue()));
            }
        });
    }

    private void makeDefaultValueWidget() {
        DTCellValue52 defaultValue = this.chosenConditionsSelection.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = this.factory.makeNewValue((DTColumnConfig52)this.chosenConditionsSelection);
            this.chosenConditionsSelection.setDefaultValue(defaultValue);
        }
        if (!this.validator.doesOperatorAcceptCommaSeparatedValues(this.chosenConditionsSelection)) {
            this.cellUtilities.removeCommaSeparatedValue(defaultValue);
        }
        this.defaultValueWidgetContainer.setWidget(this.factory.getWidget(this.availablePatternsSelection, this.chosenConditionsSelection, defaultValue));
    }

    private void validateConditionHeader() {
        if (this.validator.isConditionHeaderValid(this.chosenConditionsSelection)) {
            this.txtColumnHeaderHelp.setVisible(false);
            this.columnHeaderContainer.removeStyleName(ValidationState.ERROR.getCssName());
        } else {
            this.txtColumnHeaderHelp.setVisible(true);
            this.columnHeaderContainer.addStyleName(ValidationState.ERROR.getCssName());
        }
    }

    private void validateConditionOperator() {
        this.isOperatorValid = this.validator.isConditionOperatorValid(this.chosenConditionsSelection);
        if (this.isOperatorValid) {
            this.ddOperatorContainerHelp.setVisible(false);
            this.operatorContainer.removeStyleName(ValidationState.ERROR.getCssName());
        } else {
            this.ddOperatorContainerHelp.setVisible(true);
            this.operatorContainer.addStyleName(ValidationState.ERROR.getCssName());
        }
    }

    private void initialiseCalculationTypes() {
        this.optLiteral.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.setConstraintValueType(1);
                FactPatternConstraintsPageViewImpl.this.chosenConditionsWidget.redraw();
                FactPatternConstraintsPageViewImpl.this.presenter.assertDefaultValue(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                FactPatternConstraintsPageViewImpl.this.makeDefaultValueWidget();
            }
        });
        this.optFormula.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.setConstraintValueType(3);
                FactPatternConstraintsPageViewImpl.this.chosenConditionsWidget.redraw();
                FactPatternConstraintsPageViewImpl.this.presenter.assertDefaultValue(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                FactPatternConstraintsPageViewImpl.this.makeDefaultValueWidget();
            }
        });
        this.optPredicate.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.setConstraintValueType(5);
                FactPatternConstraintsPageViewImpl.this.chosenConditionsWidget.redraw();
                FactPatternConstraintsPageViewImpl.this.presenter.assertDefaultValue(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                FactPatternConstraintsPageViewImpl.this.makeDefaultValueWidget();
            }
        });
    }

    private void initialiseColumnHeader() {
        this.txtColumnHeader.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String header = FactPatternConstraintsPageViewImpl.this.txtColumnHeader.getText();
                FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.setHeader(header);
                FactPatternConstraintsPageViewImpl.this.presenter.stateChanged();
                FactPatternConstraintsPageViewImpl.this.validateConditionHeader();
            }
        });
    }

    private void initialisePredicateExpression() {
        this.txtPredicateExpression.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String expression = FactPatternConstraintsPageViewImpl.this.txtPredicateExpression.getText();
                FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.setFactField(expression);
                FactPatternConstraintsPageViewImpl.this.chosenConditionsWidget.redraw();
            }
        });
    }

    private void initialiseValueList() {
        this.txtValueList.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String valueList = FactPatternConstraintsPageViewImpl.this.txtValueList.getText();
                FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection.setValueList(valueList);
            }
        });
        this.txtValueList.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                FactPatternConstraintsPageViewImpl.this.presenter.assertDefaultValue(FactPatternConstraintsPageViewImpl.this.availablePatternsSelection, FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                FactPatternConstraintsPageViewImpl.this.makeDefaultValueWidget();
            }
        });
    }

    private void initialiseShufflers() {
        this.btnMoveUp.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int index = FactPatternConstraintsPageViewImpl.this.chosenConditions.indexOf(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                ConditionCol52 c = (ConditionCol52)FactPatternConstraintsPageViewImpl.this.chosenConditions.remove(index);
                FactPatternConstraintsPageViewImpl.this.chosenConditions.add(index - 1, c);
                FactPatternConstraintsPageViewImpl.this.setChosenConditions(FactPatternConstraintsPageViewImpl.this.chosenConditions);
                FactPatternConstraintsPageViewImpl.this.availablePatternsSelection.setChildColumns(FactPatternConstraintsPageViewImpl.this.chosenConditions);
            }
        });
        this.btnMoveDown.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int index = FactPatternConstraintsPageViewImpl.this.chosenConditions.indexOf(FactPatternConstraintsPageViewImpl.this.chosenConditionsSelection);
                ConditionCol52 c = (ConditionCol52)FactPatternConstraintsPageViewImpl.this.chosenConditions.remove(index);
                FactPatternConstraintsPageViewImpl.this.chosenConditions.add(index + 1, c);
                FactPatternConstraintsPageViewImpl.this.setChosenConditions(FactPatternConstraintsPageViewImpl.this.chosenConditions);
                FactPatternConstraintsPageViewImpl.this.availablePatternsSelection.setChildColumns(FactPatternConstraintsPageViewImpl.this.chosenConditions);
            }
        });
    }

    private void enableMoveUpButton() {
        if (this.chosenConditions == null || this.chosenConditionsSelection == null) {
            this.btnMoveUp.setEnabled(false);
            return;
        }
        int index = this.chosenConditions.indexOf(this.chosenConditionsSelection);
        this.btnMoveUp.setEnabled(index > 0);
    }

    private void enableMoveDownButton() {
        if (this.chosenConditions == null || this.chosenConditionsSelection == null) {
            this.btnMoveDown.setEnabled(false);
            return;
        }
        int index = this.chosenConditions.indexOf(this.chosenConditionsSelection);
        this.btnMoveDown.setEnabled(index < this.chosenConditions.size() - 1);
    }

    public void init(FactPatternConstraintsPageView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setDTCellValueWidgetFactory(DTCellValueWidgetFactory factory) {
        this.factory = factory;
    }

    @Override
    public void setAreConditionsDefined(boolean areConditionsDefined) {
        this.chosenConditionsWidget.redraw();
        this.availablePatternsWidget.redraw();
    }

    @Override
    public void setArePatternBindingsUnique(boolean arePatternBindingsUnique) {
        this.availablePatternsWidget.redraw();
    }

    @Override
    public void setAvailablePatterns(List<Pattern52> patterns) {
        this.availablePatterns = patterns;
        this.availablePatternsWidget.setRowCount(this.availablePatterns.size(), true);
        this.availablePatternsWidget.setRowData(this.availablePatterns);
        if (this.availablePatternsSelection != null) {
            if (!this.availablePatterns.contains(this.availablePatternsSelection)) {
                this.availablePatternsWidget.getSelectionModel().setSelected((Object)this.availablePatternsSelection, false);
                this.availablePatternsSelection = null;
                this.setAvailableFields(new ArrayList<AvailableField>());
                this.availableFieldsSelections = null;
                this.setChosenConditions(new ArrayList<ConditionCol52>());
                this.chosenConditionsSelection = null;
                this.conditionDefinition.setVisible(false);
            }
        } else {
            this.setAvailableFields(new ArrayList<AvailableField>());
            this.setChosenConditions(new ArrayList<ConditionCol52>());
        }
    }

    @Override
    public void setAvailableFields(List<AvailableField> fields) {
        this.availableFieldsWidget.setRowCount(fields.size(), true);
        this.availableFieldsWidget.setRowData(fields);
    }

    @Override
    public void setChosenConditions(List<ConditionCol52> conditions) {
        this.chosenConditions = conditions;
        this.chosenConditionsWidget.setRowCount(conditions.size(), true);
        this.chosenConditionsWidget.setRowData(conditions);
        this.conditionDefinition.setVisible(conditions.contains(this.chosenConditionsSelection));
        this.enableMoveUpButton();
        this.enableMoveDownButton();
        this.presenter.stateChanged();
    }

    @UiHandler(value={"btnAdd"})
    public void btnAddClick(ClickEvent event) {
        for (AvailableField f : this.availableFieldsSelections) {
            this.chosenConditions.add(this.makeNewConditionColumn(f));
        }
        this.setChosenConditions(this.chosenConditions);
        this.availablePatternsSelection.setChildColumns(this.chosenConditions);
        this.presenter.stateChanged();
    }

    private ConditionCol52 makeNewConditionColumn(AvailableField f) {
        GuidedDecisionTable52.TableFormat format = this.presenter.getTableFormat();
        if (format == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            ConditionCol52 c = new ConditionCol52();
            c.setFactField(f.getName());
            c.setFieldType(f.getType());
            c.setConstraintValueType(f.getCalculationType());
            return c;
        }
        LimitedEntryConditionCol52 c = new LimitedEntryConditionCol52();
        c.setFactField(f.getName());
        c.setFieldType(f.getType());
        c.setConstraintValueType(1);
        return c;
    }

    @UiHandler(value={"btnRemove"})
    public void btnRemoveClick(ClickEvent event) {
        if (this.chosenConditions.size() == this.chosenConditionsSelections.size() && !this.validator.canPatternBeRemoved(this.availablePatternsSelection)) {
            if (this.chosenConditions.size() == 1) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.UnableToDeleteConditionColumn0(this.chosenConditions.get(0).getHeader()));
            } else {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.UnableToDeleteConditionColumns());
            }
            return;
        }
        for (ConditionCol52 c : this.chosenConditionsSelections) {
            this.chosenConditions.remove(c);
        }
        this.chosenConditionsSelections.clear();
        this.setChosenConditions(this.chosenConditions);
        this.availablePatternsSelection.setChildColumns(this.chosenConditions);
        this.presenter.stateChanged();
        this.txtColumnHeader.setText("");
        this.txtValueList.setText("");
        this.defaultValueContainer.setVisible(false);
        this.conditionDefinition.setVisible(false);
        this.btnRemove.setEnabled(false);
    }

    static interface FactPatternConstraintsPageWidgetBinder
    extends UiBinder<Widget, FactPatternConstraintsPageViewImpl> {
    }
}

