/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.pages;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.AbstractGuidedDecisionTableWizardPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.pages.ImportsPageView;
import org.kie.workbench.common.widgets.client.datamodel.ImportAddedEvent;
import org.kie.workbench.common.widgets.client.datamodel.ImportRemovedEvent;
import org.uberfire.client.callbacks.Callback;

@Dependent
public class ImportsPage
extends AbstractGuidedDecisionTableWizardPage
implements ImportsPageView.Presenter {
    @Inject
    private ImportsPageView view;
    @Inject
    private Event<ImportAddedEvent> importAddedEvent;
    @Inject
    private Event<ImportRemovedEvent> importRemovedEvent;
    private Validator validator;

    public String getTitle() {
        return GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardImports();
    }

    public void initialise() {
        this.view.init(this);
        List<String> chosenImports = this.getChosenImports();
        List<String> availableImports = Arrays.asList(this.oracle.getExternalFactTypes());
        this.view.setChosenImports(chosenImports);
        this.view.setAvailableImports(availableImports);
        this.validator = this.getValidator();
        this.content.setWidget((IsWidget)this.view);
    }

    private List<String> getChosenImports() {
        ArrayList<String> imports = new ArrayList<String>();
        for (Import imp : this.model.getImports().getImports()) {
            imports.add(imp.getType());
        }
        return imports;
    }

    public void prepareView() {
    }

    public void isComplete(Callback<Boolean> callback) {
        callback.callback((Object)true);
    }

    @Override
    public void addImport(String fqcn) {
        Import addedImport = new Import(fqcn);
        this.model.getImports().addImport(addedImport);
        this.oracle.filter(this.model.getImports());
        this.importAddedEvent.fire((Object)new ImportAddedEvent(this.oracle, addedImport));
    }

    @Override
    public boolean removeImport(String fqcn) {
        if (this.validator.isTypeUsed(fqcn)) {
            return false;
        }
        Import removedImport = new Import(fqcn);
        this.model.getImports().removeImport(removedImport);
        this.oracle.filter(this.model.getImports());
        this.importRemovedEvent.fire((Object)new ImportRemovedEvent(this.oracle, removedImport));
        return true;
    }

    @Override
    public void makeResult(GuidedDecisionTable52 model) {
    }
}

