/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.user.client.ui.Image;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.ActionColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.ActionInsertFactPopup;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class})
public class ActionInsertFactPopupTest {
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private ActionColumnCommand refreshGrid;
    private ActionInsertFactPopup popup;

    @BeforeClass
    public static void setupApplicationPreferences() {
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd-MM-yyyy");
            }
        });
    }

    private void setup(GuidedDecisionTable52 model, ActionInsertFactCol52 column, boolean isNew, boolean isReadOnly) {
        this.popup = (ActionInsertFactPopup)Mockito.spy((Object)new ActionInsertFactPopup(model, this.oracle, this.presenter, this.refreshGrid, column, isNew, isReadOnly){

            protected Image getEditImage() {
                return (Image)Mockito.mock(Image.class);
            }

            protected Image getEditDisabledImage() {
                return (Image)Mockito.mock(Image.class);
            }
        });
    }

    @Test
    public void noPatternSelected() {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        model.getActionCols().add(column);
        this.setup(model, column, false, false);
        this.popup.doFieldLabel();
        ((ActionInsertFactPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).setFieldLabelPleaseChooseFactType();
        ((ActionInsertFactPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelPleaseSelectAField();
        ((ActionInsertFactPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelToFieldName((String)Mockito.any(String.class));
    }

    @Test
    public void patternSelectedNoFieldSelected() {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        column.setBoundName("$a");
        model.getActionCols().add(column);
        this.setup(model, column, false, false);
        this.popup.doFieldLabel();
        ((ActionInsertFactPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelPleaseChooseFactType();
        ((ActionInsertFactPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).setFieldLabelPleaseSelectAField();
        ((ActionInsertFactPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelToFieldName((String)Mockito.any(String.class));
    }

    @Test
    public void patternSelectedFieldSelected() {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        column.setBoundName("$a");
        column.setFactType("MyFact");
        column.setFactField("myField");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)"MyFact"), (String)Mockito.eq((Object)"myField"))).thenReturn((Object)"String");
        model.getActionCols().add(column);
        this.setup(model, column, false, false);
        this.popup.doFieldLabel();
        ((ActionInsertFactPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelPleaseChooseFactType();
        ((ActionInsertFactPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).setFieldLabelPleaseSelectAField();
        ((ActionInsertFactPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).setFieldLabelToFieldName((String)Mockito.any(String.class));
    }
}

