/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.screens.guided.dtable.client.widget.HideColumnCheckBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class HideColumnCheckBoxTest {
    HideColumnCheckBox box;
    @Mock
    DTColumnConfig52 column;
    @Captor
    ArgumentCaptor<ClickHandler> clickCaptor;

    @Before
    public void setUp() throws Exception {
        this.box = (HideColumnCheckBox)Mockito.spy((Object)new HideColumnCheckBox());
    }

    @Test
    public void testInitChecked() throws Exception {
        Mockito.when((Object)this.column.isHideColumn()).thenReturn((Object)true);
        this.box.init(this.column);
        ((HideColumnCheckBox)Mockito.verify((Object)this.box)).setValue(Boolean.valueOf(true));
        ((HideColumnCheckBox)Mockito.verify((Object)this.box, (VerificationMode)Mockito.never())).setValue(Boolean.valueOf(false));
    }

    @Test
    public void testInitUnchecked() throws Exception {
        Mockito.when((Object)this.column.isHideColumn()).thenReturn((Object)false);
        this.box.init(this.column);
        ((HideColumnCheckBox)Mockito.verify((Object)this.box)).setValue(Boolean.valueOf(false));
        ((HideColumnCheckBox)Mockito.verify((Object)this.box, (VerificationMode)Mockito.never())).setValue(Boolean.valueOf(true));
    }

    @Test
    public void testClickHandlerChecked() throws Exception {
        Mockito.when((Object)this.box.getValue()).thenReturn((Object)true);
        this.box.init(this.column);
        ((HideColumnCheckBox)Mockito.verify((Object)this.box)).addClickHandler((ClickHandler)this.clickCaptor.capture());
        ((ClickHandler)this.clickCaptor.getValue()).onClick(null);
        ((DTColumnConfig52)Mockito.verify((Object)this.column)).setHideColumn(true);
        ((DTColumnConfig52)Mockito.verify((Object)this.column, (VerificationMode)Mockito.never())).setHideColumn(false);
    }

    @Test
    public void testClickHandlerUnchecked() throws Exception {
        Mockito.when((Object)this.box.getValue()).thenReturn((Object)false);
        this.box.init(this.column);
        ((HideColumnCheckBox)Mockito.verify((Object)this.box)).addClickHandler((ClickHandler)this.clickCaptor.capture());
        ((ClickHandler)this.clickCaptor.getValue()).onClick(null);
        ((DTColumnConfig52)Mockito.verify((Object)this.column)).setHideColumn(false);
        ((DTColumnConfig52)Mockito.verify((Object)this.column, (VerificationMode)Mockito.never())).setHideColumn(true);
    }
}

