/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AfterColumnDeleted;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AfterColumnInserted;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AnalyzerControllerImpl;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.Events;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.ValidateEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.AppendRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.InsertRowEvent;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.UpdateColumnDataEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class EventsTest {
    @Mock
    EventBus eventBus;
    @Mock
    AnalyzerControllerImpl analyzerController;
    Events events;

    @Before
    public void setUp() throws Exception {
        this.events = new Events(this.eventBus, this.analyzerController);
    }

    @Test
    public void setUpWorksOnlyOnce() throws Exception {
        this.events.setup();
        ((EventBus)Mockito.verify((Object)this.eventBus)).addHandler(ValidateEvent.TYPE, (EventHandler)this.analyzerController);
        Mockito.reset((Object[])new EventBus[]{this.eventBus});
        this.events.setup();
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).addHandler(ValidateEvent.TYPE, (EventHandler)this.analyzerController);
    }

    @Test
    public void tearDownRemovesHandlers() throws Exception {
        HandlerRegistration registration = (HandlerRegistration)Mockito.mock(HandlerRegistration.class);
        Mockito.when((Object)this.eventBus.addHandler(ValidateEvent.TYPE, (EventHandler)this.analyzerController)).thenReturn((Object)registration);
        this.mockOtherEventHandlerRegistrations();
        this.events.setup();
        this.events.teardown();
        ((HandlerRegistration)Mockito.verify((Object)registration)).removeHandler();
    }

    private void mockOtherEventHandlerRegistrations() {
        Mockito.when((Object)this.eventBus.addHandler(DeleteRowEvent.TYPE, (EventHandler)this.analyzerController)).thenReturn(Mockito.mock(HandlerRegistration.class));
        Mockito.when((Object)this.eventBus.addHandler(AfterColumnDeleted.TYPE, (EventHandler)this.analyzerController)).thenReturn(Mockito.mock(HandlerRegistration.class));
        Mockito.when((Object)this.eventBus.addHandler(UpdateColumnDataEvent.TYPE, (EventHandler)this.analyzerController)).thenReturn(Mockito.mock(HandlerRegistration.class));
        Mockito.when((Object)this.eventBus.addHandler(AppendRowEvent.TYPE, (EventHandler)this.analyzerController)).thenReturn(Mockito.mock(HandlerRegistration.class));
        Mockito.when((Object)this.eventBus.addHandler(InsertRowEvent.TYPE, (EventHandler)this.analyzerController)).thenReturn(Mockito.mock(HandlerRegistration.class));
        Mockito.when((Object)this.eventBus.addHandler(AfterColumnInserted.TYPE, (EventHandler)this.analyzerController)).thenReturn(Mockito.mock(HandlerRegistration.class));
    }
}

