/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerViewImpl;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.AttributeColumnConfigRowView;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.common.DecoratedDisclosurePanel;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTableModellerViewImplTest {
    @Mock
    GuidedDecisionTableModellerView.Presenter presenter;
    @Mock
    GuidedDecisionTableModellerViewImpl view;
    @Mock
    VerticalPanel attributeConfigWidget;
    @Mock
    DecoratedDisclosurePanel disclosurePanelAttributes;
    @Mock
    AttributeCol52 attributeColumn;
    @Mock
    DTCellValue52 defaultValue;
    List<AttributeCol52> columns;

    @Before
    public void setUp() throws Exception {
        ((GuidedDecisionTableModellerViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).init(this.presenter);
        ((GuidedDecisionTableModellerViewImpl)Mockito.doCallRealMethod().when((Object)this.view)).refreshAttributeWidget(Matchers.anyList());
        this.view.init(this.presenter);
        this.view.attributeConfigWidget = this.attributeConfigWidget;
        this.view.disclosurePanelAttributes = this.disclosurePanelAttributes;
        Mockito.when((Object)this.attributeColumn.getAttribute()).thenReturn((Object)"salience");
        Mockito.when((Object)this.attributeColumn.getDefaultValue()).thenReturn((Object)this.defaultValue);
        this.columns = new ArrayList<AttributeCol52>();
        this.columns.add(this.attributeColumn);
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd/mm/yy");
        ApplicationPreferences.setUp(preferences);
    }

    @Test
    public void testRefreshAttributeWidgetEmpty() throws Exception {
        this.columns.clear();
        this.view.refreshAttributeWidget(this.columns);
        ((VerticalPanel)Mockito.verify((Object)this.attributeConfigWidget)).clear();
        ((DecoratedDisclosurePanel)Mockito.verify((Object)this.disclosurePanelAttributes)).setOpen(false);
        ((VerticalPanel)Mockito.verify((Object)this.attributeConfigWidget, (VerificationMode)Mockito.never())).add((Widget)Matchers.any(Widget.class));
    }

    @Test
    public void testRefreshAttributeWidget() throws Exception {
        this.view.refreshAttributeWidget(this.columns);
        ((VerticalPanel)Mockito.verify((Object)this.attributeConfigWidget)).clear();
        ((DecoratedDisclosurePanel)Mockito.verify((Object)this.disclosurePanelAttributes, (VerificationMode)Mockito.never())).setOpen(Matchers.anyBoolean());
        ((VerticalPanel)Mockito.verify((Object)this.attributeConfigWidget)).add((Widget)Matchers.any(AttributeColumnConfigRowView.class));
    }
}

