/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class AdditionalInfoPageTest {
    @Mock
    private ConditionColumnPlugin plugin;
    @Mock
    private ConditionCol52 editingCol;
    @Mock
    private AdditionalInfoPage.View view;
    @Mock
    private SimplePanel content;
    @Mock
    private TranslationService translationService;
    @InjectMocks
    private AdditionalInfoPage<ConditionColumnPlugin> page;

    public AdditionalInfoPageTest() {
        this.page = (AdditionalInfoPage)Mockito.spy((Object)new AdditionalInfoPage(this.view, this.translationService));
    }

    @BeforeClass
    public static void setupPreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd/mm/yyyy");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
        GWTMockUtilities.disarm();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)this.plugin);
    }

    @Test
    public void testIsCompleteWhenHeaderIsNotEnabled() throws Exception {
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testIsCompleteWhenHeaderIsEnabledButNotCompleted() throws Exception {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn(Mockito.mock(ConditionCol52.class));
        this.page.enableHeader();
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testIsCompleteWhenHeaderIsEnabledAndCompleted() throws Exception {
        Mockito.when((Object)this.plugin.getHeader()).thenReturn((Object)"header");
        this.page.enableHeader();
        this.page.isComplete(Assert::assertTrue);
    }

    @Test
    public void testGetHeader() throws Exception {
        this.page.getHeader();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).getHeader();
    }

    @Test
    public void testSetHeader() throws Exception {
        this.page.setHeader("header");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setHeader((String)Mockito.eq((Object)"header"));
    }

    @Test
    public void testNewHideColumnCheckBox() throws Exception {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)this.editingCol);
        Mockito.when((Object)this.editingCol.isHideColumn()).thenReturn((Object)true);
        CheckBox checkBox = this.page.newHideColumnCheckBox();
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).isHideColumn();
        Assert.assertNotNull((Object)checkBox);
    }

    @Test
    public void testSetupHeaderWhenItIsEnabled() throws Exception {
        this.page.enableHeader();
        this.page.setupHeader();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showHeader();
    }

    @Test
    public void testSetupHeaderWhenItIsNotEnabled() throws Exception {
        this.page.setupHeader();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showHeader();
    }

    @Test
    public void testSetupHideColumnWhenItIsEnabled() throws Exception {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)this.editingCol);
        this.page.enableHideColumn();
        this.page.setupHideColumn();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showHideColumn((CheckBox)Mockito.any(CheckBox.class));
    }

    @Test
    public void testSetupHideColumnWhenItIsNotEnabled() throws Exception {
        this.page.setupHideColumn();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showHideColumn((CheckBox)Mockito.any(CheckBox.class));
    }

    @Test
    public void testSetupLogicallyInsertWhenItIsEnabledAndItShouldBeShown() throws Exception {
        Mockito.when((Object)this.plugin.showLogicallyInsert()).thenReturn((Object)true);
        this.page.enableLogicallyInsert();
        this.page.setupLogicallyInsert();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showLogicallyInsert();
    }

    @Test
    public void testSetupLogicallyInsertWhenItIsEnabledAndItShouldNotBeShown() throws Exception {
        Mockito.when((Object)this.plugin.showLogicallyInsert()).thenReturn((Object)false);
        this.page.enableLogicallyInsert();
        this.page.setupLogicallyInsert();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showLogicallyInsert();
    }

    @Test
    public void testSetupLogicallyInsertWhenItIsNotEnabled() throws Exception {
        this.page.setupLogicallyInsert();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showLogicallyInsert();
    }

    @Test
    public void testSetupUpdateEngineWithChangesWhenItIsEnabledAndItShouldBeShown() throws Exception {
        Mockito.when((Object)this.plugin.showUpdateEngineWithChanges()).thenReturn((Object)true);
        this.page.enableUpdateEngineWithChanges();
        this.page.setupUpdateEngineWithChanges();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showUpdateEngineWithChanges();
    }

    @Test
    public void testSetupUpdateEngineWithChangesWhenItIsEnabledAndItShouldNotBeShown() throws Exception {
        Mockito.when((Object)this.plugin.showUpdateEngineWithChanges()).thenReturn((Object)false);
        this.page.enableUpdateEngineWithChanges();
        this.page.setupUpdateEngineWithChanges();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showUpdateEngineWithChanges();
    }

    @Test
    public void testSetupUpdateEngineWithChangesWhenItIsNotEnabled() throws Exception {
        this.page.setupUpdateEngineWithChanges();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showUpdateEngineWithChanges();
    }

    @Test
    public void testSetInsertLogical() throws Exception {
        Boolean value = Boolean.TRUE;
        this.page.setInsertLogical(value);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setInsertLogical(value);
    }

    @Test
    public void testUpdate() throws Exception {
        Boolean value = Boolean.TRUE;
        this.page.setUpdate(value);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setUpdate(value);
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "AdditionalInfoPage.AdditionalInfo";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("AdditionalInfoPage.AdditionalInfo", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        this.page.prepareView();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).init(this.page);
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }
}

