/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.CalculationTypePage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.OperatorPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.ValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class FieldPageTest {
    @Mock
    private ConditionColumnPlugin plugin;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private PatternWrapper pattern52;
    @Mock
    private ConditionCol52 editingCol;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private FieldPage.View view;
    @Mock
    private SimplePanel content;
    @Mock
    private PatternPage<ConditionColumnPlugin> patternPage;
    @Mock
    private CalculationTypePage calculationTypePage;
    @Mock
    private FieldPage fieldPage;
    @Mock
    private OperatorPage operatorPage;
    @Mock
    private AdditionalInfoPage<ConditionColumnPlugin> additionalInfoPage;
    @Mock
    private ValueOptionsPage valueOptionsPage;
    @Mock
    private TranslationService translationService;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Captor
    private ArgumentCaptor<Consumer<String>> consumer;
    @InjectMocks
    private FieldPage<ConditionColumnPlugin> page;

    public FieldPageTest() {
        this.page = (FieldPage)Mockito.spy((Object)new FieldPage(this.view, this.translationService));
    }

    @BeforeClass
    public static void setupPreferences() {
        GWTMockUtilities.disarm();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)this.plugin);
    }

    @Test
    public void testSetEditingCol() throws Exception {
        this.page.setEditingCol("factField");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setFactField((String)Mockito.eq((Object)"factField"));
    }

    @Test
    public void testIsConstraintValuePredicateWhenItIsTypePredicate() throws Exception {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)5);
        Assert.assertTrue((boolean)this.page.isConstraintValuePredicate());
    }

    @Test
    public void testIsConstraintValuePredicateWhenItIsNotTypePredicate() throws Exception {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)0);
        Assert.assertFalse((boolean)this.page.isConstraintValuePredicate());
    }

    @Test
    public void testHasEditingPatternWhenFactPatternIsNotNull() throws Exception {
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Assert.assertTrue((boolean)this.page.hasEditingPattern());
    }

    @Test
    public void testHasEditingPatternWhenFactPatternIsNull() throws Exception {
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Assert.assertFalse((boolean)this.page.hasEditingPattern());
    }

    @Test
    public void testIsConstraintRetValueWhenItIsTypeRetValue() throws Exception {
        this.page.filterEnumFields();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).filterEnumFields();
    }

    @Test
    public void testForEachFactFieldWhenEditingPatternIsNotNull() throws Exception {
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.plugin.getAccessor()).thenReturn((Object)FieldAccessorsAndMutators.ACCESSOR);
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        this.page.forEachFactField(s -> {});
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle)).getFieldCompletions((String)Mockito.eq((Object)"factType"), (FieldAccessorsAndMutators)Mockito.eq((Object)FieldAccessorsAndMutators.ACCESSOR), (Callback)Mockito.any());
    }

    @Test
    public void testForEachFactFieldWhenEditingPatternIsNull() throws Exception {
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        this.page.forEachFactField(s -> {});
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle, (VerificationMode)Mockito.never())).getFieldCompletions((String)Mockito.any(), (FieldAccessorsAndMutators)Mockito.any(), (Callback)Mockito.any());
    }

    @Test
    public void testFieldsCallbackWhenConstraintIsRetValue() throws Exception {
        ConditionColumnPlugin plugin = (ConditionColumnPlugin)Mockito.spy((Object)new ConditionColumnPlugin(this.patternPage, this.calculationTypePage, this.fieldPage, this.operatorPage, this.valueOptionsPage, this.additionalInfoPage, this.changeEvent, this.translationService));
        ((ConditionColumnPlugin)Mockito.doReturn((Object)3).when((Object)plugin)).constraintValue();
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)plugin);
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.oracle.hasEnums("factType", "modelField2")).thenReturn((Object)true);
        ArrayList<String> expected = new ArrayList<String>(){
            {
                this.add("modelField1");
                this.add("modelField3");
            }
        };
        ArrayList result = new ArrayList();
        ModelField[] modelFields = new ModelField[]{this.modelField("modelField1"), this.modelField("modelField2"), this.modelField("modelField3")};
        Callback fieldsCallback = this.page.fieldsCallback(result::add);
        fieldsCallback.callback((Object)modelFields);
        Assert.assertEquals((Object)expected, result);
    }

    @Test
    public void testFieldsCallbackWhenConstraintIsNotRetValue() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.oracle.hasEnums("factType", "modelField2")).thenReturn((Object)true);
        ArrayList<String> expected = new ArrayList<String>(){
            {
                this.add("modelField1");
                this.add("modelField2");
                this.add("modelField3");
            }
        };
        ArrayList result = new ArrayList();
        ModelField[] modelFields = new ModelField[]{this.modelField("modelField1"), this.modelField("modelField2"), this.modelField("modelField3")};
        Callback fieldsCallback = this.page.fieldsCallback(result::add);
        fieldsCallback.callback((Object)modelFields);
        Assert.assertEquals((Object)expected, result);
    }

    @Test
    public void testFieldsCallbackWhenConstraintIsRetValueButItDoesNotHaveEnums() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)3).when((Object)this.plugin)).constraintValue();
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.oracle.hasEnums("factType", "modelField2")).thenReturn((Object)false);
        ArrayList<String> expected = new ArrayList<String>(){
            {
                this.add("modelField1");
                this.add("modelField2");
                this.add("modelField3");
            }
        };
        ArrayList result = new ArrayList();
        ModelField[] modelFields = new ModelField[]{this.modelField("modelField1"), this.modelField("modelField2"), this.modelField("modelField3")};
        Callback fieldsCallback = this.page.fieldsCallback(result::add);
        fieldsCallback.callback((Object)modelFields);
        Assert.assertEquals((Object)expected, result);
    }

    @Test
    public void testIsCompleteWhenFactFieldIsNull() throws Exception {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)1);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn(null);
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testIsCompleteWhenFactFieldIsNotNull() throws Exception {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)1);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        this.page.isComplete(Assert::assertTrue);
    }

    @Test
    public void testIsCompleteWhenConstraintValueIsPredicate() throws Exception {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)5);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn(null);
        this.page.isComplete(Assert::assertTrue);
    }

    @Test
    public void testGetFactField() {
        this.page.getFactField();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).getFactField();
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "FieldPage.Field";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("FieldPage.Field", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.pattern52).when((Object)this.plugin)).patternWrapper();
        this.page.prepareView();
        ((FieldPage.View)Mockito.verify((Object)this.view)).init(this.page);
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }

    @Test
    public void testSetupField() {
        String factField = "factField";
        ((FieldPage)Mockito.doReturn((Object)"factField").when(this.page)).getFactField();
        ((FieldPage)Mockito.doNothing().when(this.page)).forEachFactField((Consumer)this.consumer.capture());
        this.page.setupField();
        Consumer consumer = (Consumer)this.consumer.getValue();
        consumer.accept("factField");
        ((FieldPage.View)Mockito.verify((Object)this.view)).addItem("factField", "factField");
        ((FieldPage.View)Mockito.verify((Object)this.view)).setupFieldList();
        ((FieldPage.View)Mockito.verify((Object)this.view)).selectField("factField");
    }

    private ModelField modelField(String name) {
        return new ModelField(name, null, null, null, null, null);
    }
}

