/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals.NewPatternPresenter;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class PatternPageTest {
    @Captor
    private ArgumentCaptor<PatternWrapper> patternWrapperArgumentCaptor;
    @Mock
    private PatternPage.View view;
    @Mock
    private NewPatternPresenter newPatternPresenter;
    @Mock
    private ConditionColumnPlugin plugin;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private TranslationService translationService;
    @InjectMocks
    private PatternPage<ConditionColumnPlugin> page;
    @Mock
    private SimplePanel content;
    private GuidedDecisionTable52 model;

    public PatternPageTest() {
        this.page = (PatternPage)Mockito.spy((Object)new PatternPage(this.view, this.newPatternPresenter, this.translationService));
    }

    @BeforeClass
    public static void staticSetup() {
        GWTMockUtilities.disarm();
    }

    @Before
    public void setup() {
        this.model = (GuidedDecisionTable52)Mockito.spy((Object)new GuidedDecisionTable52());
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)this.plugin);
    }

    @Test
    public void testForEachPatternValues() throws Exception {
        Mockito.when((Object)this.plugin.getPatterns()).thenReturn(this.fakePatterns());
        ArrayList patternValues = new ArrayList();
        this.page.forEachPattern((patternName, patternValue) -> patternValues.add(patternValue));
        Assert.assertEquals((Object)"factType1 boundName1 false", patternValues.get(0));
        Assert.assertEquals((Object)"factType2 boundName2 true", patternValues.get(1));
    }

    @Test
    public void testForEachPatternNames() throws Exception {
        Mockito.when((Object)this.plugin.getPatterns()).thenReturn(this.fakePatterns());
        ArrayList patternNames = new ArrayList();
        this.page.forEachPattern((patternName, patternValue) -> patternNames.add(patternName));
        Assert.assertEquals((Object)"factType1 [boundName1]", patternNames.get(0));
        Assert.assertEquals((Object)"negatedPattern factType2 [boundName2]", patternNames.get(1));
    }

    @Test
    public void testSetSelectedEditingPattern() throws Exception {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        String key = "factType boundName false";
        Mockito.when((Object)this.page.findPatternWrapperByKey("factType boundName false")).thenReturn((Object)patternWrapper);
        Mockito.when((Object)this.view.getSelectedValue()).thenReturn((Object)"factType boundName false");
        this.page.setSelectedEditingPattern();
        ((PatternPage)Mockito.verify(this.page)).setEditingPattern(patternWrapper);
    }

    @Test
    public void testSetEditingPattern() throws Exception {
        Mockito.when((Object)this.view.getEntryPointName()).thenReturn((Object)"entryPoint");
        PatternWrapper pattern = (PatternWrapper)Mockito.spy((Object)this.newPattern("factType1", "boundName1", false));
        this.page.setEditingPattern(pattern);
        ((PatternWrapper)Mockito.verify((Object)pattern)).setEntryPointName("entryPoint");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setEditingPattern(pattern);
    }

    @Test
    public void testShowNewPatternModal() throws Exception {
        this.page.showNewPatternModal();
        ((NewPatternPresenter)Mockito.verify((Object)this.newPatternPresenter)).show();
    }

    @Test
    public void testCurrentPatternNameWhenTheCurrentPatternIsNotNull() throws Exception {
        Mockito.when((Object)this.plugin.getPatterns()).thenReturn(this.fakePatterns());
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.newPattern("factType3", "boundName3", true));
        String patternName = this.page.currentPatternName();
        Assert.assertEquals((Object)"negatedPattern factType3 [boundName3]", (Object)patternName);
    }

    @Test
    public void testCurrentPatternNameWhenTheCurrentPatternIsNull() throws Exception {
        Mockito.when((Object)this.plugin.getPatterns()).thenReturn(this.fakePatterns());
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn(null);
        String patternName = this.page.currentPatternName();
        Assert.assertEquals((Object)"", (Object)patternName);
    }

    @Test
    public void testCurrentPatternValueWhenTheCurrentPatternIsNotNull() throws Exception {
        Mockito.when((Object)this.plugin.getPatterns()).thenReturn(this.fakePatterns());
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.newPattern("factType3", "boundName3", true));
        String patternValue = this.page.currentPatternValue();
        Assert.assertEquals((Object)"factType3 boundName3 true", (Object)patternValue);
    }

    @Test
    public void testCurrentPatternValueWhenTheCurrentPatternIsNull() throws Exception {
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn(null);
        String patternValue = this.page.currentPatternValue();
        Assert.assertEquals((Object)"", (Object)patternValue);
    }

    @Test
    public void testGetPatternsWhenCurrentPatternIsNull() {
        Mockito.when((Object)this.plugin.getPatterns()).thenReturn(this.fakePatterns());
        List patterns = this.page.getPatterns();
        Assert.assertEquals((long)2L, (long)patterns.size());
    }

    @Test
    public void testGetPatternsWhenCurrentPatternIsNotNull() {
        Mockito.when((Object)this.plugin.getPatterns()).thenReturn(this.fakePatterns());
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.newPattern("factType3", "boundName3", true));
        List patterns = this.page.getPatterns();
        Assert.assertEquals((long)3L, (long)patterns.size());
    }

    @Test
    public void testGetPatternsWhenNegatedPatternsAreNotEnabled() {
        this.page.disableNegatedPatterns();
        Mockito.when((Object)this.plugin.getPatterns()).thenReturn(this.fakePatterns());
        List patterns = this.page.getPatterns();
        Assert.assertEquals((long)1L, (long)patterns.size());
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "PatternPage.Pattern";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("PatternPage.Pattern", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        this.page.prepareView();
        ((PatternPage.View)Mockito.verify((Object)this.view)).init(this.page);
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }

    @Test
    public void testIsCompleteWhenPatternIsSet() {
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.newPattern("factType", "", false));
        this.page.isComplete(Assert::assertTrue);
    }

    @Test
    public void testIsCompleteWhenPatternIsNotSet() {
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.newPattern("", "", false));
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testPresenter() {
        Assert.assertEquals((Object)this.presenter, (Object)this.page.presenter());
    }

    @Test
    public void testDisableNegatedPatterns() {
        this.page.disableNegatedPatterns();
        Assert.assertFalse((boolean)this.page.isNegatedPatternEnabled());
    }

    @Test
    public void testDisableEntryPoint() {
        this.page.disableEntryPoint();
        ((PatternPage.View)Mockito.verify((Object)this.view)).disableEntryPoint();
    }

    @Test
    public void testGetEntryPointName() {
        String expectedEntryPoint = "entryPoint";
        Mockito.when((Object)this.plugin.getEntryPointName()).thenReturn((Object)"entryPoint");
        String actualEntryPoint = this.page.getEntryPointName();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).getEntryPointName();
        Assert.assertEquals((Object)"entryPoint", (Object)actualEntryPoint);
    }

    @Test
    public void testSetEntryPoint() {
        String entryPoint = "entryPoint";
        Mockito.when((Object)this.view.getEntryPointName()).thenReturn((Object)"entryPoint");
        this.page.setEntryPoint();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setEntryPointName("entryPoint");
    }

    @Test
    public void testSetupPattern() {
        final PatternWrapper pattern1 = this.newPattern("factType1", "boundName1", false);
        final PatternWrapper pattern2 = this.newPattern("factType2", "boundName2", false);
        ArrayList<PatternWrapper> patterns = new ArrayList<PatternWrapper>(){
            {
                this.add(pattern1);
                this.add(pattern2);
            }
        };
        ((PatternPage)Mockito.doReturn((Object)pattern2.key()).when(this.page)).currentPatternValue();
        ((PatternPage)Mockito.doReturn((Object)patterns).when(this.page)).getPatterns();
        this.page.setupPattern();
        ((PatternPage.View)Mockito.verify((Object)this.view)).addItem("factType1 [boundName1]", "factType1 boundName1 false");
        ((PatternPage.View)Mockito.verify((Object)this.view)).addItem("factType2 [boundName2]", "factType2 boundName2 false");
        ((PatternPage.View)Mockito.verify((Object)this.view)).clearPatternList();
        ((PatternPage.View)Mockito.verify((Object)this.view)).selectPattern(pattern2.key());
        ((PatternPage.View)Mockito.verify((Object)this.view)).hidePatternListWhenItIsEmpty();
    }

    private List<PatternWrapper> fakePatterns() {
        return new ArrayList<PatternWrapper>(){
            {
                this.add(PatternPageTest.this.newPattern("factType1", "boundName1", false));
                this.add(PatternPageTest.this.newPattern("factType2", "boundName2", true));
            }
        };
    }

    private PatternWrapper newPattern(String factType, String boundName, boolean negated) {
        return new PatternWrapper(factType, boundName, Boolean.valueOf(negated));
    }
}

