/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionRetractFactCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternToDeletePage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionRetractFactPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionRetractFactPluginTest {
    @Mock
    private PatternToDeletePage patternToDeletePage;
    @Mock
    private AdditionalInfoPage<ConditionColumnPlugin> additionalInfoPage;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private TranslationService translationService;
    @Mock
    private ActionRetractFactCol52 editingCol;
    @Mock
    private LimitedEntryActionRetractFactCol52 limitedEntryActionRetractFactCol52;
    @InjectMocks
    private ActionRetractFactPlugin plugin;

    public ActionRetractFactPluginTest() {
        this.plugin = (ActionRetractFactPlugin)Mockito.spy((Object)new ActionRetractFactPlugin(this.patternToDeletePage, this.additionalInfoPage, this.changeEvent, this.translationService));
    }

    @Test
    public void testInit() throws Exception {
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((NewGuidedDecisionTableColumnWizard)Mockito.doReturn((Object)this.presenter).when((Object)wizard)).getPresenter();
        this.plugin.init(wizard);
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).setupDefaultValues();
    }

    @Test
    public void testGetPagesWhenTableFormatIsLimitedEntry() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        List pages = this.plugin.getPages();
        boolean hasPatternToDeletePage = pages.stream().anyMatch(a -> a instanceof PatternToDeletePage);
        Assert.assertTrue((boolean)hasPatternToDeletePage);
        Assert.assertEquals((long)2L, (long)pages.size());
    }

    @Test
    public void testGetPagesWhenTableFormatIsNotLimitedEntry() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        List pages = this.plugin.getPages();
        boolean hasPatternToDeletePage = pages.stream().anyMatch(a -> a instanceof PatternToDeletePage);
        Assert.assertFalse((boolean)hasPatternToDeletePage);
        Assert.assertEquals((long)1L, (long)pages.size());
    }

    @Test
    public void testGenerateColumnWhenItIsNotValid() throws Exception {
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isValid();
        Boolean result = this.plugin.generateColumn();
        Assert.assertFalse((boolean)result);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).appendColumn((ActionCol52)Mockito.any(ActionCol52.class));
    }

    @Test
    public void testGenerateColumnWhenItIsValid() throws Exception {
        ActionCol52 expectedColumn = (ActionCol52)this.plugin.editingCol();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isValid();
        Boolean result = this.plugin.generateColumn();
        Assert.assertTrue((boolean)result);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn(expectedColumn);
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "Header";
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.setHeader("Header");
        ((ActionRetractFactCol52)Mockito.verify((Object)this.editingCol)).setHeader("Header");
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testUniqueWhenItIsUnique() throws Exception {
        ArrayList<ActionCol52> actionCols = new ArrayList<ActionCol52>(){
            {
                this.add(ActionRetractFactPluginTest.this.actionCol52("Header1"));
            }
        };
        ((GuidedDecisionTable52)Mockito.doReturn((Object)actionCols).when((Object)this.model)).getActionCols();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        boolean result = this.plugin.unique("Header2");
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testUniqueWhenItIsNotUnique() throws Exception {
        ArrayList<ActionCol52> actionCols = new ArrayList<ActionCol52>(){
            {
                this.add(ActionRetractFactPluginTest.this.actionCol52("Header1"));
            }
        };
        ((GuidedDecisionTable52)Mockito.doReturn((Object)actionCols).when((Object)this.model)).getActionCols();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        boolean result = this.plugin.unique("Header1");
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testGetEditingColStringValue() throws Exception {
        DTCellValue52 cellValue52 = (DTCellValue52)Mockito.mock(DTCellValue52.class);
        ((LimitedEntryActionRetractFactCol52)Mockito.doReturn((Object)cellValue52).when((Object)this.limitedEntryActionRetractFactCol52)).getValue();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)this.limitedEntryActionRetractFactCol52).when((Object)this.plugin)).editingCol();
        this.plugin.getEditingColStringValue();
        ((DTCellValue52)Mockito.verify((Object)cellValue52)).getStringValue();
    }

    @Test
    public void testSetEditingColStringValue() throws Exception {
        DTCellValue52 cellValue52 = (DTCellValue52)Mockito.mock(DTCellValue52.class);
        String pattern = "pattern";
        ((LimitedEntryActionRetractFactCol52)Mockito.doReturn((Object)cellValue52).when((Object)this.limitedEntryActionRetractFactCol52)).getValue();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)this.limitedEntryActionRetractFactCol52).when((Object)this.plugin)).editingCol();
        this.plugin.setEditingColStringValue("pattern");
        ((DTCellValue52)Mockito.verify((Object)cellValue52)).setStringValue("pattern");
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsCompleted() throws Exception {
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isPatternToDeletePageCompleted();
        this.plugin.setPatternToDeletePageAsCompleted();
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setPatternToDeletePageCompleted(Boolean.TRUE);
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.patternToDeletePage);
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isPatternToDeletePageCompleted();
        this.plugin.setPatternToDeletePageAsCompleted();
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).setPatternToDeletePageCompleted(Boolean.TRUE);
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.patternToDeletePage);
    }

    @Test
    public void testIsValidWhenHeaderIsNull() throws Exception {
        String errorMessage = "YouMustEnterAColumnHeaderValueDescription";
        ((TranslationService)Mockito.doReturn((Object)"YouMustEnterAColumnHeaderValueDescription").when((Object)this.translationService)).format("ActionRetractFactPlugin.YouMustEnterAColumnHeaderValueDescription", new Object[0]);
        ((ActionRetractFactCol52)Mockito.doReturn(null).when((Object)this.editingCol)).getHeader();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        boolean success = this.plugin.isValid();
        Assert.assertFalse((boolean)success);
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).showError("YouMustEnterAColumnHeaderValueDescription");
    }

    @Test
    public void testIsValidWhenHeaderNotUnique() throws Exception {
        String errorMessage = "ThatColumnNameIsAlreadyInUsePleasePickAnother";
        String header = "Header";
        ((TranslationService)Mockito.doReturn((Object)"ThatColumnNameIsAlreadyInUsePleasePickAnother").when((Object)this.translationService)).format("ActionRetractFactPlugin.ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0]);
        ((ActionRetractFactCol52)Mockito.doReturn((Object)"Header").when((Object)this.editingCol)).getHeader();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).unique("Header");
        boolean success = this.plugin.isValid();
        Assert.assertFalse((boolean)success);
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).showError("ThatColumnNameIsAlreadyInUsePleasePickAnother");
    }

    @Test
    public void testIsValidWhenItIsValid() throws Exception {
        String header = "Header";
        ((ActionRetractFactCol52)Mockito.doReturn((Object)"Header").when((Object)this.editingCol)).getHeader();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).unique("Header");
        boolean success = this.plugin.isValid();
        Assert.assertTrue((boolean)success);
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).showError((String)Mockito.any());
    }

    @Test
    public void testGetTitle() {
        String errorKey = "ActionRetractFactPlugin.DeleteAnExistingFact";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("ActionRetractFactPlugin.DeleteAnExistingFact", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testGetHeader() {
        this.plugin.getHeader();
        ((ActionRetractFactCol52)Mockito.verify((Object)this.editingCol)).getHeader();
    }

    private ActionCol52 actionCol52(final String header) {
        return new ActionCol52(){
            {
                this.setHeader(header);
            }
        };
    }
}

