/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.ValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionSetFactPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionInsertFactWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionSetFactWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DefaultWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.LimitedWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={DefaultWidgetFactory.class, LimitedWidgetFactory.class})
public class ActionSetFactPluginTest {
    @Mock
    private PatternPage patternPage;
    @Mock
    private FieldPage fieldPage;
    @Mock
    private ValueOptionsPage<ActionSetFactPlugin> valueOptionsPage;
    @Mock
    private AdditionalInfoPage<ActionSetFactPlugin> additionalInfoPage;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private TranslationService translationService;
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @InjectMocks
    private ActionSetFactPlugin plugin;

    public ActionSetFactPluginTest() {
        this.plugin = (ActionSetFactPlugin)Mockito.spy((Object)new ActionSetFactPlugin(this.patternPage, this.fieldPage, this.valueOptionsPage, this.additionalInfoPage, this.changeEvent, this.translationService));
    }

    @Test
    public void testGetTitle() {
        String errorKey = "ActionInsertFactPlugin.SetTheValueOfAField";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("ActionInsertFactPlugin.SetTheValueOfAField", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testGetPages() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.plugin)).tableFormat();
        List pages = this.plugin.getPages();
        Assert.assertEquals((long)4L, (long)pages.size());
    }

    @Test
    public void testGenerateColumnWhenItIsValid() {
        ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionWrapper)Mockito.doReturn((Object)actionCol52).when((Object)actionWrapper)).getActionCol52();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isValid((ActionWrapper)Mockito.any());
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn(actionCol52);
    }

    @Test
    public void testGenerateColumnWhenItIsNotValid() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isValid((ActionWrapper)Mockito.any());
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).appendColumn((ActionCol52)Mockito.any(ActionCol52.class));
    }

    @Test
    public void testIsValidWhenFactTypeIsBlank() {
        ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String errorKey = "ActionInsertFactPlugin.YouMustEnterAColumnPattern";
        Mockito.when((Object)actionWrapper.getFactType()).thenReturn((Object)"");
        Mockito.when((Object)actionWrapper.getActionCol52()).thenReturn((Object)actionCol52);
        boolean valid = this.plugin.isValid(actionWrapper);
        Assert.assertFalse((boolean)valid);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("ActionInsertFactPlugin.YouMustEnterAColumnPattern", new Object[0]);
    }

    @Test
    public void testIsValidWhenFactFieldIsBlank() {
        ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String errorKey = "ActionInsertFactPlugin.YouMustEnterAColumnField";
        Mockito.when((Object)actionWrapper.getFactField()).thenReturn((Object)"");
        Mockito.when((Object)actionWrapper.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)actionWrapper.getActionCol52()).thenReturn((Object)actionCol52);
        Mockito.when((Object)this.plugin.editingWrapper()).thenReturn((Object)actionWrapper);
        boolean valid = this.plugin.isValid(actionWrapper);
        Assert.assertFalse((boolean)valid);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("ActionInsertFactPlugin.YouMustEnterAColumnField", new Object[0]);
    }

    @Test
    public void testIsValidWhenHeaderIsBlank() {
        ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String errorKey = "ActionInsertFactPlugin.YouMustEnterAColumnHeaderValueDescription";
        Mockito.when((Object)actionCol52.getHeader()).thenReturn((Object)"");
        Mockito.when((Object)actionWrapper.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)actionWrapper.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)actionWrapper.getActionCol52()).thenReturn((Object)actionCol52);
        Mockito.when((Object)this.plugin.editingWrapper()).thenReturn((Object)actionWrapper);
        boolean valid = this.plugin.isValid(actionWrapper);
        Assert.assertFalse((boolean)valid);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("ActionInsertFactPlugin.YouMustEnterAColumnHeaderValueDescription", new Object[0]);
    }

    @Test
    public void testIsValidWhenHeaderIsNotUnique() {
        ActionCol52 newActionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        final ActionCol52 oldActionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        String errorKey = "ActionInsertFactPlugin.ThatColumnNameIsAlreadyInUsePleasePickAnother";
        ArrayList<ActionCol52> actionCol52s = new ArrayList<ActionCol52>(){
            {
                this.add(oldActionCol52);
            }
        };
        Mockito.when((Object)oldActionCol52.getHeader()).thenReturn((Object)"header");
        Mockito.when((Object)model.getActionCols()).thenReturn((Object)actionCol52s);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Mockito.when((Object)newActionCol52.getHeader()).thenReturn((Object)"header");
        Mockito.when((Object)actionWrapper.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)actionWrapper.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)actionWrapper.getActionCol52()).thenReturn((Object)newActionCol52);
        Mockito.when((Object)this.plugin.editingWrapper()).thenReturn((Object)actionWrapper);
        boolean valid = this.plugin.isValid(actionWrapper);
        Assert.assertFalse((boolean)valid);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("ActionInsertFactPlugin.ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0]);
    }

    @Test
    public void testIsValidWhenItIsValid() {
        ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        ArrayList actionCol52s = new ArrayList();
        Mockito.when((Object)model.getActionCols()).thenReturn(actionCol52s);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Mockito.when((Object)actionCol52.getHeader()).thenReturn((Object)"header");
        Mockito.when((Object)actionWrapper.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)actionWrapper.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)actionWrapper.getActionCol52()).thenReturn((Object)actionCol52);
        Mockito.when((Object)this.plugin.editingWrapper()).thenReturn((Object)actionWrapper);
        boolean valid = this.plugin.isValid(actionWrapper);
        Assert.assertTrue((boolean)valid);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsCompleted() throws Exception {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isValueOptionsPageCompleted();
        this.plugin.setValueOptionsPageAsCompleted();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setValueOptionsPageCompleted();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent(this.valueOptionsPage);
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isValueOptionsPageCompleted();
        this.plugin.setValueOptionsPageAsCompleted();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).setValueOptionsPageCompleted();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.valueOptionsPage);
    }

    @Test
    public void testSetEditingPattern() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        Mockito.when((Object)this.plugin.editingWrapper()).thenReturn((Object)actionWrapper);
        this.plugin.setEditingPattern(patternWrapper);
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setFactField("");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setFactType("");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setBoundName("");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setType("");
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.patternPage);
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGetPatterns() {
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        ArrayList<Pattern52> fakePatterns = new ArrayList<Pattern52>(){
            {
                this.add(ActionSetFactPluginTest.this.fakePattern("factType", "boundName", true));
            }
        };
        Mockito.when((Object)model.getPatterns()).thenReturn((Object)fakePatterns);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        List patterns = this.plugin.getPatterns();
        PatternWrapper firstPattern = (PatternWrapper)patterns.get(0);
        Assert.assertNotNull((Object)firstPattern);
        Assert.assertEquals((Object)"factType", (Object)firstPattern.getFactType());
        Assert.assertEquals((Object)"boundName", (Object)firstPattern.getBoundName());
        Assert.assertEquals((Object)true, (Object)firstPattern.isNegated());
        Assert.assertEquals((long)1L, (long)patterns.size());
    }

    @Test
    public void testConstraintValue() {
        boolean expectedConstraintValue = false;
        int actualConstraintValue = this.plugin.constraintValue();
        Assert.assertEquals((long)0L, (long)actualConstraintValue);
    }

    @Test
    public void testGetFactType() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String expectedFactType = "factType";
        Mockito.when((Object)actionWrapper.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.editingWrapper()).thenReturn((Object)actionWrapper);
        String actualFactType = this.plugin.getFactType();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).getFactType();
        Assert.assertEquals((Object)"factType", (Object)actualFactType);
    }

    @Test
    public void testGetAccessor() {
        FieldAccessorsAndMutators expectedAccessor = FieldAccessorsAndMutators.MUTATOR;
        FieldAccessorsAndMutators actualAccessor = this.plugin.getAccessor();
        Assert.assertEquals((Object)expectedAccessor, (Object)actualAccessor);
    }

    @Test
    public void testFilterEnumFields() {
        Assert.assertFalse((boolean)this.plugin.filterEnumFields());
    }

    @Test
    public void testGetFactField() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String expectedFactField = "factField";
        Mockito.when((Object)actionWrapper.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.editingWrapper()).thenReturn((Object)actionWrapper);
        String actualFactField = this.plugin.getFactField();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).getFactField();
        Assert.assertEquals((Object)"factField", (Object)actualFactField);
    }

    @Test
    public void testSetFactFieldWhenFactPatternIsNew() {
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        ActionInsertFactWrapper actionWrapper = (ActionInsertFactWrapper)Mockito.mock(ActionInsertFactWrapper.class);
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).newActionInsertFactWrapper();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)oracle).when((Object)this.presenter)).getDataModelOracle();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)"type").when((Object)oracle)).getFieldType((String)Mockito.any(), (String)Mockito.any());
        ((PatternWrapper)Mockito.doReturn((Object)"factType").when((Object)patternWrapper)).getFactType();
        ((PatternWrapper)Mockito.doReturn((Object)"boundName").when((Object)patternWrapper)).getBoundName();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        this.plugin.setFactField("selectedValue");
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setFactField((String)Mockito.eq((Object)"selectedValue"));
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setFactType((String)Mockito.eq((Object)"factType"));
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setBoundName((String)Mockito.eq((Object)"boundName"));
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setType((String)Mockito.eq((Object)"type"));
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
    }

    @Test
    public void testSetFactFieldWhenFactPatternIsNotNew() {
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        ActionSetFactWrapper actionWrapper = (ActionSetFactWrapper)Mockito.mock(ActionSetFactWrapper.class);
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewFactPattern();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).newActionSetFactWrapper();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)oracle).when((Object)this.presenter)).getDataModelOracle();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)"type").when((Object)oracle)).getFieldType((String)Mockito.any(), (String)Mockito.any());
        ((PatternWrapper)Mockito.doReturn((Object)"factType").when((Object)patternWrapper)).getFactType();
        ((PatternWrapper)Mockito.doReturn((Object)"boundName").when((Object)patternWrapper)).getBoundName();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        this.plugin.setFactField("selectedValue");
        ((ActionSetFactWrapper)Mockito.verify((Object)actionWrapper)).setFactField((String)Mockito.eq((Object)"selectedValue"));
        ((ActionSetFactWrapper)Mockito.verify((Object)actionWrapper)).setFactType((String)Mockito.eq((Object)"factType"));
        ((ActionSetFactWrapper)Mockito.verify((Object)actionWrapper)).setBoundName((String)Mockito.eq((Object)"boundName"));
        ((ActionSetFactWrapper)Mockito.verify((Object)actionWrapper)).setType((String)Mockito.eq((Object)"type"));
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
    }

    @Test
    public void testEditingPattern() {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        Mockito.when((Object)patternWrapper.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)patternWrapper.getBoundName()).thenReturn((Object)"boundName");
        Mockito.when((Object)patternWrapper.isNegated()).thenReturn((Object)false);
        Mockito.when((Object)patternWrapper.getEntryPointName()).thenReturn((Object)"entryPoint");
        Pattern52 pattern52 = this.plugin.editingPattern();
        Assert.assertEquals((Object)"factType", (Object)pattern52.getFactType());
        Assert.assertEquals((Object)"boundName", (Object)pattern52.getBoundName());
        Assert.assertEquals((Object)false, (Object)pattern52.isNegated());
        Assert.assertEquals((Object)"entryPoint", (Object)pattern52.getEntryPointName());
    }

    @Test
    public void testEditingCol() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.editingCol();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).getActionCol52();
    }

    @Test
    public void testGetHeader() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.getHeader();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).getHeader();
    }

    @Test
    public void testSetHeader() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String header = "header";
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.setHeader("header");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setHeader("header");
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testSetInsertLogical() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        boolean insertLogical = false;
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.setInsertLogical(Boolean.valueOf(false));
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setInsertLogical(false);
    }

    @Test
    public void testSetUpdate() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        boolean update = false;
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.setUpdate(Boolean.valueOf(false));
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setUpdate(false);
    }

    @Test
    public void testShowUpdateEngineWithChangesWhenFactPatternIsNew() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        boolean showUpdateEngineWithChanges = this.plugin.showUpdateEngineWithChanges();
        Assert.assertEquals((Object)false, (Object)showUpdateEngineWithChanges);
    }

    @Test
    public void testShowUpdateEngineWithChangesWhenFactPatternIsNotNew() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewFactPattern();
        boolean showUpdateEngineWithChanges = this.plugin.showUpdateEngineWithChanges();
        Assert.assertEquals((Object)true, (Object)showUpdateEngineWithChanges);
    }

    @Test
    public void testShowLogicallyInsertWhenFactPatternIsNew() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        boolean showLogicallyInsert = this.plugin.showLogicallyInsert();
        Assert.assertEquals((Object)true, (Object)showLogicallyInsert);
    }

    @Test
    public void testShowLogicallyInsertWhenFactPatternIsNotNew() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewFactPattern();
        boolean showLogicallyInsert = this.plugin.showLogicallyInsert();
        Assert.assertEquals((Object)false, (Object)showLogicallyInsert);
    }

    @Test
    public void testGetValueList() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.getValueList();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).getValueList();
    }

    @Test
    public void testSetValueList() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String valueList = "valueList";
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.setValueList("valueList");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setValueList("valueList");
    }

    @Test
    public void testGetBinding() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.getBinding();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).getBoundName();
    }

    @Test
    public void testSetBinding() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String binding = "binding";
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.setBinding("binding");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setBoundName("binding");
    }

    @Test
    public void testTableFormat() {
        GuidedDecisionTable52.TableFormat expectedTableFormat = GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Mockito.when((Object)model.getTableFormat()).thenReturn((Object)expectedTableFormat);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        GuidedDecisionTable52.TableFormat actualTableFormat = this.plugin.tableFormat();
        Assert.assertEquals((Object)expectedTableFormat, (Object)actualTableFormat);
    }

    @Test
    public void testDefaultValueWidget() {
        IsWidget defaultWidget = this.plugin.defaultValueWidget();
        Assert.assertNotNull((Object)defaultWidget);
    }

    @Test
    public void testLimitedValueWidget() {
        IsWidget limitedValueWidget = this.plugin.limitedValueWidget();
        Assert.assertNotNull((Object)limitedValueWidget);
    }

    @Test
    public void testInitializedPatternPage() {
        this.plugin.initializedPatternPage();
        ((PatternPage)Mockito.verify((Object)this.patternPage)).disableEntryPoint();
    }

    @Test
    public void testInitializedAdditionalInfoPage() throws Exception {
        this.plugin.initializedAdditionalInfoPage();
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).setPlugin((DecisionTableColumnPlugin)this.plugin);
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).enableHeader();
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).enableHideColumn();
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).enableLogicallyInsert();
    }

    @Test
    public void testInitializedValueOptionsPageWhenTableIsALimitedEntry() throws Exception {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.plugin)).tableFormat();
        this.plugin.initializedValueOptionsPage();
        ((ValueOptionsPage)Mockito.verify(this.valueOptionsPage)).setPlugin((DecisionTableColumnPlugin)this.plugin);
        ((ValueOptionsPage)Mockito.verify(this.valueOptionsPage)).enableLimitedValue();
    }

    private Pattern52 fakePattern(final String factType, final String boundName, final boolean negated) {
        return new Pattern52(){
            {
                this.setFactType(factType);
                this.setBoundName(boundName);
                this.setNegated(negated);
            }
        };
    }
}

