/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.WorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionWorkItemPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionWorkItemPluginTest {
    @Mock
    private AdditionalInfoPage<ActionWorkItemPlugin> additionalInfoPage;
    @Mock
    private WorkItemPage workItemPage;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private TranslationService translationService;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private ActionWorkItemCol52 editingCol;
    @Mock
    private GuidedDecisionTable52 model;
    @InjectMocks
    private ActionWorkItemPlugin plugin;

    public ActionWorkItemPluginTest() {
        this.plugin = (ActionWorkItemPlugin)Mockito.spy((Object)new ActionWorkItemPlugin(this.additionalInfoPage, this.workItemPage, this.changeEvent, this.translationService));
    }

    @Test
    public void testSetWorkItemWithABlankValue() throws Exception {
        this.plugin.setWorkItem("");
        ((ActionWorkItemCol52)Mockito.verify((Object)this.editingCol)).setWorkItemDefinition(null);
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.workItemPage);
    }

    @Test
    public void testSetWorkItemWithAValidValue() throws Exception {
        PortableWorkDefinition workDefinition = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        String workItem = "workItem";
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)workDefinition).when((Object)this.plugin)).findWorkItemDefinition("workItem");
        this.plugin.setWorkItem("workItem");
        ((ActionWorkItemCol52)Mockito.verify((Object)this.editingCol)).setWorkItemDefinition(workDefinition);
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.workItemPage);
    }

    @Test
    public void testIsWorkItemSetWhenWorkItemDefinitionIsNotNull() throws Exception {
        PortableWorkDefinition workDefinition = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        Mockito.when((Object)this.editingCol.getWorkItemDefinition()).thenReturn((Object)workDefinition);
        Boolean isWorkItemSet = this.plugin.isWorkItemSet();
        Assert.assertTrue((boolean)isWorkItemSet);
    }

    @Test
    public void testIsWorkItemSetWhenWorkItemDefinitionIsNull() throws Exception {
        Mockito.when((Object)this.editingCol.getWorkItemDefinition()).thenReturn(null);
        Boolean isWorkItemSet = this.plugin.isWorkItemSet();
        Assert.assertFalse((boolean)isWorkItemSet);
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "Header";
        this.plugin.setHeader("Header");
        ((ActionWorkItemCol52)Mockito.verify((Object)this.editingCol)).setHeader("Header");
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGenerateColumnWhenItIsValid() throws Exception {
        Mockito.when((Object)this.plugin.isValid()).thenReturn((Object)true);
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn((ActionCol52)this.editingCol);
    }

    @Test
    public void testGenerateColumnWhenItIsNotValid() throws Exception {
        Mockito.when((Object)this.plugin.isValid()).thenReturn((Object)false);
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).appendColumn((ActionCol52)this.editingCol);
    }

    @Test
    public void testIsValidWhenItIsValid() throws Exception {
        String header = "header";
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).unique("header");
        ((ActionWorkItemCol52)Mockito.doReturn((Object)"header").when((Object)this.editingCol)).getHeader();
        boolean isValid = this.plugin.isValid();
        Assert.assertTrue((boolean)isValid);
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).showError((String)Mockito.any());
    }

    @Test
    public void testIsValidWhenHeaderIsBlank() throws Exception {
        String errorKey = "ActionWorkItemPlugin.YouMustEnterAColumnHeaderValueDescription";
        String errorMessage = "YouMustEnterAColumnHeaderValueDescription";
        ((TranslationService)Mockito.doReturn((Object)"YouMustEnterAColumnHeaderValueDescription").when((Object)this.translationService)).format("ActionWorkItemPlugin.YouMustEnterAColumnHeaderValueDescription", new Object[0]);
        ((ActionWorkItemCol52)Mockito.doReturn((Object)"").when((Object)this.editingCol)).getHeader();
        boolean isValid = this.plugin.isValid();
        Assert.assertFalse((boolean)isValid);
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).showError("YouMustEnterAColumnHeaderValueDescription");
    }

    @Test
    public void testIsValidWhenHeaderIsNotUnique() throws Exception {
        String header = "header";
        String errorKey = "ActionWorkItemPlugin.ThatColumnNameIsAlreadyInUsePleasePickAnother";
        String errorMessage = "ThatColumnNameIsAlreadyInUsePleasePickAnother";
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).unique("header");
        ((TranslationService)Mockito.doReturn((Object)"ThatColumnNameIsAlreadyInUsePleasePickAnother").when((Object)this.translationService)).format("ActionWorkItemPlugin.ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0]);
        ((ActionWorkItemCol52)Mockito.doReturn((Object)"header").when((Object)this.editingCol)).getHeader();
        boolean isValid = this.plugin.isValid();
        Assert.assertFalse((boolean)isValid);
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).showError("ThatColumnNameIsAlreadyInUsePleasePickAnother");
    }

    @Test
    public void testUniqueWhenHeaderIsUnique() throws Exception {
        final ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ArrayList<ActionCol52> actionCol52s = new ArrayList<ActionCol52>(){
            {
                this.add(actionCol52);
            }
        };
        Mockito.when((Object)actionCol52.getHeader()).thenReturn((Object)"header1");
        Mockito.when((Object)this.model.getActionCols()).thenReturn((Object)actionCol52s);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        boolean unique = this.plugin.unique("header2");
        Assert.assertTrue((boolean)unique);
    }

    @Test
    public void testUniqueWhenHeaderIsNotUnique() throws Exception {
        String header = "header";
        final ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ArrayList<ActionCol52> actionCol52s = new ArrayList<ActionCol52>(){
            {
                this.add(actionCol52);
            }
        };
        Mockito.when((Object)actionCol52.getHeader()).thenReturn((Object)"header");
        Mockito.when((Object)this.model.getActionCols()).thenReturn((Object)actionCol52s);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        boolean unique = this.plugin.unique("header");
        Assert.assertFalse((boolean)unique);
    }

    @Test
    public void testGetPages() throws Exception {
        List pages = this.plugin.getPages();
        Assert.assertEquals((long)2L, (long)pages.size());
    }

    @Test
    public void testGetTitle() {
        String errorKey = "ActionWorkItemPlugin.ExecuteWorkItem";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("ActionWorkItemPlugin.ExecuteWorkItem", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testInitializedWorkItemPage() {
        this.plugin.workItemPage();
        ((WorkItemPage)Mockito.verify((Object)this.workItemPage)).enableParameters();
    }

    @Test
    public void testInitializedAdditionalInfoPage() throws Exception {
        this.plugin.additionalInfoPage();
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).setPlugin((DecisionTableColumnPlugin)this.plugin);
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).enableHeader();
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).enableHideColumn();
    }

    @Test
    public void testInit() throws Exception {
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        this.plugin.init(wizard);
        Assert.assertNotNull((Object)this.plugin.editingCol());
    }

    @Test
    public void testGetHeader() {
        ActionWorkItemCol52 actionCol52 = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)actionCol52).when((Object)this.plugin)).editingCol();
        this.plugin.getHeader();
        ((ActionWorkItemCol52)Mockito.verify((Object)actionCol52)).getHeader();
    }

    @Test
    public void testWorkItemDefinition() {
        ActionWorkItemCol52 actionCol52 = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)actionCol52).when((Object)this.plugin)).editingCol();
        this.plugin.getWorkItemDefinition();
        ((ActionWorkItemCol52)Mockito.verify((Object)actionCol52)).getWorkItemDefinition();
    }

    @Test
    public void testWorkItemWhenItDoesNotHaveWorkItemDefinition() {
        PortableWorkDefinition workDefinition = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        String workItemName = "workItem";
        ((PortableWorkDefinition)Mockito.doReturn((Object)"workItem").when((Object)workDefinition)).getName();
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)workDefinition).when((Object)this.plugin)).getWorkItemDefinition();
        String workItem = this.plugin.getWorkItem();
        Assert.assertEquals((Object)"workItem", (Object)workItem);
    }

    @Test
    public void testWorkItemWhenItHasWorkItemDefinition() {
        ((ActionWorkItemPlugin)Mockito.doReturn(null).when((Object)this.plugin)).getWorkItemDefinition();
        String workItem = this.plugin.getWorkItem();
        Assert.assertEquals((Object)"", (Object)workItem);
    }

    @Test
    public void testFindWorkItemDefinition() {
        final PortableWorkDefinition workItem1 = this.getMock("workItem1");
        final PortableWorkDefinition workItem2 = this.getMock("workItem2");
        HashSet<PortableWorkDefinition> fakeDefinitions = new HashSet<PortableWorkDefinition>(){
            {
                this.add(workItem1);
                this.add(workItem2);
            }
        };
        Mockito.when((Object)this.presenter.getWorkItemDefinitions()).thenReturn((Object)fakeDefinitions);
        PortableWorkDefinition workItem = this.plugin.findWorkItemDefinition("workItem1");
        Assert.assertEquals((Object)workItem1, (Object)workItem);
    }

    @Test
    public void testForEachWorkItem() {
        final PortableWorkDefinition workItem1 = this.getMock("workItem1");
        final PortableWorkDefinition workItem2 = this.getMock("workItem2");
        HashMap actualWorkItems = new HashMap();
        HashMap<String, String> expectedWorkItems = new HashMap<String, String>(){
            {
                this.put("workItem1", "workItem1");
                this.put("workItem2", "workItem2");
            }
        };
        HashSet<PortableWorkDefinition> fakeDefinitions = new HashSet<PortableWorkDefinition>(){
            {
                this.add(workItem1);
                this.add(workItem2);
            }
        };
        Mockito.when((Object)this.presenter.getWorkItemDefinitions()).thenReturn((Object)fakeDefinitions);
        this.plugin.forEachWorkItem(actualWorkItems::put);
        Assert.assertEquals((Object)expectedWorkItems, actualWorkItems);
    }

    private PortableWorkDefinition getMock(String name) {
        PortableWorkDefinition mock = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        Mockito.when((Object)mock.getDisplayName()).thenReturn((Object)name);
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        return mock;
    }
}

