/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.WorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionWorkItemSetFieldPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionWorkItemWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={BRLRuleModel.class})
public class ActionWorkItemSetFieldPluginTest {
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private PatternPage patternPage;
    @Mock
    private FieldPage fieldPage;
    @Mock
    private AdditionalInfoPage additionalInfoPage;
    @Mock
    private WorkItemPage workItemPage;
    @Mock
    private ActionWorkItemWrapper editingWrapper;
    @Mock
    private TranslationService translationService;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @InjectMocks
    private ActionWorkItemSetFieldPlugin plugin;

    public ActionWorkItemSetFieldPluginTest() {
        this.plugin = (ActionWorkItemSetFieldPlugin)Mockito.spy((Object)new ActionWorkItemSetFieldPlugin(this.patternPage, this.fieldPage, this.additionalInfoPage, this.workItemPage, this.changeEvent, this.translationService));
    }

    @Test
    public void testSetWorkItem() throws Exception {
        String workItemKey = "workItem";
        PortableWorkDefinition workDefinition = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        PortableParameterDefinition parameterDefinition = (PortableParameterDefinition)Mockito.mock(PortableParameterDefinition.class);
        final ActionWorkItemSetFieldPlugin.WorkItemParameter parameter = (ActionWorkItemSetFieldPlugin.WorkItemParameter)Mockito.mock(ActionWorkItemSetFieldPlugin.WorkItemParameter.class);
        HashMap<String, ActionWorkItemSetFieldPlugin.WorkItemParameter> workItems = new HashMap<String, ActionWorkItemSetFieldPlugin.WorkItemParameter>(){
            {
                this.put("workItem", parameter);
            }
        };
        ((PortableWorkDefinition)Mockito.doReturn((Object)"workName").when((Object)workDefinition)).getName();
        ((PortableParameterDefinition)Mockito.doReturn((Object)"parameterName").when((Object)parameterDefinition)).getName();
        ((PortableParameterDefinition)Mockito.doReturn((Object)"parameterClassName").when((Object)parameterDefinition)).getClassName();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)workItems).when((Object)this.plugin)).getWorkItems();
        ((ActionWorkItemSetFieldPlugin.WorkItemParameter)Mockito.doReturn((Object)workDefinition).when((Object)parameter)).getWorkDefinition();
        ((ActionWorkItemSetFieldPlugin.WorkItemParameter)Mockito.doReturn((Object)parameterDefinition).when((Object)parameter)).getWorkParameterDefinition();
        this.plugin.setWorkItem("workItem");
        Assert.assertEquals((Object)"workItem", (Object)this.plugin.getWorkItem());
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setWorkItemName("workName");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setWorkItemResultParameterName("parameterName");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setParameterClassName("parameterClassName");
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.workItemPage);
    }

    @Test
    public void testEditingCol() throws Exception {
        ActionCol52 expectedAction = (ActionCol52)Mockito.mock(ActionCol52.class);
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)expectedAction).when((Object)this.editingWrapper)).getActionCol52();
        ActionCol52 actualAction = this.plugin.editingCol();
        Assert.assertEquals((Object)expectedAction, (Object)actualAction);
    }

    @Test
    public void testIsWorkItemSetWhenItIsSet() throws Exception {
        this.plugin.setWorkItemPageAsCompleted();
        Boolean workItemSet = this.plugin.isWorkItemSet();
        Assert.assertTrue((boolean)workItemSet);
    }

    @Test
    public void testIsWorkItemSetWhenItIsNotSet() throws Exception {
        Boolean workItemSet = this.plugin.isWorkItemSet();
        Assert.assertFalse((boolean)workItemSet);
    }

    @Test
    public void testSetWorkItemPageAsCompletedWhenItIsCompleted() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isWorkItemPageCompleted();
        this.plugin.setWorkItemPageAsCompleted();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setWorkItemPageCompleted();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.workItemPage);
    }

    @Test
    public void testSetWorkItemPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isWorkItemPageCompleted();
        this.plugin.setWorkItemPageAsCompleted();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).setWorkItemPageCompleted();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.workItemPage);
    }

    @Test
    public void testGetHeader() throws Exception {
        String expectedHeader = "header";
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"header").when((Object)this.editingWrapper)).getHeader();
        String actualHeader = this.plugin.getHeader();
        Assert.assertEquals((Object)"header", (Object)actualHeader);
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "header";
        this.plugin.setHeader("header");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setHeader("header");
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.additionalInfoPage);
    }

    @Test
    public void testSetInsertLogical() throws Exception {
        boolean isInsertLogical = false;
        this.plugin.setInsertLogical(Boolean.valueOf(false));
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setInsertLogical(false);
    }

    @Test
    public void testSetUpdate() throws Exception {
        boolean isUpdate = false;
        this.plugin.setUpdate(Boolean.valueOf(false));
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setUpdate(false);
    }

    @Test
    public void testGetTitle() {
        String errorKey = "ActionWorkItemSetFieldPlugin.SetValue";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("ActionWorkItemSetFieldPlugin.SetValue", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testGetPages() throws Exception {
        Assert.assertEquals((long)4L, (long)this.plugin.getPages().size());
    }

    @Test
    public void testGenerateColumnWhenFactTypeIsInvalid() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"").when((Object)this.editingWrapper)).getFactType();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)this.editingWrapper).when((Object)this.plugin)).editingWrapper();
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("ActionWorkItemSetFieldPlugin.YouMustEnterAColumnFact", new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenFactFieldIsInvalid() throws Exception {
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"").when((Object)this.editingWrapper)).getFactField();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factType").when((Object)this.editingWrapper)).getFactType();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)this.editingWrapper).when((Object)this.plugin)).editingWrapper();
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("ActionWorkItemSetFieldPlugin.YouMustEnterAColumnField", new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenHeaderIsInvalid() throws Exception {
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"").when((Object)this.editingWrapper)).getHeader();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factField").when((Object)this.editingWrapper)).getFactField();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factType").when((Object)this.editingWrapper)).getFactType();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)this.editingWrapper).when((Object)this.plugin)).editingWrapper();
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("ActionWorkItemSetFieldPlugin.YouMustEnterAColumnHeaderValueDescription", new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenHeaderIsNotUnique() throws Exception {
        String header = "header";
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"header").when((Object)this.editingWrapper)).getHeader();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factField").when((Object)this.editingWrapper)).getFactField();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factType").when((Object)this.editingWrapper)).getFactType();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)this.editingWrapper).when((Object)this.plugin)).editingWrapper();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).unique("header");
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("ActionWorkItemSetFieldPlugin.ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenItIsValid() throws Exception {
        ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        String header = "header";
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"header").when((Object)this.editingWrapper)).getHeader();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factField").when((Object)this.editingWrapper)).getFactField();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factType").when((Object)this.editingWrapper)).getFactType();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)this.editingWrapper).when((Object)this.plugin)).editingWrapper();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)actionCol52).when((Object)this.editingWrapper)).getActionCol52();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).unique("header");
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn(actionCol52);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testSetEditingPattern() throws Exception {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        this.plugin.setEditingPattern(patternWrapper);
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setFactField(null);
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setFactType(null);
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setBoundName(null);
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setType(null);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.patternPage);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.additionalInfoPage);
        Assert.assertEquals((Object)patternWrapper, (Object)this.plugin.patternWrapper());
    }

    @Test
    public void testGetPatterns() throws Exception {
        ArrayList<ActionInsertFactCol52> actions = new ArrayList<ActionInsertFactCol52>(){
            {
                this.add(Mockito.mock(ActionInsertFactCol52.class));
            }
        };
        ArrayList<Pattern52> patterns = new ArrayList<Pattern52>(){
            {
                this.add(Mockito.mock(Pattern52.class));
            }
        };
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)actions).when((Object)this.model)).getActionCols();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)patterns).when((Object)this.model)).getPatterns();
        List result = this.plugin.getPatterns();
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testConstraintValue() throws Exception {
        Assert.assertEquals((long)0L, (long)this.plugin.constraintValue());
    }

    @Test
    public void testGetAccessor() throws Exception {
        Assert.assertEquals((Object)FieldAccessorsAndMutators.ACCESSOR, (Object)this.plugin.getAccessor());
    }

    @Test
    public void testGetFactField() throws Exception {
        String expectedFactField = "factField";
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factField").when((Object)this.editingWrapper)).getFactField();
        String actualFactField = this.plugin.getFactField();
        Assert.assertEquals((Object)"factField", (Object)actualFactField);
    }

    @Test
    public void testSetFactFieldWhenFactPattern() throws Exception {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        String factField = "factField";
        String factType = "factType";
        String boundName = "boundName";
        String type = "type";
        ((PatternWrapper)Mockito.doReturn((Object)"factType").when((Object)patternWrapper)).getFactType();
        ((PatternWrapper)Mockito.doReturn((Object)"boundName").when((Object)patternWrapper)).getBoundName();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)this.editingWrapper).when((Object)this.plugin)).editingWrapper();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)"type").when((Object)this.oracle)).getFieldType((String)Mockito.any(), (String)Mockito.any());
        this.plugin.setFactField("factField");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setFactField("factField");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setFactType("factType");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setBoundName("boundName");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setType("type");
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
    }

    @Test
    public void testShowUpdateEngineWithChangesWhenFactPatternIsNew() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        boolean updateEngineWithChanges = this.plugin.showUpdateEngineWithChanges();
        Assert.assertFalse((boolean)updateEngineWithChanges);
    }

    @Test
    public void testShowUpdateEngineWithChangesWhenFactPatternIsNotNew() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewFactPattern();
        boolean updateEngineWithChanges = this.plugin.showUpdateEngineWithChanges();
        Assert.assertTrue((boolean)updateEngineWithChanges);
    }

    @Test
    public void testShowLogicallyInsertWhenFactPatternIsNew() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        boolean logicallyInsert = this.plugin.showLogicallyInsert();
        Assert.assertTrue((boolean)logicallyInsert);
    }

    @Test
    public void testShowLogicallyInsertWhenFactPatternIsNotNew() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewFactPattern();
        boolean logicallyInsert = this.plugin.showLogicallyInsert();
        Assert.assertFalse((boolean)logicallyInsert);
    }

    @Test
    public void testInitializedPatternPage() throws Exception {
        this.plugin.initializedPatternPage();
        ((PatternPage)Mockito.verify((Object)this.patternPage)).disableEntryPoint();
        ((PatternPage)Mockito.verify((Object)this.patternPage)).disableNegatedPatterns();
    }

    @Test
    public void testInitializedAdditionalInfoPage() throws Exception {
        this.plugin.initializedAdditionalInfoPage();
        ((AdditionalInfoPage)Mockito.verify((Object)this.additionalInfoPage)).enableHeader();
        ((AdditionalInfoPage)Mockito.verify((Object)this.additionalInfoPage)).enableLogicallyInsert();
        ((AdditionalInfoPage)Mockito.verify((Object)this.additionalInfoPage)).enableUpdateEngineWithChanges();
        ((AdditionalInfoPage)Mockito.verify((Object)this.additionalInfoPage)).enableHideColumn();
    }
}

