/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.RuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLActionColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={BRLRuleModel.class})
public class BRLActionColumnPluginTest {
    @Mock
    private RuleModellerPage ruleModellerPage;
    @Mock
    private AdditionalInfoPage<BRLActionColumnPlugin> additionalInfoPage;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private TranslationService translationService;
    @Mock
    private HandlerRegistration registration;
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @Mock
    private BRLActionColumn editingCol;
    @InjectMocks
    private BRLActionColumnPlugin plugin;

    public BRLActionColumnPluginTest() {
        this.plugin = (BRLActionColumnPlugin)Mockito.spy((Object)new BRLActionColumnPlugin(this.ruleModellerPage, this.additionalInfoPage, this.changeEvent, this.translationService));
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "BRLActionColumnPlugin.AddActionBRL";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("BRLActionColumnPlugin.AddActionBRL", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testInit() throws Exception {
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.plugin)).tableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)Mockito.mock(EventBus.class)).when((Object)this.presenter)).getEventBus();
        ((NewGuidedDecisionTableColumnWizard)Mockito.doReturn((Object)this.presenter).when((Object)this.wizard)).getPresenter();
        this.plugin.init(this.wizard);
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).setupEditingCol();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).setupRuleModellerEvents();
    }

    @Test
    public void testGetPages() throws Exception {
        List pages = this.plugin.getPages();
        Assert.assertEquals((long)2L, (long)pages.size());
    }

    @Test
    public void testOnClose() throws Exception {
        this.plugin.onClose();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).teardownRuleModellerEvents();
    }

    @Test
    public void testGenerateColumnWhenHeaderIsBlank() throws Exception {
        ((BRLActionColumn)Mockito.doReturn((Object)"").when((Object)this.editingCol)).getHeader();
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("BRLActionColumnPlugin.YouMustEnterAColumnHeaderValueDescription", new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenHeaderIsNotUnique() throws Exception {
        String header = "header";
        final ActionCol52 oldActionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        ArrayList<ActionCol52> actionCol52s = new ArrayList<ActionCol52>(){
            {
                this.add(oldActionCol52);
            }
        };
        Mockito.when((Object)oldActionCol52.getHeader()).thenReturn((Object)"header");
        Mockito.when((Object)model.getActionCols()).thenReturn((Object)actionCol52s);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Mockito.when((Object)this.editingCol.getHeader()).thenReturn((Object)"header");
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("BRLActionColumnPlugin.ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenHeaderIsValid() throws Exception {
        String header = "header";
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        ArrayList actionCol52s = new ArrayList();
        Mockito.when((Object)model.getActionCols()).thenReturn(actionCol52s);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Mockito.when((Object)this.editingCol.getHeader()).thenReturn((Object)"header");
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).getDefinedVariables((RuleModel)Mockito.any());
        ((BRLActionColumn)Mockito.verify((Object)this.editingCol)).setDefinition((List)Mockito.any());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn((ActionCol52)this.editingCol);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testGetHeader() throws Exception {
        this.plugin.getHeader();
        ((BRLActionColumn)Mockito.verify((Object)this.editingCol)).getHeader();
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "header";
        this.plugin.setHeader("header");
        ((BRLActionColumn)Mockito.verify((Object)this.editingCol)).setHeader("header");
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGetRuleModel() throws Exception {
        Assert.assertNotNull((Object)this.plugin.getRuleModel());
    }

    @Test
    public void testSetRuleModellerPageAsCompletedWhenItIsCompleted() throws Exception {
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isRuleModellerPageCompleted();
        this.plugin.setRuleModellerPageAsCompleted();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setRuleModellerPageCompleted();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.ruleModellerPage);
    }

    @Test
    public void testSetRuleModellerPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isRuleModellerPageCompleted();
        this.plugin.setRuleModellerPageAsCompleted();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).setRuleModellerPageCompleted();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.ruleModellerPage);
    }

    @Test
    public void testTableFormat() throws Exception {
        GuidedDecisionTable52.TableFormat expectedTableFormat = GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
        ((GuidedDecisionTable52)Mockito.doReturn((Object)expectedTableFormat).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        GuidedDecisionTable52.TableFormat actualTableFormat = this.plugin.tableFormat();
        Assert.assertEquals((Object)expectedTableFormat, (Object)actualTableFormat);
    }
}

