/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.CalculationTypePage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.OperatorPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.ValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ConditionColumnPluginTest {
    @Mock
    private PatternPage<ConditionColumnPlugin> patternPage;
    @Mock
    private CalculationTypePage calculationTypePage;
    @Mock
    private FieldPage fieldPage;
    @Mock
    private OperatorPage operatorPage;
    @Mock
    private AdditionalInfoPage<ConditionColumnPlugin> additionalInfoPage;
    @Mock
    private ValueOptionsPage valueOptionsPage;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private TranslationService translationService;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private ConditionCol52 editingCol;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @InjectMocks
    private ConditionColumnPlugin plugin;

    public ConditionColumnPluginTest() {
        this.plugin = (ConditionColumnPlugin)Mockito.spy((Object)new ConditionColumnPlugin(this.patternPage, this.calculationTypePage, this.fieldPage, this.operatorPage, this.valueOptionsPage, this.additionalInfoPage, this.changeEvent, this.translationService));
    }

    @Before
    public void setup() {
        GuidedDecisionTable52.TableFormat tableFormat = GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
        ((GuidedDecisionTable52)Mockito.doReturn((Object)tableFormat).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
    }

    @Test
    public void testGetPagesWhenItIsAnExtendedEntryTable() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        List pages = this.plugin.getPages();
        Assert.assertTrue((boolean)pages.stream().anyMatch(a -> a instanceof CalculationTypePage));
        Assert.assertEquals((long)6L, (long)pages.size());
    }

    @Test
    public void testGetPagesWhenItIsALimitedEntryTable() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        List pages = this.plugin.getPages();
        Assert.assertFalse((boolean)pages.stream().anyMatch(a -> a instanceof CalculationTypePage));
        Assert.assertEquals((long)5L, (long)pages.size());
    }

    @Test
    public void testIsValidWhenHeaderIsBlank() throws Exception {
        String errorKey = "ConditionColumnPlugin.YouMustEnterAColumnHeaderValueDescription";
        String errorMessage = "YouMustEnterAColumnHeaderValueDescription";
        ((ConditionCol52)Mockito.doReturn((Object)"").when((Object)this.editingCol)).getHeader();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((TranslationService)Mockito.doReturn((Object)"YouMustEnterAColumnHeaderValueDescription").when((Object)this.translationService)).format("ConditionColumnPlugin.YouMustEnterAColumnHeaderValueDescription", new Object[0]);
        boolean isValid = this.plugin.isValid();
        Assert.assertFalse((boolean)isValid);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).showError((String)Mockito.eq((Object)"YouMustEnterAColumnHeaderValueDescription"));
    }

    @Test
    public void testIsValidWhenConstraintValueIsNotPredicateAndFactFieldIsBlank() throws Exception {
        String errorKey = "ConditionColumnPlugin.PleaseSelectOrEnterField";
        String errorMessage = "PleaseSelectOrEnterField";
        ((ConditionCol52)Mockito.doReturn((Object)"Header").when((Object)this.editingCol)).getHeader();
        ((ConditionCol52)Mockito.doReturn((Object)"").when((Object)this.editingCol)).getFactField();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        ((TranslationService)Mockito.doReturn((Object)"PleaseSelectOrEnterField").when((Object)this.translationService)).format("ConditionColumnPlugin.PleaseSelectOrEnterField", new Object[0]);
        boolean isValid = this.plugin.isValid();
        Assert.assertFalse((boolean)isValid);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).showError((String)Mockito.eq((Object)"PleaseSelectOrEnterField"));
    }

    @Test
    public void testIsValidWhenConstraintValueIsNotPredicateAndOperatorIsBlank() throws Exception {
        String errorKey = "ConditionColumnPlugin.NotifyNoSelectedOperator";
        String errorMessage = "NotifyNoSelectedOperator";
        ((ConditionCol52)Mockito.doReturn((Object)"Header").when((Object)this.editingCol)).getHeader();
        ((ConditionCol52)Mockito.doReturn((Object)"FactField").when((Object)this.editingCol)).getFactField();
        ((ConditionCol52)Mockito.doReturn((Object)"").when((Object)this.editingCol)).getOperator();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        ((TranslationService)Mockito.doReturn((Object)"NotifyNoSelectedOperator").when((Object)this.translationService)).format("ConditionColumnPlugin.NotifyNoSelectedOperator", new Object[0]);
        boolean isValid = this.plugin.isValid();
        Assert.assertFalse((boolean)isValid);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).showError((String)Mockito.eq((Object)"NotifyNoSelectedOperator"));
    }

    @Test
    public void testIsValidWhenBindingIsNotUnique() throws Exception {
        String errorKey = "ConditionColumnPlugin.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern";
        String errorMessage = "PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern";
        ((ConditionCol52)Mockito.doReturn((Object)"Header").when((Object)this.editingCol)).getHeader();
        ((ConditionCol52)Mockito.doReturn((Object)"FactField").when((Object)this.editingCol)).getFactField();
        ((ConditionCol52)Mockito.doReturn((Object)"Operator").when((Object)this.editingCol)).getOperator();
        ((ConditionCol52)Mockito.doReturn((Object)"Binding").when((Object)this.editingCol)).getBinding();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isBindingNotUnique();
        ((ConditionCol52)Mockito.doReturn((Object)true).when((Object)this.editingCol)).isBound();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        ((TranslationService)Mockito.doReturn((Object)"PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern").when((Object)this.translationService)).format("ConditionColumnPlugin.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern", new Object[0]);
        boolean isValid = this.plugin.isValid();
        Assert.assertFalse((boolean)isValid);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).showError((String)Mockito.eq((Object)"PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern"));
    }

    @Test
    public void testIsValidWhenHeaderIsNotUnique() throws Exception {
        String errorKey = "ConditionColumnPlugin.ThatColumnNameIsAlreadyInUsePleasePickAnother";
        String errorMessage = "ThatColumnNameIsAlreadyInUsePleasePickAnother";
        ((ConditionCol52)Mockito.doReturn((Object)"Header").when((Object)this.editingCol)).getHeader();
        ((ConditionCol52)Mockito.doReturn((Object)"FactField").when((Object)this.editingCol)).getFactField();
        ((ConditionCol52)Mockito.doReturn((Object)"Operator").when((Object)this.editingCol)).getOperator();
        ((ConditionCol52)Mockito.doReturn((Object)"Binding").when((Object)this.editingCol)).getBinding();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isBindingNotUnique();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isHeaderNotUnique();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        ((TranslationService)Mockito.doReturn((Object)"ThatColumnNameIsAlreadyInUsePleasePickAnother").when((Object)this.translationService)).format("ConditionColumnPlugin.ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0]);
        boolean isValid = this.plugin.isValid();
        Assert.assertFalse((boolean)isValid);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).showError((String)Mockito.eq((Object)"ThatColumnNameIsAlreadyInUsePleasePickAnother"));
    }

    @Test
    public void testIsValidWhenItIsValid() throws Exception {
        ((ConditionCol52)Mockito.doReturn((Object)"Header").when((Object)this.editingCol)).getHeader();
        ((ConditionCol52)Mockito.doReturn((Object)"FactField").when((Object)this.editingCol)).getFactField();
        ((ConditionCol52)Mockito.doReturn((Object)"Operator").when((Object)this.editingCol)).getOperator();
        ((ConditionCol52)Mockito.doReturn((Object)"Binding").when((Object)this.editingCol)).getBinding();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isBindingNotUnique();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isHeaderNotUnique();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        boolean isValid = this.plugin.isValid();
        Assert.assertTrue((boolean)isValid);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).showError((String)Mockito.any());
    }

    @Test
    public void testPrepareValuesWhenConstraintValueIsPredicate() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)5).when((Object)this.plugin)).constraintValue();
        this.plugin.prepareValues();
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setOperator(null);
    }

    @Test
    public void testPrepareValuesWhenConstraintValueIsNotLiteral() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)0).when((Object)this.plugin)).constraintValue();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.prepareValues();
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setBinding(null);
    }

    @Test
    public void testAppendColumn() throws Exception {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        Pattern52 pattern52 = (Pattern52)Mockito.mock(Pattern52.class);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern52).when((Object)this.plugin)).editingPattern();
        this.plugin.appendColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn(pattern52, this.editingCol);
    }

    @Test
    public void testGenerateColumnWhenItIsValid() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)0).when((Object)this.plugin)).constraintValue();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isValid();
        this.plugin.setupDefaultValues();
        Boolean result = this.plugin.generateColumn();
        Assert.assertTrue((boolean)result);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).prepareValues();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).appendColumn();
    }

    @Test
    public void testGenerateColumnWhenItIsNotValid() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)0).when((Object)this.plugin)).constraintValue();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isValid();
        Boolean result = this.plugin.generateColumn();
        Assert.assertFalse((boolean)result);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).prepareValues();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).appendColumn();
    }

    @Test
    public void testGetEditingPattern() throws Exception {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        this.plugin.setEditingPattern(patternWrapper);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setupDefaultValues();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.patternPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.calculationTypePage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.operatorPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.valueOptionsPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGetEntryPointNameWheeunEditingPatternIsNotPresent() throws Exception {
        PatternWrapper patternWrapper = new PatternWrapper();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        String entryPointName = this.plugin.getEntryPointName();
        Assert.assertEquals((Object)"", (Object)entryPointName);
    }

    @Test
    public void testGetEntryPointNameWhenEditingPatternIsNotNull() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((PatternWrapper)Mockito.doReturn((Object)"EntryPointName").when((Object)pattern)).getEntryPointName();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        String entryPointName = this.plugin.getEntryPointName();
        Assert.assertEquals((Object)"EntryPointName", (Object)entryPointName);
    }

    @Test
    public void testSetEntryPointName() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        this.plugin.setEntryPointName("EntryPointName");
        ((PatternWrapper)Mockito.verify((Object)pattern)).setEntryPointName("EntryPointName");
    }

    @Test
    public void testEditingColWhenEditingPatternIsNull() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((PatternWrapper)Mockito.doReturn((Object)"").when((Object)pattern)).getFactType();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        this.plugin.editingCol();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).resetFieldAndOperator();
    }

    @Test
    public void testEditingColWhenEditingPatternIsNotNull() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((PatternWrapper)Mockito.doReturn((Object)"factType").when((Object)pattern)).getFactType();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        this.plugin.editingCol();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).resetFieldAndOperator();
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "Header";
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.setHeader("Header");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setHeader("Header");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGetFactType() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        String expectedFactType = "FactType";
        ((PatternWrapper)Mockito.doReturn((Object)"FactType").when((Object)pattern)).getFactType();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        String factType = this.plugin.getFactType();
        Assert.assertEquals((Object)"FactType", (Object)factType);
    }

    @Test
    public void testGetFactField() throws Exception {
        String expectedFactField = "FactField";
        ((ConditionCol52)Mockito.doReturn((Object)"FactField").when((Object)this.editingCol)).getFactField();
        String factField = this.plugin.getFactField();
        Assert.assertEquals((Object)"FactField", (Object)factField);
    }

    @Test
    public void testSetFactField() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((ConditionCol52)Mockito.doReturn((Object)"FactField").when((Object)this.editingCol)).getFactField();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((PatternWrapper)Mockito.doReturn((Object)"FactType").when((Object)pattern)).getFactType();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        this.plugin.setFactField("FactField");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setFactField("FactField");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setFieldType(this.oracle.getFieldType("FactField", "FactType"));
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.operatorPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.valueOptionsPage);
    }

    @Test
    public void testSetOperator() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.setOperator("operator");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setOperator("operator");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.operatorPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.valueOptionsPage);
    }

    @Test
    public void testConstraintValueWhenItHasEnums() throws Exception {
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)true).when((Object)this.oracle)).hasEnums(Mockito.anyString(), Mockito.anyString());
        int constraintValue = this.plugin.constraintValue();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setConstraintValueFieldAndUpdateEditingCol(1);
        Assert.assertEquals((long)1L, (long)constraintValue);
    }

    @Test
    public void testConstraintValueWhenItDoesNotHaveEnums() throws Exception {
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)false).when((Object)this.oracle)).hasEnums(Mockito.anyString(), Mockito.anyString());
        int constraintValue = this.plugin.constraintValue();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setConstraintValueFieldAndUpdateEditingCol(1);
        Assert.assertEquals((long)0L, (long)constraintValue);
    }

    @Test
    public void testSetConstraintValue() throws Exception {
        boolean constraintValue = true;
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.setConstraintValue(1);
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setConstraintValueType(1);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setConstraintValueFieldAndUpdateEditingCol(1);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).resetFieldAndOperator();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.calculationTypePage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.operatorPage);
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsCompleted() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isValueOptionsPageCompleted();
        this.plugin.setValueOptionsPageAsCompleted();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setValueOptionsPageCompleted();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.valueOptionsPage);
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isValueOptionsPageCompleted();
        this.plugin.setValueOptionsPageAsCompleted();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setValueOptionsPageCompleted();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.valueOptionsPage);
    }

    @Test
    public void testSetValueList() throws Exception {
        String valueList = "valueList";
        DTCellValue52 cellValue52 = (DTCellValue52)Mockito.mock(DTCellValue52.class);
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        DataType.DataTypes dataTypes = DataType.DataTypes.STRING;
        this.plugin.setupDefaultValues();
        ((PatternWrapper)Mockito.doReturn((Object)"FactType").when((Object)pattern)).getFactType();
        ((DTCellValue52)Mockito.doReturn((Object)dataTypes).when((Object)cellValue52)).getDataType();
        ((ConditionCol52)Mockito.doReturn((Object)cellValue52).when((Object)this.editingCol)).getDefaultValue();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        this.plugin.setValueList("valueList");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setValueList("valueList");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).assertDefaultValue();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.valueOptionsPage);
    }

    @Test
    public void testGetTitle() {
        String errorKey = "ConditionColumnPlugin.AddNewConditionSimpleColumn";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("ConditionColumnPlugin.AddNewConditionSimpleColumn", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testInit() {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.model).when((Object)this.plugin)).model();
        this.plugin.init(this.wizard);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setupDefaultValues();
    }
}

