/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTablePinnedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.menu.MenuItemDivider;
import org.uberfire.ext.widgets.common.client.menu.MenuItemDividerView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemFactory;
import org.uberfire.ext.widgets.common.client.menu.MenuItemHeader;
import org.uberfire.ext.widgets.common.client.menu.MenuItemHeaderView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIcon;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIconView;

@RunWith(value=MockitoJUnitRunner.class)
public class ViewMenuBuilderTest {
    private ViewMenuBuilder builder;
    @Mock
    private TranslationService ts;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewProducer;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewHeaderProducer;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewWithIconProducer;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewDividerProducer;
    private MenuItemFactory menuItemFactory;
    private Set<MenuItemView> menuItemFactoryViewMocks = new HashSet<MenuItemView>();
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter;
    private GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
    @Mock
    private GuidedDecisionTableView dtPresenterView;
    @Mock
    private GuidedDecisionTableModellerView.Presenter modeller;

    @Before
    public void setup() {
        this.menuItemFactory = new MenuItemFactory(this.menuItemViewProducer);
        this.menuItemFactoryViewMocks.clear();
        Mockito.when((Object)this.dtPresenter.getAccess()).thenReturn((Object)this.access);
        Mockito.when((Object)this.ts.getTranslation((String)Mockito.any(String.class))).thenReturn((Object)"i18n");
        Mockito.when((Object)this.menuItemViewProducer.select(new Annotation[]{(Annotation)Mockito.any(Annotation.class)})).thenAnswer(o -> {
            Annotation a = (Annotation)o.getArguments()[0];
            if (a.annotationType().equals(MenuItemHeader.class)) {
                return this.menuItemViewHeaderProducer;
            }
            if (a.annotationType().equals(MenuItemWithIcon.class)) {
                return this.menuItemViewWithIconProducer;
            }
            if (a.annotationType().equals(MenuItemDivider.class)) {
                return this.menuItemViewDividerProducer;
            }
            throw new IllegalArgumentException("Unexpected MenuItemView");
        });
        Mockito.when((Object)this.menuItemViewHeaderProducer.get()).then(invocation -> {
            MenuItemHeaderView v = (MenuItemHeaderView)Mockito.mock(MenuItemHeaderView.class);
            this.menuItemFactoryViewMocks.add((MenuItemView)v);
            return v;
        });
        Mockito.when((Object)this.menuItemViewWithIconProducer.get()).then(invocation -> {
            MenuItemWithIconView v = (MenuItemWithIconView)Mockito.mock(MenuItemWithIconView.class);
            this.menuItemFactoryViewMocks.add((MenuItemView)v);
            return v;
        });
        Mockito.when((Object)this.menuItemViewDividerProducer.get()).then(invocation -> {
            MenuItemDividerView v = (MenuItemDividerView)Mockito.mock(MenuItemDividerView.class);
            this.menuItemFactoryViewMocks.add((MenuItemView)v);
            return v;
        });
        this.builder = new ViewMenuBuilder(this.ts, this.menuItemFactory);
        this.builder.setup();
        this.builder.setModeller(this.modeller);
    }

    @Test
    public void testInitialSetup() {
        Assert.assertTrue((boolean)this.builder.miZoom125pct.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miZoom100pct.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miZoom75pct.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miZoom50pct.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom125pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom100pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom75pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom50pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        Assert.assertFalse((boolean)this.builder.miToggleMergeState.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miViewAuditLog.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectedEventWithNonOtherwiseColumnSelected() {
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miToggleMergeState.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miViewAuditLog.getMenuItem().isEnabled());
    }

    @Test
    public void testOnZoom125() {
        this.menuItemFactoryViewMocks.stream().forEach(xva$0 -> Mockito.reset((Object[])new MenuItemView[]{xva$0}));
        this.builder.onZoom(125);
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom125pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom100pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom75pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom50pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).setZoom(Mockito.eq((int)125));
    }

    @Test
    public void testOnZoom100() {
        this.menuItemFactoryViewMocks.stream().forEach(xva$0 -> Mockito.reset((Object[])new MenuItemView[]{xva$0}));
        this.builder.onZoom(100);
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom125pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom100pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom75pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom50pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).setZoom(Mockito.eq((int)100));
    }

    @Test
    public void testOnZoom75() {
        this.menuItemFactoryViewMocks.stream().forEach(xva$0 -> Mockito.reset((Object[])new MenuItemView[]{xva$0}));
        this.builder.onZoom(75);
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom125pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom100pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom75pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom50pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).setZoom(Mockito.eq((int)75));
    }

    @Test
    public void testOnZoom50() {
        this.menuItemFactoryViewMocks.stream().forEach(xva$0 -> Mockito.reset((Object[])new MenuItemView[]{xva$0}));
        this.builder.onZoom(50);
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom125pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom100pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom75pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom50pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).setZoom(Mockito.eq((int)50));
    }

    @Test
    public void testToggleMergeState() {
        Mockito.when((Object)this.dtPresenter.isMerged()).thenReturn((Object)false);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miToggleMergeState.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miViewAuditLog.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miToggleMergeState.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
        this.builder.onToggleMergeState();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).setMerged(Mockito.eq((boolean)true));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miToggleMergeState.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
    }

    @Test
    public void testViewAuditLog() {
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        this.builder.onViewAuditLog();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).showAuditLog();
    }

    @Test
    public void testEnableZoom_Pinned() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent(this.modeller, true));
        Assert.assertFalse((boolean)this.builder.miZoom125pct.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miZoom100pct.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miZoom75pct.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miZoom50pct.getMenuItem().isEnabled());
    }

    @Test
    public void testEnableZoom_Pinned_DifferentModeller() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent((GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class), true));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom125pct.getMenuItemView(), (VerificationMode)Mockito.never())).setEnabled(((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom100pct.getMenuItemView(), (VerificationMode)Mockito.never())).setEnabled(((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom75pct.getMenuItemView(), (VerificationMode)Mockito.never())).setEnabled(((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom50pct.getMenuItemView(), (VerificationMode)Mockito.never())).setEnabled(((Boolean)Mockito.any(Boolean.class)).booleanValue());
    }

    @Test
    public void testEnableZoom_Unpinned() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent(this.modeller, false));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom125pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)true));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom100pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)true));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom75pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)true));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom50pct.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)true));
    }

    @Test
    public void testEnableZoom_Unpinned_DifferentModeller() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent((GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class), false));
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom125pct.getMenuItemView(), (VerificationMode)Mockito.never())).setEnabled(((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom100pct.getMenuItemView(), (VerificationMode)Mockito.never())).setEnabled(((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom75pct.getMenuItemView(), (VerificationMode)Mockito.never())).setEnabled(((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miZoom50pct.getMenuItemView(), (VerificationMode)Mockito.never())).setEnabled(((Boolean)Mockito.any(Boolean.class)).booleanValue());
    }

    @Test
    public void testOnDecisionTableSelectedEventReadOnly() {
        Assert.assertFalse((boolean)this.builder.miToggleMergeState.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miViewAuditLog.getMenuItem().isEnabled());
        this.dtPresenter.getAccess().setReadOnly(true);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertFalse((boolean)this.builder.miToggleMergeState.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miViewAuditLog.getMenuItem().isEnabled());
    }
}

