/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashMap;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionPopup;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionPopupView;
import org.drools.workbench.screens.guided.rule.client.editor.CEPWindowOperatorsDropdown;
import org.gwtbootstrap3.client.ui.InlineRadio;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.TextBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.common.ImageButton;

@WithClassesToStub(value={Modal.class, GuidedDecisionTableImageResources508.class, CEPWindowOperatorsDropdown.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class ConditionPopupViewTest {
    @Mock
    private ConditionPopup presenter;
    @Mock
    private Pattern52 pattern52;
    @Mock
    private ConditionCol52 conditionCol52;
    @Mock
    private ImageButton changePattern;
    @Mock
    private InlineRadio literal;
    @Mock
    private InlineRadio predicate;
    @Mock
    private InlineRadio formula;
    @Mock
    private TextBox binding;
    @Mock
    private TextBox fieldLabel;
    @Mock
    private ImageButton editField;
    @Mock
    private ImageButton operator;
    @Mock
    private TextBox entryPoint;
    @Mock
    private TextBox header;
    @Mock
    private TextBox valueList;
    @Mock
    private BlurEvent blurEvent;
    @Mock
    private ClickEvent event;
    @Mock
    private ChangeEvent changeEvent;
    @Captor
    private ArgumentCaptor<BlurHandler> blurHandlerCaptor;
    @Captor
    private ArgumentCaptor<ClickHandler> clickHandlerCaptor;
    @Captor
    private ArgumentCaptor<ChangeHandler> changeHandlerCaptor;
    private ConditionPopupView view;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("drools.dateformat", "dd-MM-yyyy");
        ApplicationPreferences.setUp(args);
        Mockito.when((Object)this.pattern52.getEntryPointName()).thenReturn((Object)"entry_point_name");
        Mockito.when((Object)this.presenter.getEditingCol()).thenReturn((Object)this.conditionCol52);
        Mockito.when((Object)this.presenter.getEditingPattern()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.presenter.getConstraintValueType()).thenReturn((Object)1);
        Mockito.when((Object)this.presenter.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        this.view = (ConditionPopupView)Mockito.spy((Object)new ConditionPopupView(this.presenter){

            protected Image getEditImage() {
                return (Image)Mockito.mock(Image.class);
            }

            protected Image getDisabledImage() {
                return (Image)Mockito.mock(Image.class);
            }
        });
    }

    @Test
    public void testInitializeViewChangePattern() throws Exception {
        this.view.changePattern = this.changePattern;
        this.view.initializeView();
        ((ImageButton)Mockito.verify((Object)this.changePattern)).addClickHandler((ClickHandler)this.clickHandlerCaptor.capture());
        ((ClickHandler)this.clickHandlerCaptor.getValue()).onClick(this.event);
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).showChangePattern(this.event);
        ((ImageButton)Mockito.verify((Object)this.changePattern)).setEnabled(true);
    }

    @Test
    public void testInitializeViewExtendedEntries() throws Exception {
        this.view.predicate = this.predicate;
        this.view.formula = this.formula;
        this.view.literal = this.literal;
        this.view.initializeView();
        ((InlineRadio)Mockito.verify((Object)this.literal)).setValue(Boolean.valueOf(true));
        ((InlineRadio)Mockito.verify((Object)this.predicate, (VerificationMode)Mockito.never())).setValue(Boolean.valueOf(Matchers.anyBoolean()));
        ((InlineRadio)Mockito.verify((Object)this.formula, (VerificationMode)Mockito.never())).setValue(Boolean.valueOf(Matchers.anyBoolean()));
        ((InlineRadio)Mockito.verify((Object)this.literal)).addClickHandler((ClickHandler)this.clickHandlerCaptor.capture());
        ((ClickHandler)this.clickHandlerCaptor.getValue()).onClick(this.event);
        ((ConditionPopup)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setFactField(null);
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).applyConsTypeChange(1);
        ((InlineRadio)Mockito.verify((Object)this.formula)).addClickHandler((ClickHandler)this.clickHandlerCaptor.capture());
        ((ClickHandler)this.clickHandlerCaptor.getValue()).onClick(this.event);
        ((ConditionPopup)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setFactField(null);
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).applyConsTypeChange(3);
        ((InlineRadio)Mockito.verify((Object)this.predicate)).addClickHandler((ClickHandler)this.clickHandlerCaptor.capture());
        ((ClickHandler)this.clickHandlerCaptor.getValue()).onClick(this.event);
        ((ConditionPopup)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).setFactField(null);
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).applyConsTypeChange(5);
    }

    @Test
    public void testInitializeViewLimitedEntries() throws Exception {
        Mockito.when((Object)this.presenter.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        this.view.binding = this.binding;
        this.view.initializeView();
        ((TextBox)Mockito.verify((Object)this.binding)).setEnabled(true);
    }

    @Test
    public void testInitializeViewField() throws Exception {
        this.view.editField = this.editField;
        this.view.fieldLabel = this.fieldLabel;
        this.view.initializeView();
        ((TextBox)Mockito.verify((Object)this.fieldLabel)).setEnabled(true);
        ((ImageButton)Mockito.verify((Object)this.editField)).addClickHandler((ClickHandler)this.clickHandlerCaptor.capture());
        ((ClickHandler)this.clickHandlerCaptor.getValue()).onClick(this.event);
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).showFieldChange();
        ((ImageButton)Mockito.verify((Object)this.editField)).setEnabled(true);
    }

    @Test
    public void testInitializeViewOperator() throws Exception {
        this.view.editOp = this.operator;
        this.view.initializeView();
        ((ImageButton)Mockito.verify((Object)this.operator)).addClickHandler((ClickHandler)this.clickHandlerCaptor.capture());
        ((ClickHandler)this.clickHandlerCaptor.getValue()).onClick(this.event);
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).showOperatorChange();
        ((ImageButton)Mockito.verify((Object)this.operator)).setEnabled(true);
    }

    @Test
    public void testInitializeViewEntryPoint() throws Exception {
        Mockito.when((Object)this.entryPoint.getText()).thenReturn((Object)"new_ep_name");
        this.view.entryPointName = this.entryPoint;
        this.view.initializeView();
        ((TextBox)Mockito.verify((Object)this.entryPoint)).setText("entry_point_name");
        ((TextBox)Mockito.verify((Object)this.entryPoint)).setEnabled(true);
        ((TextBox)Mockito.verify((Object)this.entryPoint)).addChangeHandler((ChangeHandler)this.changeHandlerCaptor.capture());
        ((ChangeHandler)this.changeHandlerCaptor.getValue()).onChange(this.changeEvent);
        ((Pattern52)Mockito.verify((Object)this.pattern52)).setEntryPointName("new_ep_name");
    }

    @Test
    public void testInitializeViewHeader() throws Exception {
        Mockito.when((Object)this.header.getText()).thenReturn((Object)"NewConditionHeader");
        Mockito.when((Object)this.presenter.getHeader()).thenReturn((Object)"ConditionHeader");
        this.view.header = this.header;
        this.view.initializeView();
        ((TextBox)Mockito.verify((Object)this.header)).setEnabled(true);
        ((TextBox)Mockito.verify((Object)this.header)).setText("ConditionHeader");
        ((TextBox)Mockito.verify((Object)this.header)).addChangeHandler((ChangeHandler)this.changeHandlerCaptor.capture());
        ((ChangeHandler)this.changeHandlerCaptor.getValue()).onChange(this.changeEvent);
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).setHeader("NewConditionHeader");
    }

    @Test
    public void testInitializeViewValueListWidget() throws Exception {
        Mockito.when((Object)this.presenter.getValueList()).thenReturn((Object)"a,b,c");
        Mockito.when((Object)this.valueList.getText()).thenReturn((Object)"c,b,a");
        this.view.valueListWidget = this.valueList;
        this.view.initializeView();
        ((TextBox)Mockito.verify((Object)this.valueList)).addChangeHandler((ChangeHandler)this.changeHandlerCaptor.capture());
        ((ChangeHandler)this.changeHandlerCaptor.getValue()).onChange(this.changeEvent);
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).setValueList("c,b,a");
        ((TextBox)Mockito.verify((Object)this.valueList)).addBlurHandler((BlurHandler)this.blurHandlerCaptor.capture());
        ((BlurHandler)this.blurHandlerCaptor.getValue()).onBlur(this.blurEvent);
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).assertDefaultValue();
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).makeDefaultValueWidget();
    }

    @Test
    public void testInitializeViewBinding() throws Exception {
        Mockito.when((Object)this.binding.getText()).thenReturn((Object)"NewBinding");
        Mockito.when((Object)this.presenter.getBinding()).thenReturn((Object)"$b");
        this.view.binding = this.binding;
        this.view.initializeView();
        ((TextBox)Mockito.verify((Object)this.binding)).setText("$b");
        ((TextBox)Mockito.verify((Object)this.binding)).addChangeHandler((ChangeHandler)this.changeHandlerCaptor.capture());
        ((ChangeHandler)this.changeHandlerCaptor.getValue()).onChange(this.changeEvent);
        ((ConditionPopup)Mockito.verify((Object)this.presenter)).setBinding("NewBinding");
    }

    @Test
    public void testAddDefaultValueIfNoPresent() throws Exception {
        ((ConditionPopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addAttribute(Matchers.anyString(), (IsWidget)Matchers.any(IsWidget.class));
        this.view.addDefaultValueIfNoPresent();
        ((ConditionPopupView)Mockito.verify((Object)this.view)).addAttribute((String)Matchers.eq((Object)(GuidedDecisionTableConstants.INSTANCE.DefaultValue() + ":")), (IsWidget)Matchers.any(SimplePanel.class));
        this.view.addDefaultValueIfNoPresent();
        ((ConditionPopupView)Mockito.verify((Object)this.view)).addAttribute((String)Matchers.eq((Object)(GuidedDecisionTableConstants.INSTANCE.DefaultValue() + ":")), (IsWidget)Matchers.any(SimplePanel.class));
    }
}

