/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssuePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssuePresenterView;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class IssuePresenterTest {
    private IssuePresenter screen;
    private IssuePresenterView view;

    @Before
    public void setUp() throws Exception {
        this.view = (IssuePresenterView)Mockito.mock(IssuePresenterView.class);
        this.screen = new IssuePresenter(this.view);
    }

    @Test
    public void testShow() throws Exception {
        Issue issue = new Issue(Severity.WARNING, CheckType.REDUNDANT_ROWS, new HashSet<Integer>(Arrays.asList(1, 2, 3)));
        this.screen.show(issue);
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setIssueTitle("RedundantRows");
        ArgumentCaptor safeHtmlArgumentCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setExplanation((SafeHtml)safeHtmlArgumentCaptor.capture());
        Assert.assertEquals((Object)"<p>MissingRangeP1(2)</p>", (Object)((SafeHtml)safeHtmlArgumentCaptor.getValue()).asString());
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setLines("1, 2, 3");
    }

    @Test
    public void testShowEmptyIssue() throws Exception {
        this.screen.show(Issue.EMPTY);
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setIssueTitle("---");
        ArgumentCaptor safeHtmlArgumentCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setExplanation((SafeHtml)safeHtmlArgumentCaptor.capture());
        Assert.assertEquals((Object)"---", (Object)((SafeHtml)safeHtmlArgumentCaptor.getValue()).asString());
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setLines("");
    }

    @Test
    public void testClear() throws Exception {
        this.screen.clear();
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setIssueTitle("");
        ArgumentCaptor safeHtmlArgumentCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setExplanation((SafeHtml)safeHtmlArgumentCaptor.capture());
        Assert.assertEquals((Object)"", (Object)((SafeHtml)safeHtmlArgumentCaptor.getValue()).asString());
        ((IssuePresenterView)Mockito.verify((Object)this.view)).hideLines();
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setLines("");
    }
}

