/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.auditlog;

import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.datamodel.auditlog.AuditLog;
import org.drools.workbench.models.datamodel.auditlog.AuditLogFilter;
import org.drools.workbench.models.guided.dtable.shared.auditlog.DecisionTableAuditLogFilter;
import org.drools.workbench.screens.guided.dtable.client.widget.auditlog.AuditLogViewImpl;
import org.gwtbootstrap3.client.ui.Pagination;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class})
public class AuditLogViewImplTest {
    @Mock
    private User identity;
    private AuditLog auditLog;
    private AuditLogViewImpl view;
    @GwtMock
    Pagination cellTablePagination;

    @Before
    public void setup() {
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd/MM/yyyy");
            }
        });
        this.auditLog = new AuditLog((AuditLogFilter)new DecisionTableAuditLogFilter());
        AuditLogViewImplFake wrapped = new AuditLogViewImplFake(this.auditLog, this.identity);
        this.view = (AuditLogViewImpl)Mockito.spy((Object)((Object)wrapped));
    }

    @Test
    public void showingModalRefreshesDataProvider() {
        this.view.show();
        ((AuditLogViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).refreshDataProvider();
    }

    @Test
    public void checkPaginationIsSynchronizedWithDataListProvider() {
        this.view.show();
        ((Pagination)Mockito.verify((Object)this.cellTablePagination, (VerificationMode)Mockito.times((int)1))).rebuild((SimplePager)Mockito.any(SimplePager.class));
    }

    private static class AuditLogViewImplFake
    extends AuditLogViewImpl {
        private AuditLogViewImplFake(AuditLog auditLog, User identity) {
            super(auditLog, identity);
        }

        public boolean isAttached() {
            return true;
        }
    }
}

