/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerViewImpl;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.accordion.GuidedDecisionTableAccordion;
import org.drools.workbench.screens.guided.dtable.client.widget.table.accordion.GuidedDecisionTableAccordionItem;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.AttributeColumnConfigRowView;
import org.gwtbootstrap3.client.ui.Button;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.ruleselector.RuleSelector;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={GridLienzoPanel.class, DefaultGridLayer.class, GridWidget.class, RestrictedMousePanMediator.class})
public class GuidedDecisionTableModellerViewImplTest {
    @Mock
    FlowPanel flowPanel;
    @Mock
    GridLienzoPanel gridPanel;
    @Mock
    DefaultGridLayer gridLayer;
    @Mock
    DefaultGridLayer defaultGridLayer;
    @Mock
    RestrictedMousePanMediator restrictedMousePanMediator;
    @Mock
    VerticalPanel attributeConfigWidget;
    @Mock
    GuidedDecisionTableAccordion accordion;
    @Mock
    GuidedDecisionTableModellerView.Presenter presenter;
    @Mock
    GuidedDecisionTableView.Presenter viewPresenter;
    GuidedDecisionTableModellerViewImpl view;

    @Before
    public void setup() {
        this.view = (GuidedDecisionTableModellerViewImpl)Mockito.spy((Object)((Object)new GuidedDecisionTableModellerViewImplFake()));
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd/mm/yy");
            }
        });
    }

    @Test
    public void testInit() throws Exception {
        ((GuidedDecisionTableModellerViewImpl)Mockito.doNothing().when((Object)this.view)).setupAccordion(this.presenter);
        this.view.init(this.presenter);
        ((GuidedDecisionTableModellerViewImpl)Mockito.verify((Object)this.view)).setupAccordion(this.presenter);
    }

    @Test
    public void testSetupAccordion() throws Exception {
        FlowPanel accordionContainer = (FlowPanel)Mockito.mock(FlowPanel.class);
        Widget accordionWidget = (Widget)Mockito.mock(Widget.class);
        Widget ruleInheritanceWidget = (Widget)Mockito.mock(Widget.class);
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.accordion).when((Object)this.view)).makeAccordion(this.presenter);
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)accordionContainer).when((Object)this.view)).getAccordionContainer();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)accordionWidget).when((Object)this.view)).asWidget(this.accordion);
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)ruleInheritanceWidget).when((Object)this.view)).ruleInheritanceWidget();
        this.view.setupAccordion(this.presenter);
        ((FlowPanel)Mockito.verify((Object)accordionContainer)).add(accordionWidget);
        ((FlowPanel)Mockito.verify((Object)accordionContainer)).add(ruleInheritanceWidget);
    }

    @Test
    public void testMakeAccordion() {
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.accordion).when((Object)this.view)).getGuidedDecisionTableAccordion();
        GuidedDecisionTableAccordion actualAccordion = this.view.makeAccordion(this.presenter);
        ((GuidedDecisionTableAccordion)Mockito.verify((Object)this.accordion)).addItem(GuidedDecisionTableAccordionItem.Type.ATTRIBUTE, (Widget)this.view.getAttributeConfigWidget());
        ((GuidedDecisionTableAccordion)Mockito.verify((Object)this.accordion)).addItem(GuidedDecisionTableAccordionItem.Type.METADATA, (Widget)this.view.getMetaDataConfigWidget());
        ((GuidedDecisionTableAccordion)Mockito.verify((Object)this.accordion)).addItem(GuidedDecisionTableAccordionItem.Type.CONDITION, (Widget)this.view.getConditionsConfigWidget());
        ((GuidedDecisionTableAccordion)Mockito.verify((Object)this.accordion)).addItem(GuidedDecisionTableAccordionItem.Type.ACTION, (Widget)this.view.getActionsConfigWidget());
        Assert.assertEquals((Object)this.accordion, (Object)actualAccordion);
    }

    @Test
    public void testRuleInheritanceWidget() throws Exception {
        Label label = (Label)Mockito.mock(Label.class);
        Widget widget = (Widget)Mockito.mock(Widget.class);
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.flowPanel).when((Object)this.view)).makeFlowPanel();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)label).when((Object)this.view)).ruleInheritanceLabel();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)widget).when((Object)this.view)).ruleSelector();
        Widget ruleInheritanceWidget = this.view.ruleInheritanceWidget();
        ((FlowPanel)Mockito.verify((Object)this.flowPanel)).setStyleName(GuidedDecisionTableResources.INSTANCE.css().ruleInheritance());
        ((FlowPanel)Mockito.verify((Object)this.flowPanel)).add((Widget)label);
        ((FlowPanel)Mockito.verify((Object)this.flowPanel)).add(widget);
        Assert.assertEquals((Object)this.flowPanel, (Object)ruleInheritanceWidget);
    }

    @Test
    public void testRuleSelector() throws Exception {
        RuleSelector ruleSelector = (RuleSelector)Mockito.mock(RuleSelector.class);
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)ruleSelector).when((Object)this.view)).getRuleSelector();
        Widget actualRuleSelector = this.view.ruleSelector();
        ((RuleSelector)Mockito.verify((Object)ruleSelector)).setEnabled(false);
        ((RuleSelector)Mockito.verify((Object)ruleSelector)).addValueChangeHandler((ValueChangeHandler)Mockito.any());
        ((RuleSelector)Mockito.verify((Object)ruleSelector)).setStyleName(GuidedDecisionTableResources.INSTANCE.css().ruleInheritanceDropdown());
        Assert.assertEquals((Object)ruleSelector, (Object)actualRuleSelector);
    }

    @Test
    public void testRuleInheritanceLabel() throws Exception {
        Label label = this.view.ruleInheritanceLabel();
        Assert.assertNotNull((Object)label);
    }

    @Test
    public void testSetupSubMenu() throws Exception {
        Button addColumn = (Button)Mockito.mock(Button.class);
        Button editColumns = (Button)Mockito.mock(Button.class);
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)addColumn).when((Object)this.view)).getAddColumn();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)editColumns).when((Object)this.view)).getEditColumns();
        this.view.setupSubMenu();
        ((Button)Mockito.verify((Object)addColumn)).addClickHandler((ClickHandler)Mockito.any());
        ((Button)Mockito.verify((Object)editColumns)).addClickHandler((ClickHandler)Mockito.any());
    }

    @Test
    public void testAddColumn() throws Exception {
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.presenter).when((Object)this.view)).getPresenter();
        this.view.addColumn();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.presenter)).openNewGuidedDecisionTableColumnWizard();
    }

    @Test
    public void testEditColumns() throws Exception {
        FlowPanel accordionContainer = (FlowPanel)Mockito.mock(FlowPanel.class);
        Button editColumns = (Button)Mockito.mock(Button.class);
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.presenter).when((Object)this.view)).getPresenter();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)accordionContainer).when((Object)this.view)).getAccordionContainer();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)editColumns).when((Object)this.view)).getEditColumns();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doNothing().when((Object)this.view)).toggleClassName((Widget)Mockito.any(), (String)Mockito.any());
        this.view.editColumns();
        ((GuidedDecisionTableModellerViewImpl)Mockito.verify((Object)this.view)).toggleClassName((Widget)accordionContainer, GuidedDecisionTableResources.INSTANCE.css().openedAccordion());
        ((GuidedDecisionTableModellerViewImpl)Mockito.verify((Object)this.view)).toggleClassName((Widget)editColumns, "active");
    }

    @Test
    public void testRefreshAttributeWidgetEmpty() throws Exception {
        GuidedDecisionTableAccordionItem item = (GuidedDecisionTableAccordionItem)Mockito.mock(GuidedDecisionTableAccordionItem.class);
        Label blankSlate = (Label)Mockito.mock(Label.class);
        ArrayList columns = new ArrayList();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.accordion).when((Object)this.view)).getAccordion();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.attributeConfigWidget).when((Object)this.view)).getAttributeConfigWidget();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)blankSlate).when((Object)this.view)).blankSlate();
        ((GuidedDecisionTableAccordion)Mockito.doReturn((Object)item).when((Object)this.accordion)).getItem(GuidedDecisionTableAccordionItem.Type.ATTRIBUTE);
        this.view.refreshAttributeWidget(columns);
        ((VerticalPanel)Mockito.verify((Object)this.attributeConfigWidget)).clear();
        ((VerticalPanel)Mockito.verify((Object)this.attributeConfigWidget)).add((Widget)blankSlate);
        ((GuidedDecisionTableAccordionItem)Mockito.verify((Object)item)).setOpen(false);
    }

    @Test
    public void testRefreshAttributeWidget() throws Exception {
        GuidedDecisionTableAccordionItem item = (GuidedDecisionTableAccordionItem)Mockito.mock(GuidedDecisionTableAccordionItem.class);
        Label blankSlate = (Label)Mockito.mock(Label.class);
        ArrayList<AttributeCol52> columns = new ArrayList<AttributeCol52>(){
            {
                this.add(GuidedDecisionTableModellerViewImplTest.this.attributeColumn());
            }
        };
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.presenter).when((Object)this.view)).getPresenter();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.accordion).when((Object)this.view)).getAccordion();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.attributeConfigWidget).when((Object)this.view)).getAttributeConfigWidget();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)blankSlate).when((Object)this.view)).blankSlate();
        ((GuidedDecisionTableAccordion)Mockito.doReturn((Object)item).when((Object)this.accordion)).getItem(GuidedDecisionTableAccordionItem.Type.ATTRIBUTE);
        this.view.refreshAttributeWidget((List)columns);
        ((VerticalPanel)Mockito.verify((Object)this.attributeConfigWidget)).clear();
        ((VerticalPanel)Mockito.verify((Object)this.attributeConfigWidget, (VerificationMode)Mockito.never())).add((Widget)blankSlate);
        ((GuidedDecisionTableAccordionItem)Mockito.verify((Object)item, (VerificationMode)Mockito.never())).setOpen(Mockito.anyBoolean());
        ((VerticalPanel)Mockito.verify((Object)this.attributeConfigWidget)).add((Widget)Mockito.any(AttributeColumnConfigRowView.class));
    }

    private AttributeCol52 attributeColumn() {
        AttributeCol52 attributeCol52 = (AttributeCol52)Mockito.mock(AttributeCol52.class);
        DTCellValue52 defaultValue = (DTCellValue52)Mockito.mock(DTCellValue52.class);
        ((AttributeCol52)Mockito.doReturn((Object)"salience").when((Object)attributeCol52)).getAttribute();
        ((AttributeCol52)Mockito.doReturn((Object)defaultValue).when((Object)attributeCol52)).getDefaultValue();
        return attributeCol52;
    }

    class GuidedDecisionTableModellerViewImplFake
    extends GuidedDecisionTableModellerViewImpl {
        DefaultGridLayer defaultGridLayer() {
            return GuidedDecisionTableModellerViewImplTest.this.defaultGridLayer;
        }

        RestrictedMousePanMediator restrictedMousePanMediator() {
            return GuidedDecisionTableModellerViewImplTest.this.restrictedMousePanMediator;
        }
    }
}

