/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import org.drools.workbench.models.datamodel.imports.HasImports;
import org.drools.workbench.models.datamodel.oracle.DropDownData;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssueSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.BaseGuidedDecisionTablePresenterTest;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerPresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableColumnSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshActionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshAttributesPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshConditionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.lockmanager.GuidedDecisionTableLockManager;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.themes.GuidedDecisionTableRenderer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.DependentEnumsUtilities;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableLinkManager;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTablePresenterTest
extends BaseGuidedDecisionTablePresenterTest {
    @Captor
    private ArgumentCaptor<Map<String, String>> callbackValueCaptor;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.dtPresenter.onAppendRow();
        this.dtPresenter.onAppendRow();
        this.dtPresenter.onAppendRow();
    }

    @Test
    public void testOnUpdatedLockStatusEvent_LockedByCurrentUser() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        Mockito.when((Object)event.getFile()).thenReturn((Object)this.dtPath);
        Mockito.when((Object)event.isLockedByCurrentUser()).thenReturn((Object)true);
        Mockito.when((Object)event.isLocked()).thenReturn((Object)true);
        this.dtPresenter.onUpdatedLockStatusEvent(event);
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).onLockStatusUpdated((GuidedDecisionTableView.Presenter)Mockito.eq((Object)this.dtPresenter));
        Assert.assertEquals((Object)GuidedDecisionTablePresenter.Access.LockedBy.CURRENT_USER, (Object)this.dtPresenter.getAccess().getLock());
    }

    @Test
    public void testOnUpdatedLockStatusEvent_LockedByOtherUser() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        Mockito.when((Object)event.getFile()).thenReturn((Object)this.dtPath);
        Mockito.when((Object)event.isLockedByCurrentUser()).thenReturn((Object)false);
        Mockito.when((Object)event.isLocked()).thenReturn((Object)true);
        this.dtPresenter.onUpdatedLockStatusEvent(event);
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).onLockStatusUpdated((GuidedDecisionTableView.Presenter)Mockito.eq((Object)this.dtPresenter));
        Assert.assertEquals((Object)GuidedDecisionTablePresenter.Access.LockedBy.OTHER_USER, (Object)this.dtPresenter.getAccess().getLock());
    }

    @Test
    public void testOnUpdatedLockStatusEvent_NotLocked() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        Mockito.when((Object)event.getFile()).thenReturn((Object)this.dtPath);
        this.dtPresenter.onUpdatedLockStatusEvent(event);
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).onLockStatusUpdated((GuidedDecisionTableView.Presenter)Mockito.eq((Object)this.dtPresenter));
        Assert.assertEquals((Object)GuidedDecisionTablePresenter.Access.LockedBy.NOBODY, (Object)this.dtPresenter.getAccess().getLock());
    }

    @Test
    public void testOnUpdatedLockStatusEvent_NullFile() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        this.dtPresenter.onUpdatedLockStatusEvent(event);
    }

    @Test
    public void testOnIssueSelectedEvent_NullEvent() {
        this.dtPresenter.onIssueSelectedEvent(null);
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.never())).clearHighlights();
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.never())).highlightRows((Severity)Mockito.any(Severity.class), (Set)Mockito.any(Set.class));
    }

    @Test
    public void testOnIssueSelectedEvent_ClearHighlightsWithDifferentTable() {
        this.dtPresenter.onIssueSelectedEvent(new IssueSelectedEvent((PlaceRequest)Mockito.mock(PlaceRequest.class), (Issue)Mockito.mock(Issue.class)));
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.times((int)1))).clearHighlights();
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.never())).highlightRows((Severity)Mockito.any(Severity.class), (Set)Mockito.any(Set.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testOnIssueSelectedEvent_HighlightsRows() {
        this.dtPresenter.onIssueSelectedEvent(new IssueSelectedEvent(this.dtPlaceRequest, (Issue)Mockito.mock(Issue.class)));
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.never())).clearHighlights();
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.times((int)1))).highlightRows((Severity)Mockito.any(Severity.class), (Set)Mockito.any(Set.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testActivate() {
        this.dtPresenter.activate();
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).fireChangeTitleEvent();
    }

    @Test
    public void setContent() {
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseContent((ObservablePath)Mockito.eq((Object)this.dtPath), (PlaceRequest)Mockito.eq((Object)this.dtPlaceRequest), (GuidedDecisionTableEditorContent)Mockito.eq((Object)this.dtContent), Mockito.eq((boolean)false));
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory, (VerificationMode)Mockito.times((int)1))).makeAsyncPackageDataModelOracle((Path)Mockito.eq((Object)this.dtPath), (HasImports)Mockito.any(GuidedDecisionTable52.class), (PackageDataModelOracleBaselinePayload)Mockito.any(PackageDataModelOracleBaselinePayload.class));
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).makeUiModel();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).makeView((Set)Mockito.any(Set.class));
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseLockManager();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseUtilities();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseModels();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseValidationAndVerification();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseAuditLog();
        Assert.assertEquals((double)24.0, (double)this.dtPresenter.getUiModel().getRow(0).getHeight(), (double)0.0);
        Assert.assertEquals((double)24.0, (double)this.dtPresenter.getUiModel().getRow(1).getHeight(), (double)0.0);
        Assert.assertEquals((double)24.0, (double)this.dtPresenter.getUiModel().getRow(2).getHeight(), (double)0.0);
        Assert.assertEquals((long)this.dtContent.getModel().hashCode(), (long)this.dtPresenter.getOriginalHashCode().intValue());
    }

    @Test
    public void refreshContent() {
        this.dtPresenter.refreshContent(this.dtPath, this.dtPlaceRequest, this.dtContent, false);
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseContent((ObservablePath)Mockito.eq((Object)this.dtPath), (PlaceRequest)Mockito.eq((Object)this.dtPlaceRequest), (GuidedDecisionTableEditorContent)Mockito.eq((Object)this.dtContent), Mockito.eq((boolean)false));
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory, (VerificationMode)Mockito.times((int)2))).makeAsyncPackageDataModelOracle((Path)Mockito.eq((Object)this.dtPath), (HasImports)Mockito.any(GuidedDecisionTable52.class), (PackageDataModelOracleBaselinePayload)Mockito.any(PackageDataModelOracleBaselinePayload.class));
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).makeUiModel();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).makeView((Set)Mockito.any(Set.class));
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseLockManager();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseUtilities();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseModels();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseValidationAndVerification();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseAuditLog();
        Assert.assertEquals((long)this.dtContent.getModel().hashCode(), (long)this.dtPresenter.getOriginalHashCode().intValue());
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).terminateAnalysis();
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).releaseLock();
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory, (VerificationMode)Mockito.times((int)1))).destroy((AsyncPackageDataModelOracle)Mockito.eq((Object)this.oracle));
    }

    @Test
    public void link() {
        GuidedDecisionTable52 model1 = new GuidedDecisionTable52();
        GuidedDecisionTable52 model2 = new GuidedDecisionTable52();
        GuidedDecisionTable52 model3 = new GuidedDecisionTable52();
        final GuidedDecisionTableView.Presenter dtPresenter2 = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        final GuidedDecisionTableView.Presenter dtPresenter3 = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        HashSet<GuidedDecisionTableView.Presenter> dtPresenters = new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(GuidedDecisionTablePresenterTest.this.dtPresenter);
                this.add(dtPresenter2);
                this.add(dtPresenter3);
            }
        };
        Mockito.when((Object)this.dtPresenter.getModel()).thenReturn((Object)model1);
        Mockito.when((Object)dtPresenter2.getModel()).thenReturn((Object)model2);
        Mockito.when((Object)dtPresenter3.getModel()).thenReturn((Object)model3);
        this.dtPresenter.link((Set)dtPresenters);
        ((GuidedDecisionTableLinkManager)Mockito.verify((Object)this.linkManager, (VerificationMode)Mockito.times((int)1))).link((GuidedDecisionTable52)Mockito.eq((Object)model1), (GuidedDecisionTable52)Mockito.eq((Object)model2), (GuidedDecisionTableLinkManager.LinkFoundCallback)Mockito.any(GuidedDecisionTableLinkManager.LinkFoundCallback.class));
        ((GuidedDecisionTableLinkManager)Mockito.verify((Object)this.linkManager, (VerificationMode)Mockito.times((int)1))).link((GuidedDecisionTable52)Mockito.eq((Object)model1), (GuidedDecisionTable52)Mockito.eq((Object)model3), (GuidedDecisionTableLinkManager.LinkFoundCallback)Mockito.any(GuidedDecisionTableLinkManager.LinkFoundCallback.class));
    }

    @Test
    public void linkMultipleRelatedTables() {
        GuidedDecisionTable52 model1 = new GuidedDecisionTable52();
        GuidedDecisionTable52 model2 = new GuidedDecisionTable52();
        GuidedDecisionTable52 model3 = new GuidedDecisionTable52();
        GridData uiModel1 = (GridData)Mockito.spy((Object)new BaseGridData());
        GridData uiModel2 = (GridData)Mockito.spy((Object)new BaseGridData());
        GridData uiModel3 = (GridData)Mockito.spy((Object)new BaseGridData());
        List uiModel1Columns = (List)Mockito.mock(List.class);
        List uiModel2Columns = (List)Mockito.mock(List.class);
        List uiModel3Columns = (List)Mockito.mock(List.class);
        GridColumn uiModel1MockColumn = (GridColumn)Mockito.mock(GridColumn.class);
        GridColumn uiModel2MockColumn = (GridColumn)Mockito.mock(GridColumn.class);
        GridColumn uiModel3MockColumn = (GridColumn)Mockito.mock(GridColumn.class);
        GuidedDecisionTableView dtView2 = (GuidedDecisionTableView)Mockito.mock(GuidedDecisionTableView.class);
        GuidedDecisionTableView dtView3 = (GuidedDecisionTableView)Mockito.mock(GuidedDecisionTableView.class);
        final GuidedDecisionTableView.Presenter dtPresenter2 = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        final GuidedDecisionTableView.Presenter dtPresenter3 = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        HashSet<GuidedDecisionTableView.Presenter> dtPresenters = new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(GuidedDecisionTablePresenterTest.this.dtPresenter);
                this.add(dtPresenter2);
                this.add(dtPresenter3);
            }
        };
        this.addActionInsertFactToModel(model1, "Applicant", "name");
        this.addConstraintToModel(model2, "Applicant", "name");
        this.addConstraintToModel(model3, "Applicant", "name");
        Mockito.when((Object)this.dtPresenter.getModel()).thenReturn((Object)model1);
        Mockito.when((Object)dtPresenter2.getModel()).thenReturn((Object)model2);
        Mockito.when((Object)dtPresenter3.getModel()).thenReturn((Object)model3);
        Mockito.when((Object)dtPresenter2.getView()).thenReturn((Object)dtView2);
        Mockito.when((Object)dtPresenter3.getView()).thenReturn((Object)dtView3);
        Mockito.when((Object)this.view.getModel()).thenReturn((Object)uiModel1);
        Mockito.when((Object)dtView2.getModel()).thenReturn((Object)uiModel2);
        Mockito.when((Object)dtView3.getModel()).thenReturn((Object)uiModel3);
        Mockito.when((Object)uiModel1.getColumns()).thenReturn((Object)uiModel1Columns);
        Mockito.when((Object)uiModel2.getColumns()).thenReturn((Object)uiModel2Columns);
        Mockito.when((Object)uiModel3.getColumns()).thenReturn((Object)uiModel3Columns);
        Mockito.when(uiModel1Columns.get(Mockito.anyInt())).thenReturn((Object)uiModel1MockColumn);
        Mockito.when(uiModel2Columns.get(Mockito.anyInt())).thenReturn((Object)uiModel2MockColumn);
        Mockito.when(uiModel3Columns.get(Mockito.anyInt())).thenReturn((Object)uiModel3MockColumn);
        this.dtPresenter.link((Set)dtPresenters);
        ((List)Mockito.verify((Object)uiModel1Columns, (VerificationMode)Mockito.atLeast((int)1))).get(Mockito.eq((int)2));
        ((List)Mockito.verify((Object)uiModel2Columns, (VerificationMode)Mockito.atLeast((int)1))).get(Mockito.eq((int)2));
        ((List)Mockito.verify((Object)uiModel3Columns, (VerificationMode)Mockito.atLeast((int)1))).get(Mockito.eq((int)2));
        ((GridColumn)Mockito.verify((Object)uiModel2MockColumn)).setLink((GridColumn)Mockito.eq((Object)uiModel1MockColumn));
        ((GridColumn)Mockito.verify((Object)uiModel3MockColumn)).setLink((GridColumn)Mockito.eq((Object)uiModel1MockColumn));
    }

    private void addConstraintToModel(GuidedDecisionTable52 model, String factType, String fieldName) {
        Pattern52 p = new Pattern52();
        p.setFactType(factType);
        ConditionCol52 c = new ConditionCol52();
        c.setOperator("==");
        c.setFactField(fieldName);
        c.setFieldType("String");
        p.getChildColumns().add(c);
        model.getConditions().add(p);
    }

    private void addActionInsertFactToModel(GuidedDecisionTable52 model, String factType, String fieldName) {
        ActionInsertFactCol52 aif = new ActionInsertFactCol52();
        aif.setFactType(factType);
        aif.setFactField(fieldName);
        model.getActionCols().add(aif);
    }

    @Test
    public void onClose() {
        Mockito.reset((Object[])new Object[]{this.dtPresenter, this.lockManager});
        this.dtPresenter.onClose();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).terminateAnalysis();
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).releaseLock();
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory, (VerificationMode)Mockito.times((int)1))).destroy((AsyncPackageDataModelOracle)Mockito.eq((Object)this.oracle));
    }

    @Test
    public void select() {
        this.dtPresenter.select((GridWidget)this.dtPresenter.getView());
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(DecisionTableSelectedEvent.class));
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).acquireLock();
    }

    @Test
    public void selectLinkedColumn() {
        GridColumn uiColumn = (GridColumn)Mockito.mock(GridColumn.class);
        this.dtPresenter.selectLinkedColumn(uiColumn);
        ((Event)Mockito.verify((Object)this.decisionTableColumnSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(DecisionTableColumnSelectedEvent.class));
    }

    @Test
    public void getPackageParentRuleNames() {
        HashSet<String> parentRuleNames = new HashSet<String>();
        parentRuleNames.add("parentRule1");
        parentRuleNames.add("parentRule2");
        ParameterizedCommand parentRuleNamesCommand = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        Mockito.when((Object)this.ruleNameService.getRuleNames((Path)Mockito.any(ObservablePath.class), (String)Mockito.any(String.class))).thenReturn(parentRuleNames);
        this.dtPresenter.getPackageParentRuleNames(parentRuleNamesCommand);
        ((ParameterizedCommand)Mockito.verify((Object)parentRuleNamesCommand, (VerificationMode)Mockito.times((int)1))).execute(Mockito.eq(parentRuleNames));
    }

    @Test
    public void hasColumnDefinitionsEmptyModel() {
        Assert.assertFalse((boolean)this.dtPresenter.hasColumnDefinitions());
    }

    @Test
    public void hasColumnDefinitionsWithAttributeColumn() {
        AttributeCol52 attribute = new AttributeCol52();
        attribute.setAttribute("attribute");
        this.dtPresenter.getModel().getAttributeCols().add(attribute);
        Assert.assertTrue((boolean)this.dtPresenter.hasColumnDefinitions());
    }

    @Test
    public void hasColumnDefinitionsWithConditionColumn() {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType");
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        pattern.getChildColumns().add(condition);
        this.dtPresenter.getModel().getConditions().add(pattern);
        Assert.assertTrue((boolean)this.dtPresenter.hasColumnDefinitions());
    }

    @Test
    public void hasColumnDefinitionsWithActionColumn() {
        ActionInsertFactCol52 action = new ActionInsertFactCol52();
        action.setFactType("FactType");
        action.setFactField("field");
        this.dtPresenter.getModel().getActionCols().add(action);
        Assert.assertTrue((boolean)this.dtPresenter.hasColumnDefinitions());
    }

    @Test
    public void getBindingsWithSimpleClassName() {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setFactType("FactType1");
        pattern1.setBoundName("$fact1");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setFactField("field");
        condition1.setBinding("$field1");
        pattern1.getChildColumns().add(condition1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setFactType("FactType1");
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setFactField("field");
        pattern2.getChildColumns().add(condition2);
        Mockito.when((Object)this.oracle.getFieldClassName((String)Mockito.eq((Object)"FactType1"), (String)Mockito.eq((Object)"field"))).thenReturn((Object)"FactType1");
        this.dtPresenter.getModel().getConditions().add(pattern1);
        this.dtPresenter.getModel().getConditions().add(pattern2);
        Set bindings = this.dtPresenter.getBindings("FactType1");
        Assert.assertNotNull((Object)bindings);
        Assert.assertEquals((long)2L, (long)bindings.size());
        Assert.assertTrue((boolean)bindings.contains("$fact1"));
        Assert.assertTrue((boolean)bindings.contains("$field1"));
    }

    @Test
    public void getBindingsWithFullyQualifiedClassName() {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setFactType("FactType1");
        pattern1.setBoundName("$fact1");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setFactField("field");
        condition1.setBinding("$field1");
        pattern1.getChildColumns().add(condition1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setFactType("FactType1");
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setFactField("field");
        pattern2.getChildColumns().add(condition2);
        Mockito.when((Object)this.oracle.getFieldClassName((String)Mockito.eq((Object)"FactType1"), (String)Mockito.eq((Object)"field"))).thenReturn((Object)"FactType1");
        this.dtPresenter.getModel().getConditions().add(pattern1);
        this.dtPresenter.getModel().getConditions().add(pattern2);
        Set bindings = this.dtPresenter.getBindings("org.drools.workbench.screens.guided.dtable.client.widget.table.FactType1");
        Assert.assertNotNull((Object)bindings);
        Assert.assertEquals((long)1L, (long)bindings.size());
        Assert.assertTrue((boolean)bindings.contains("$fact1"));
    }

    @Test
    public void canConditionBeDeletedWithSingleChildColumnWithAction() {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType1");
        pattern.setBoundName("$fact");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setFactField("field1");
        pattern.getChildColumns().add(condition1);
        this.dtPresenter.getModel().getConditions().add(pattern);
        ActionInsertFactCol52 action = new ActionInsertFactCol52();
        action.setFactType("FactType1");
        action.setBoundName("$fact");
        action.setFactField("field");
        this.dtPresenter.getModel().getActionCols().add(action);
        Assert.assertFalse((boolean)this.dtPresenter.canConditionBeDeleted(condition1));
    }

    @Test
    public void canConditionBeDeletedWithSingleChildColumnWithNoAction() {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType1");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setFactField("field1");
        pattern.getChildColumns().add(condition1);
        this.dtPresenter.getModel().getConditions().add(pattern);
        Assert.assertTrue((boolean)this.dtPresenter.canConditionBeDeleted(condition1));
    }

    @Test
    public void canConditionBeDeletedWithMultipleChildColumns() {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType1");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setFactField("field1");
        pattern.getChildColumns().add(condition1);
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setFactField("field2");
        pattern.getChildColumns().add(condition2);
        this.dtPresenter.getModel().getConditions().add(pattern);
        Assert.assertTrue((boolean)this.dtPresenter.canConditionBeDeleted(condition1));
    }

    @Test
    public void canBRLFragmentConditionBeDeletedWithAction() {
        FactPattern fp = new FactPattern("FactType1");
        fp.setBoundName("$fact");
        BRLConditionColumn column = new BRLConditionColumn();
        column.getDefinition().add(fp);
        this.dtPresenter.getModel().getConditions().add(column);
        ActionInsertFactCol52 action = new ActionInsertFactCol52();
        action.setFactType("FactType1");
        action.setBoundName("$fact");
        action.setFactField("field");
        this.dtPresenter.getModel().getActionCols().add(action);
        Assert.assertFalse((boolean)this.dtPresenter.canConditionBeDeleted(column));
    }

    @Test
    public void canBRLFragmentConditionBeDeletedWithNoAction() {
        FactPattern fp = new FactPattern("FactType1");
        fp.setBoundName("$fact");
        BRLConditionColumn column = new BRLConditionColumn();
        column.getDefinition().add(fp);
        this.dtPresenter.getModel().getConditions().add(column);
        Assert.assertTrue((boolean)this.dtPresenter.canConditionBeDeleted(column));
    }

    @Test
    public void getValueListLookups() {
        AttributeCol52 attribute = new AttributeCol52();
        attribute.setAttribute("enabled");
        Map valueList = this.dtPresenter.getValueListLookups((BaseColumn)attribute);
        Assert.assertNotNull((Object)valueList);
        Assert.assertEquals((long)2L, (long)valueList.size());
        Assert.assertTrue((boolean)valueList.containsKey("true"));
        Assert.assertTrue((boolean)valueList.containsKey("false"));
    }

    @Test
    public void getEnumLookupsWithNoEnumsDefined() {
        DependentEnumsUtilities.Context context = (DependentEnumsUtilities.Context)Mockito.mock(DependentEnumsUtilities.Context.class);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.dtPresenter.getEnumLookups("FactType", "field", context, callback);
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(this.callbackValueCaptor.capture());
        Map callbackValue = (Map)this.callbackValueCaptor.getValue();
        Assert.assertNotNull((Object)callbackValue);
        Assert.assertTrue((boolean)callbackValue.isEmpty());
    }

    @Test
    public void getEnumLookupsWithFixedListDefinition() {
        DependentEnumsUtilities.Context context = (DependentEnumsUtilities.Context)Mockito.mock(DependentEnumsUtilities.Context.class);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        DropDownData dd = DropDownData.create((String[])new String[]{"one", "two"});
        Mockito.when((Object)this.oracle.getEnums((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"), (Map)Mockito.any(Map.class))).thenReturn((Object)dd);
        this.dtPresenter.getEnumLookups("FactType", "field", context, callback);
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(this.callbackValueCaptor.capture());
        Map callbackValue = (Map)this.callbackValueCaptor.getValue();
        Assert.assertNotNull((Object)callbackValue);
        Assert.assertFalse((boolean)callbackValue.isEmpty());
        Assert.assertTrue((boolean)callbackValue.containsKey("one"));
        Assert.assertTrue((boolean)callbackValue.containsKey("two"));
    }

    @Test
    public void getEnumLookupsWithFixedListDefinitionWithSplitter() {
        DependentEnumsUtilities.Context context = (DependentEnumsUtilities.Context)Mockito.mock(DependentEnumsUtilities.Context.class);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        DropDownData dd = DropDownData.create((String[])new String[]{"1=one", "2=two"});
        Mockito.when((Object)this.oracle.getEnums((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"), (Map)Mockito.any(Map.class))).thenReturn((Object)dd);
        this.dtPresenter.getEnumLookups("FactType", "field", context, callback);
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(this.callbackValueCaptor.capture());
        Map callbackValue = (Map)this.callbackValueCaptor.getValue();
        Assert.assertNotNull((Object)callbackValue);
        Assert.assertFalse((boolean)callbackValue.isEmpty());
        Assert.assertTrue((boolean)callbackValue.containsKey("1"));
        Assert.assertTrue((boolean)callbackValue.containsKey("2"));
        Assert.assertEquals((Object)"one", callbackValue.get("1"));
        Assert.assertEquals((Object)"two", callbackValue.get("2"));
    }

    @Test
    public void getEnumLookupsWithQueryExpressionDefinition() {
        DependentEnumsUtilities.Context context = (DependentEnumsUtilities.Context)Mockito.mock(DependentEnumsUtilities.Context.class);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        DropDownData dd = DropDownData.create((String)"query", (String[])new String[]{"one", "two"});
        Mockito.when((Object)this.oracle.getEnums((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"), (Map)Mockito.any(Map.class))).thenReturn((Object)dd);
        Mockito.when((Object)this.enumDropdownService.loadDropDownExpression((Path)Mockito.any(Path.class), (String[])Mockito.any(String[].class), (String)Mockito.any(String.class))).thenReturn((Object)new String[]{"three", "four"});
        this.dtPresenter.getEnumLookups("FactType", "field", context, callback);
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(this.callbackValueCaptor.capture());
        Map callbackValue = (Map)this.callbackValueCaptor.getValue();
        Assert.assertNotNull((Object)callbackValue);
        Assert.assertFalse((boolean)callbackValue.isEmpty());
        Assert.assertTrue((boolean)callbackValue.containsKey("three"));
        Assert.assertTrue((boolean)callbackValue.containsKey("four"));
    }

    @Test
    public void newConditionColumn() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        this.dtPresenter.newConditionColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newExtendedEntryConditionColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newLimitedEntryConditionColumn();
    }

    @Test
    public void newLimitedEntryConditionColumn() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        this.dtPresenter.newConditionColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newExtendedEntryConditionColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newLimitedEntryConditionColumn();
    }

    @Test
    public void newConditionBRLFragment() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        this.dtPresenter.newConditionBRLFragment();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newExtendedEntryConditionBRLFragment();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newLimitedEntryConditionBRLFragment();
    }

    @Test
    public void newLimitedEntryConditionBRLFragment() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        this.dtPresenter.newConditionBRLFragment();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newExtendedEntryConditionBRLFragment();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newLimitedEntryConditionBRLFragment();
    }

    @Test
    public void newActionInsertColumn() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        this.dtPresenter.newActionInsertColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newExtendedEntryActionInsertColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newLimitedEntryActionInsertColumn();
    }

    @Test
    public void newLimitedEntryActionInsertColumn() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        this.dtPresenter.newActionInsertColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newExtendedEntryActionInsertColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newLimitedEntryActionInsertColumn();
    }

    @Test
    public void newActionSetColumn() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        this.dtPresenter.newActionSetColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newExtendedEntryActionSetColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newLimitedEntryActionSetColumn();
    }

    @Test
    public void newLimitedEntryActionSetColumn() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        this.dtPresenter.newActionSetColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newExtendedEntryActionSetColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newLimitedEntryActionSetColumn();
    }

    @Test
    public void newActionRetractFact() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        this.dtPresenter.newActionRetractFact();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newExtendedEntryActionRetractFact();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newLimitedEntryActionRetractFact();
    }

    @Test
    public void newLimitedEntryActionRetractFact() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        this.dtPresenter.newActionRetractFact();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newExtendedEntryActionRetractFact();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newLimitedEntryActionRetractFact();
    }

    @Test
    public void newActionWorkItem() {
        this.dtPresenter.newActionWorkItem();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newActionWorkItem();
    }

    @Test
    public void newActionWorkItemSetField() {
        this.dtPresenter.newActionWorkItemSetField();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newActionWorkItemSetField();
    }

    @Test
    public void newActionWorkItemInsertFact() {
        this.dtPresenter.newActionWorkItemInsertFact();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newActionWorkItemInsertFact();
    }

    @Test
    public void newActionBRLFragment() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        this.dtPresenter.newActionBRLFragment();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newExtendedEntryActionBRLFragment();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newLimitedEntryActionBRLFragment();
    }

    @Test
    public void newLimitedEntryActionBRLFragment() {
        this.dtPresenter.getModel().setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        this.dtPresenter.newActionBRLFragment();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).newExtendedEntryActionBRLFragment();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newLimitedEntryActionBRLFragment();
    }

    @Test
    public void editConditionWithPatternAndCondition() {
        this.dtPresenter.editCondition((Pattern52)Mockito.mock(Pattern52.class), (ConditionCol52)Mockito.mock(ConditionCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editCondition((Pattern52)Mockito.any(Pattern52.class), (ConditionCol52)Mockito.any(ConditionCol52.class));
    }

    @Test
    public void editConditionWithBRLCondition() {
        this.dtPresenter.editCondition((BRLConditionColumn)Mockito.mock(BRLConditionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editExtendedEntryConditionBRLFragment((BRLConditionColumn)Mockito.any(BRLConditionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editLimitedEntryConditionBRLFragment((LimitedEntryBRLConditionColumn)Mockito.any(LimitedEntryBRLConditionColumn.class));
    }

    @Test
    public void editLimitedEntryConditionWithBRLCondition() {
        this.dtPresenter.editCondition((BRLConditionColumn)Mockito.mock(LimitedEntryBRLConditionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editExtendedEntryConditionBRLFragment((BRLConditionColumn)Mockito.any(BRLConditionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editLimitedEntryConditionBRLFragment((LimitedEntryBRLConditionColumn)Mockito.any(LimitedEntryBRLConditionColumn.class));
    }

    @Test
    public void editActionWorkItemSetFieldColumn() {
        this.dtPresenter.editAction((ActionCol52)Mockito.mock(ActionWorkItemSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editActionWorkItemSetField((ActionWorkItemSetFieldCol52)Mockito.any(ActionWorkItemSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionSetField((ActionSetFieldCol52)Mockito.any(ActionSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemInsertFact((ActionWorkItemInsertFactCol52)Mockito.any(ActionWorkItemInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionInsertFact((ActionInsertFactCol52)Mockito.any(ActionInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionRetractFact((ActionRetractFactCol52)Mockito.any(ActionRetractFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItem((ActionWorkItemCol52)Mockito.any(ActionWorkItemCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editLimitedEntryActionBRLFragment((LimitedEntryBRLActionColumn)Mockito.any(LimitedEntryBRLActionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editExtendedEntryActionBRLFragment((BRLActionColumn)Mockito.any(BRLActionColumn.class));
    }

    @Test
    public void editActionSetFieldColumn() {
        this.dtPresenter.editAction((ActionCol52)Mockito.mock(ActionSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemSetField((ActionWorkItemSetFieldCol52)Mockito.any(ActionWorkItemSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editActionSetField((ActionSetFieldCol52)Mockito.any(ActionSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemInsertFact((ActionWorkItemInsertFactCol52)Mockito.any(ActionWorkItemInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionInsertFact((ActionInsertFactCol52)Mockito.any(ActionInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionRetractFact((ActionRetractFactCol52)Mockito.any(ActionRetractFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItem((ActionWorkItemCol52)Mockito.any(ActionWorkItemCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editLimitedEntryActionBRLFragment((LimitedEntryBRLActionColumn)Mockito.any(LimitedEntryBRLActionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editExtendedEntryActionBRLFragment((BRLActionColumn)Mockito.any(BRLActionColumn.class));
    }

    @Test
    public void editActionWorkItemInsertFactColumn() {
        this.dtPresenter.editAction((ActionCol52)Mockito.mock(ActionWorkItemInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemSetField((ActionWorkItemSetFieldCol52)Mockito.any(ActionWorkItemSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionSetField((ActionSetFieldCol52)Mockito.any(ActionSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editActionWorkItemInsertFact((ActionWorkItemInsertFactCol52)Mockito.any(ActionWorkItemInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionInsertFact((ActionInsertFactCol52)Mockito.any(ActionInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionRetractFact((ActionRetractFactCol52)Mockito.any(ActionRetractFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItem((ActionWorkItemCol52)Mockito.any(ActionWorkItemCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editLimitedEntryActionBRLFragment((LimitedEntryBRLActionColumn)Mockito.any(LimitedEntryBRLActionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editExtendedEntryActionBRLFragment((BRLActionColumn)Mockito.any(BRLActionColumn.class));
    }

    @Test
    public void editActionInsertFactColumn() {
        this.dtPresenter.editAction((ActionCol52)Mockito.mock(ActionInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemSetField((ActionWorkItemSetFieldCol52)Mockito.any(ActionWorkItemSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionSetField((ActionSetFieldCol52)Mockito.any(ActionSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemInsertFact((ActionWorkItemInsertFactCol52)Mockito.any(ActionWorkItemInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editActionInsertFact((ActionInsertFactCol52)Mockito.any(ActionInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionRetractFact((ActionRetractFactCol52)Mockito.any(ActionRetractFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItem((ActionWorkItemCol52)Mockito.any(ActionWorkItemCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editLimitedEntryActionBRLFragment((LimitedEntryBRLActionColumn)Mockito.any(LimitedEntryBRLActionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editExtendedEntryActionBRLFragment((BRLActionColumn)Mockito.any(BRLActionColumn.class));
    }

    @Test
    public void editActionRetractFactColumn() {
        this.dtPresenter.editAction((ActionCol52)Mockito.mock(ActionRetractFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemSetField((ActionWorkItemSetFieldCol52)Mockito.any(ActionWorkItemSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionSetField((ActionSetFieldCol52)Mockito.any(ActionSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemInsertFact((ActionWorkItemInsertFactCol52)Mockito.any(ActionWorkItemInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionInsertFact((ActionInsertFactCol52)Mockito.any(ActionInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editActionRetractFact((ActionRetractFactCol52)Mockito.any(ActionRetractFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItem((ActionWorkItemCol52)Mockito.any(ActionWorkItemCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editLimitedEntryActionBRLFragment((LimitedEntryBRLActionColumn)Mockito.any(LimitedEntryBRLActionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editExtendedEntryActionBRLFragment((BRLActionColumn)Mockito.any(BRLActionColumn.class));
    }

    @Test
    public void editActionWorkItemColumn() {
        this.dtPresenter.editAction((ActionCol52)Mockito.mock(ActionWorkItemCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemSetField((ActionWorkItemSetFieldCol52)Mockito.any(ActionWorkItemSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionSetField((ActionSetFieldCol52)Mockito.any(ActionSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemInsertFact((ActionWorkItemInsertFactCol52)Mockito.any(ActionWorkItemInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionInsertFact((ActionInsertFactCol52)Mockito.any(ActionInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionRetractFact((ActionRetractFactCol52)Mockito.any(ActionRetractFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editActionWorkItem((ActionWorkItemCol52)Mockito.any(ActionWorkItemCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editLimitedEntryActionBRLFragment((LimitedEntryBRLActionColumn)Mockito.any(LimitedEntryBRLActionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editExtendedEntryActionBRLFragment((BRLActionColumn)Mockito.any(BRLActionColumn.class));
    }

    @Test
    public void editLimitedEntryBRLActionColumn() {
        this.dtPresenter.editAction((ActionCol52)Mockito.mock(LimitedEntryBRLActionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemSetField((ActionWorkItemSetFieldCol52)Mockito.any(ActionWorkItemSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionSetField((ActionSetFieldCol52)Mockito.any(ActionSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemInsertFact((ActionWorkItemInsertFactCol52)Mockito.any(ActionWorkItemInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionInsertFact((ActionInsertFactCol52)Mockito.any(ActionInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionRetractFact((ActionRetractFactCol52)Mockito.any(ActionRetractFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItem((ActionWorkItemCol52)Mockito.any(ActionWorkItemCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editLimitedEntryActionBRLFragment((LimitedEntryBRLActionColumn)Mockito.any(LimitedEntryBRLActionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editExtendedEntryActionBRLFragment((BRLActionColumn)Mockito.any(BRLActionColumn.class));
    }

    @Test
    public void editBRLActionColumn() {
        this.dtPresenter.editAction((ActionCol52)Mockito.mock(BRLActionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemSetField((ActionWorkItemSetFieldCol52)Mockito.any(ActionWorkItemSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionSetField((ActionSetFieldCol52)Mockito.any(ActionSetFieldCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItemInsertFact((ActionWorkItemInsertFactCol52)Mockito.any(ActionWorkItemInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionInsertFact((ActionInsertFactCol52)Mockito.any(ActionInsertFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionRetractFact((ActionRetractFactCol52)Mockito.any(ActionRetractFactCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editActionWorkItem((ActionWorkItemCol52)Mockito.any(ActionWorkItemCol52.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).editLimitedEntryActionBRLFragment((LimitedEntryBRLActionColumn)Mockito.any(LimitedEntryBRLActionColumn.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editExtendedEntryActionBRLFragment((BRLActionColumn)Mockito.any(BRLActionColumn.class));
    }

    @Test
    public void appendPatternAndConditionColumn() throws ModelSynchronizer.MoveColumnVetoException {
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType");
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        condition.setHeader("header");
        this.dtPresenter.appendColumn(pattern, condition);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendColumn((Pattern52)Mockito.eq((Object)pattern), (ConditionCol52)Mockito.eq((Object)condition));
        ((Event)Mockito.verify((Object)this.refreshConditionsPanelEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RefreshConditionsPanelEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void appendConditionColumn() throws ModelSynchronizer.MoveColumnVetoException {
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        condition.setHeader("header");
        this.dtPresenter.appendColumn(condition);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendColumn((BaseColumn)Mockito.eq((Object)condition));
        ((Event)Mockito.verify((Object)this.refreshConditionsPanelEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RefreshConditionsPanelEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void appendActionColumn() throws ModelSynchronizer.MoveColumnVetoException {
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        ActionInsertFactCol52 action = new ActionInsertFactCol52();
        action.setFactType("FactType");
        action.setFactField("field");
        action.setHeader("header");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"))).thenReturn((Object)"String");
        this.dtPresenter.appendColumn((ActionCol52)action);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendColumn((BaseColumn)Mockito.eq((Object)action));
        ((Event)Mockito.verify((Object)this.refreshActionsPanelEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RefreshActionsPanelEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void appendRow() throws ModelSynchronizer.MoveColumnVetoException {
        Mockito.reset((Object[])new Object[]{this.synchronizer, this.modellerPresenter});
        this.dtPresenter.onAppendRow();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendRow();
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void deleteConditionColumn() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType");
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        condition.setHeader("header");
        this.dtPresenter.appendColumn(pattern, condition);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        this.dtPresenter.deleteColumn(condition);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)condition));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void deleteActionColumn() throws ModelSynchronizer.MoveColumnVetoException {
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        column.setFactType("FactType");
        column.setFactField("field");
        column.setHeader("header");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"))).thenReturn((Object)"String");
        this.dtPresenter.appendColumn((ActionCol52)column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        this.dtPresenter.deleteColumn((ActionCol52)column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)column));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void deleteAttributeColumn() throws Exception {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute("salience");
        this.dtPresenter.appendColumn(column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        this.dtPresenter.deleteColumn(column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)column));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
        ((Event)Mockito.verify((Object)this.refreshAttributesPanelEvent, (VerificationMode)Mockito.times((int)2))).fire(Mockito.any(RefreshAttributesPanelEvent.class));
    }

    @Test
    public void updatePatternAndConditionColumn() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType");
        pattern.setBoundName("$f");
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        condition.setHeader("header");
        this.dtPresenter.appendColumn(pattern, condition);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        Pattern52 updatePattern = new Pattern52();
        updatePattern.setFactType("NewType");
        updatePattern.setBoundName("$f");
        ConditionCol52 updateCondition = new ConditionCol52();
        updateCondition.setFactField("newField");
        updateCondition.setHeader("newHeader");
        this.dtPresenter.updateColumn(pattern, condition, updatePattern, updateCondition);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).updateColumn((Pattern52)Mockito.eq((Object)pattern), (ConditionCol52)Mockito.eq((Object)condition), (Pattern52)Mockito.eq((Object)updatePattern), (ConditionCol52)Mockito.eq((Object)updateCondition));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void updateConditionColumn() throws ModelSynchronizer.MoveColumnVetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType");
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        condition.setHeader("header");
        this.dtPresenter.appendColumn(pattern, condition);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        ConditionCol52 updateCondition = new ConditionCol52();
        updateCondition.setFactField("newField");
        updateCondition.setHeader("newHeader");
        this.dtPresenter.updateColumn(condition, updateCondition);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).updateColumn((BaseColumn)Mockito.eq((Object)condition), (BaseColumn)Mockito.eq((Object)updateCondition));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void updateActionColumn() throws ModelSynchronizer.MoveColumnVetoException {
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        column.setFactType("FactType");
        column.setFactField("field");
        column.setHeader("header");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"))).thenReturn((Object)"String");
        this.dtPresenter.appendColumn((ActionCol52)column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        ActionInsertFactCol52 update = new ActionInsertFactCol52();
        update.setFactType("NewType");
        update.setFactField("newField");
        update.setHeader("newHeader");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)"NewType"), (String)Mockito.eq((Object)"newField"))).thenReturn((Object)"String");
        this.dtPresenter.updateColumn((ActionCol52)column, (ActionCol52)update);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).updateColumn((BaseColumn)Mockito.eq((Object)column), (BaseColumn)Mockito.eq((Object)update));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void onCutWithSelection() {
        this.dtPresenter.getUiModel().selectCell(0, 0);
        this.dtPresenter.onCut();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.times((int)1))).setData((Set)Mockito.any(Set.class));
    }

    @Test
    public void onCutWithoutSelection() {
        this.dtPresenter.onCut();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.never())).setData((Set)Mockito.any(Set.class));
    }

    @Test
    public void onCopyWithSelection() {
        this.dtPresenter.getUiModel().selectCell(0, 0);
        this.dtPresenter.onCopy();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.times((int)1))).setData((Set)Mockito.any(Set.class));
    }

    @Test
    public void onCopyWithoutSelection() {
        this.dtPresenter.onCopy();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.never())).setData((Set)Mockito.any(Set.class));
    }

    @Test
    public void onPasteWithClipboardDataWithSelection() {
        this.dtPresenter.getUiModel().selectCell(0, 0);
        this.dtPresenter.onCopy();
        this.dtPresenter.getUiModel().selectCell(1, 0);
        this.dtPresenter.onPaste();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.times((int)1))).getData();
    }

    @Test
    public void onPasteWithClipboardDataWithoutSelection() {
        this.dtPresenter.onPaste();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.never())).getData();
    }

    @Test
    public void onDeleteSelectedCellsWithSelection() {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 1);
        ArgumentCaptor columnIndexCaptor = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor rowRangeCaptor = ArgumentCaptor.forClass(GridData.Range.class);
        this.dtPresenter.onDeleteSelectedCells();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteCell((GridData.Range)rowRangeCaptor.capture(), ((Integer)columnIndexCaptor.capture()).intValue());
        Integer columnIndex = (Integer)columnIndexCaptor.getValue();
        GridData.Range rowRange = (GridData.Range)rowRangeCaptor.getValue();
        Assert.assertEquals((long)0L, (long)rowRange.getMinRowIndex());
        Assert.assertEquals((long)0L, (long)rowRange.getMaxRowIndex());
        Assert.assertEquals((long)1L, (long)columnIndex.intValue());
    }

    @Test
    public void onDeleteSelectedCellsWithSelectionWithBooleanColumn() {
        AttributeCol52 column = new AttributeCol52(){
            {
                this.setAttribute("enabled");
            }
        };
        this.dtPresenter.appendColumn(column);
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 2);
        this.dtPresenter.onDeleteSelectedCells();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).deleteCell((GridData.Range)Mockito.any(GridData.Range.class), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onDeleteSelectedCellsWithSelectionsWithBooleanColumn() {
        AttributeCol52 column = new AttributeCol52(){
            {
                this.setAttribute("enabled");
            }
        };
        this.dtPresenter.appendColumn(column);
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 1);
        uiModel.selectCell(0, 2);
        ArgumentCaptor columnIndexCaptor = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor rowRangeCaptor = ArgumentCaptor.forClass(GridData.Range.class);
        this.dtPresenter.onDeleteSelectedCells();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteCell((GridData.Range)rowRangeCaptor.capture(), ((Integer)columnIndexCaptor.capture()).intValue());
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).deleteCell((GridData.Range)Mockito.any(GridData.Range.class), Mockito.eq((int)2));
        GridCell booleanCell = uiModel.getCell(0, 2);
        Assert.assertNotNull((Object)booleanCell);
        Assert.assertFalse((boolean)((Boolean)booleanCell.getValue().getValue()));
        Integer columnIndex = (Integer)columnIndexCaptor.getValue();
        GridData.Range rowRange = (GridData.Range)rowRangeCaptor.getValue();
        Assert.assertEquals((long)0L, (long)rowRange.getMinRowIndex());
        Assert.assertEquals((long)0L, (long)rowRange.getMaxRowIndex());
        Assert.assertEquals((long)1L, (long)columnIndex.intValue());
    }

    @Test
    public void onDeleteSelectedCellsWithoutSelections() {
        this.dtPresenter.onDeleteSelectedCells();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).deleteCell((GridData.Range)Mockito.any(GridData.Range.class), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onDeleteSelectedColumnsWithSelections() throws ModelSynchronizer.MoveColumnVetoException {
        AttributeCol52 column = new AttributeCol52(){
            {
                this.setAttribute("attribute1");
            }
        };
        this.dtPresenter.appendColumn(column);
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 2);
        this.dtPresenter.onDeleteSelectedColumns();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)column));
    }

    @Test
    public void onDeleteSelectedColumnsWithoutSelections() throws ModelSynchronizer.MoveColumnVetoException {
        this.dtPresenter.onDeleteSelectedColumns();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).deleteColumn((BaseColumn)Mockito.any(BaseColumn.class));
    }

    @Test
    public void onDeleteSelectedRowsWithSelections() throws ModelSynchronizer.MoveColumnVetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        uiModel.selectCell(2, 0);
        this.dtPresenter.onDeleteSelectedRows();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteRow(Mockito.eq((int)0));
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteRow(Mockito.eq((int)1));
    }

    @Test
    public void onDeleteSelectedRowsWithNoSelections() throws ModelSynchronizer.MoveColumnVetoException {
        this.dtPresenter.onDeleteSelectedRows();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).deleteRow(((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onInsertRowAboveNoRowSelected() throws ModelSynchronizer.MoveColumnVetoException {
        this.dtPresenter.onInsertRowAbove();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).insertRow(((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onInsertRowAboveSingleRowSelected() throws ModelSynchronizer.MoveColumnVetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        this.dtPresenter.onInsertRowAbove();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).insertRow(Mockito.eq((int)0));
    }

    @Test
    public void onInsertRowAboveMultipleRowsSelected() throws ModelSynchronizer.MoveColumnVetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        uiModel.selectCell(1, 0);
        this.dtPresenter.onInsertRowAbove();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).insertRow(((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onInsertRowBelowNoRowSelected() throws ModelSynchronizer.MoveColumnVetoException {
        this.dtPresenter.onInsertRowBelow();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).insertRow(((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onInsertRowBelowSingleRowSelected() throws ModelSynchronizer.MoveColumnVetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        this.dtPresenter.onInsertRowBelow();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).insertRow(Mockito.eq((int)1));
    }

    @Test
    public void onInsertRowBelowMultipleRowsSelected() throws ModelSynchronizer.MoveColumnVetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        uiModel.selectCell(1, 0);
        this.dtPresenter.onInsertRowBelow();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).insertRow(((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onOtherwiseCellNoCellSelected() throws ModelSynchronizer.MoveColumnVetoException {
        this.dtPresenter.onOtherwiseCell();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).setCellOtherwiseState(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onOtherwiseCellSingleCellSelected() throws ModelSynchronizer.MoveColumnVetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        this.dtPresenter.onOtherwiseCell();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).setCellOtherwiseState(Mockito.eq((int)0), Mockito.eq((int)0));
    }

    @Test
    public void onOtherwiseCellMultipleCellsSelected() throws ModelSynchronizer.MoveColumnVetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        uiModel.selectCell(1, 0);
        this.dtPresenter.onOtherwiseCell();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).setCellOtherwiseState(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void setMergedTrue() {
        Mockito.reset((Object[])new DefaultGridLayer[]{this.gridLayer});
        this.dtPresenter.setMerged(true);
        Assert.assertTrue((boolean)this.dtPresenter.isMerged());
        ((DefaultGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void setMergedFalse() {
        Mockito.reset((Object[])new DefaultGridLayer[]{this.gridLayer});
        this.dtPresenter.setMerged(false);
        Assert.assertFalse((boolean)this.dtPresenter.isMerged());
        ((DefaultGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).draw();
    }
}

