/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.accordion;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.guided.dtable.client.widget.table.accordion.GuidedDecisionTableAccordionItem;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTableAccordionItemTest {
    @Mock
    private GuidedDecisionTableAccordionItem.View view;
    @Mock
    private TranslationService translationService;
    private GuidedDecisionTableAccordionItem item;

    @Before
    public void setup() throws Exception {
        this.item = (GuidedDecisionTableAccordionItem)Mockito.spy((Object)new GuidedDecisionTableAccordionItem(this.view, this.translationService));
    }

    @Test
    public void testSetup() throws Exception {
        this.item.setup();
        ((GuidedDecisionTableAccordionItem.View)Mockito.verify((Object)this.view)).init((Object)this.item);
    }

    @Test
    public void testInit() throws Exception {
        GuidedDecisionTableAccordionItem.Type type = GuidedDecisionTableAccordionItem.Type.CONDITION;
        Widget widget = (Widget)Mockito.mock(Widget.class);
        this.item.init("uuid", type, widget);
        ((GuidedDecisionTableAccordionItem)Mockito.verify((Object)this.item)).refreshView();
        Assert.assertEquals((Object)type, (Object)this.item.getType());
        Assert.assertEquals((Object)widget, (Object)this.item.getContent());
    }

    @Test
    public void testGetTitle() throws Exception {
        GuidedDecisionTableAccordionItem.Type type = GuidedDecisionTableAccordionItem.Type.CONDITION;
        String title = "title";
        Mockito.when((Object)this.translationService.format(type.getTitleKey(), new Object[0])).thenReturn((Object)"title");
        Mockito.when((Object)this.item.getType()).thenReturn((Object)type);
        String itemTitle = this.item.getTitle();
        Assert.assertEquals((Object)"title", (Object)itemTitle);
    }

    @Test
    public void testSetOpen() throws Exception {
        boolean isOpen = false;
        this.item.setOpen(false);
        ((GuidedDecisionTableAccordionItem.View)Mockito.verify((Object)this.view)).setOpen(false);
    }

    @Test
    public void testRefreshView() throws Exception {
        GuidedDecisionTableAccordionItem.Type type = GuidedDecisionTableAccordionItem.Type.CONDITION;
        String title = "title";
        Widget widget = (Widget)Mockito.mock(Widget.class);
        Mockito.when((Object)this.item.getType()).thenReturn((Object)type);
        Mockito.when((Object)this.item.getTitle()).thenReturn((Object)"title");
        Mockito.when((Object)this.item.getContent()).thenReturn((Object)widget);
        this.item.refreshView();
        ((GuidedDecisionTableAccordionItem.View)Mockito.verify((Object)this.view)).setItemId(Mockito.anyString());
        ((GuidedDecisionTableAccordionItem.View)Mockito.verify((Object)this.view)).setTitle("title");
        ((GuidedDecisionTableAccordionItem.View)Mockito.verify((Object)this.view)).setContent(widget);
    }
}

