/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.DefaultValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.AttributeColumnConfigRow;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.AttributeColumnConfigRowView;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class AttributeColumnConfigRowTest {
    private AttributeColumnConfigRow columnConfigRow;
    @Mock
    AttributeCol52 attributeColumn;
    @Mock
    AttributeCol52 editedAttributeColumn;
    @Mock
    GuidedDecisionTableModellerView.Presenter presenter;
    @Mock
    AttributeColumnConfigRowView view;
    @Mock
    GuidedDecisionTableView.Presenter decisionTable;
    @Mock
    DefaultValueWidgetFactory.DefaultValueChangedEvent event;
    @Mock
    DTCellValue52 defaultValue;
    @Captor
    ArgumentCaptor<ClickHandler> clickCaptor;
    @Captor
    ArgumentCaptor<DefaultValueWidgetFactory.DefaultValueChangedEventHandler> defaultValueCaptor;
    @Mock
    CheckBox useRowNumberCheckBox;
    @Mock
    CheckBox reverseOrderCheckBox;
    @Mock
    CheckBox hideColumnCheckBox;

    @Before
    public void setUp() throws Exception {
        this.columnConfigRow = new AttributeColumnConfigRow();
        this.columnConfigRow.view = this.view;
        Mockito.when((Object)this.attributeColumn.getAttribute()).thenReturn((Object)"salience");
        Mockito.when((Object)this.attributeColumn.cloneColumn()).thenReturn((Object)this.editedAttributeColumn);
        Mockito.when((Object)this.presenter.isActiveDecisionTableEditable()).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getActiveDecisionTable()).thenReturn((Object)this.decisionTable);
        Mockito.when((Object)this.view.addUseRowNumberCheckBox((AttributeCol52)Matchers.any(), Matchers.anyBoolean(), (ClickHandler)Matchers.any())).thenReturn((Object)this.useRowNumberCheckBox);
        Mockito.when((Object)this.view.addReverseOrderCheckBox((AttributeCol52)Matchers.any(), Matchers.anyBoolean(), (ClickHandler)Matchers.any())).thenReturn((Object)this.reverseOrderCheckBox);
        Mockito.when((Object)this.view.addHideColumnCheckBox((AttributeCol52)Matchers.any(), (ClickHandler)Matchers.any())).thenReturn((Object)this.hideColumnCheckBox);
    }

    @Test
    public void testInit() throws Exception {
        this.columnConfigRow.init(this.attributeColumn, this.presenter);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).addColumnLabel(this.attributeColumn);
    }

    @Test
    public void testInitUseRowNumberCheckBox() {
        Mockito.when((Object)this.useRowNumberCheckBox.getValue()).thenReturn((Object)true);
        this.columnConfigRow.init(this.attributeColumn, this.presenter);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).addUseRowNumberCheckBox((AttributeCol52)Matchers.eq((Object)this.attributeColumn), Matchers.eq((boolean)true), (ClickHandler)this.clickCaptor.capture());
        ((ClickHandler)this.clickCaptor.getValue()).onClick(null);
        ((AttributeCol52)Mockito.verify((Object)this.editedAttributeColumn)).setUseRowNumber(true);
        ((CheckBox)Mockito.verify((Object)this.reverseOrderCheckBox)).setEnabled(true);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTable)).updateColumn(this.attributeColumn, this.editedAttributeColumn);
    }

    @Test
    public void testInitReverseOrder() throws Exception {
        Mockito.when((Object)this.reverseOrderCheckBox.getValue()).thenReturn((Object)true);
        this.columnConfigRow.init(this.attributeColumn, this.presenter);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).addReverseOrderCheckBox((AttributeCol52)Matchers.eq((Object)this.attributeColumn), Matchers.eq((boolean)true), (ClickHandler)this.clickCaptor.capture());
        ((ClickHandler)this.clickCaptor.getValue()).onClick(null);
        ((AttributeCol52)Mockito.verify((Object)this.editedAttributeColumn)).setReverseOrder(true);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTable)).updateColumn(this.attributeColumn, this.editedAttributeColumn);
    }

    @Test
    public void testInitDefaultValue() throws Exception {
        Mockito.when((Object)this.event.getEditedDefaultValue()).thenReturn((Object)this.defaultValue);
        this.columnConfigRow.init(this.attributeColumn, this.presenter);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).addDefaultValue((AttributeCol52)Matchers.eq((Object)this.attributeColumn), Matchers.eq((boolean)true), (DefaultValueWidgetFactory.DefaultValueChangedEventHandler)this.defaultValueCaptor.capture());
        ((DefaultValueWidgetFactory.DefaultValueChangedEventHandler)this.defaultValueCaptor.getValue()).onDefaultValueChanged(this.event);
        ((AttributeCol52)Mockito.verify((Object)this.editedAttributeColumn)).setDefaultValue(this.defaultValue);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTable)).updateColumn(this.attributeColumn, this.editedAttributeColumn);
    }

    @Test
    public void testInitHideColumn() throws Exception {
        Mockito.when((Object)this.hideColumnCheckBox.getValue()).thenReturn((Object)true);
        this.columnConfigRow.init(this.attributeColumn, this.presenter);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).addHideColumnCheckBox((AttributeCol52)Matchers.eq((Object)this.attributeColumn), (ClickHandler)this.clickCaptor.capture());
        ((ClickHandler)this.clickCaptor.getValue()).onClick(null);
        ((AttributeCol52)Mockito.verify((Object)this.editedAttributeColumn)).setHideColumn(true);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTable)).updateColumn(this.attributeColumn, this.editedAttributeColumn);
    }
}

