/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions;

import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.BaseColumnDefinitionBuilderTest;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ColumnDefinitionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.LimitedEntryActionSetFieldCol52DefinitionBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LimitedEntryActionSetFieldCol52DefinitionBuilderTest
extends BaseColumnDefinitionBuilderTest {
    @Override
    protected ColumnDefinitionBuilder getBuilder() {
        return new LimitedEntryActionSetFieldCol52DefinitionBuilder(this.serviceCaller);
    }

    @Test
    public void checkColumnType() {
        Assert.assertEquals(LimitedEntryActionSetFieldCol52.class, (Object)this.builder.getSupportedColumnType());
    }

    @Test
    public void unknownColumnTypeDoesNotTriggerBuilder() {
        RowNumberCol52 column = new RowNumberCol52();
        this.builder.generateDefinition(this.dtPresenter, (BaseColumn)column, definition -> Assert.fail((String)"RowNumberCol52 should not be handled by ActionSetFieldCol52DefinitionBuilder"));
    }

    @Test
    public void simpleActionSetField() {
        AtomicBoolean calledBack = new AtomicBoolean(false);
        this.setupPatternAndCondition();
        LimitedEntryActionSetFieldCol52 asf = new LimitedEntryActionSetFieldCol52();
        asf.setBoundName("$p");
        asf.setFactField("name");
        asf.setValue(new DTCellValue52("Michael"));
        this.model.getActionCols().add(asf);
        Mockito.when((Object)this.dmo.getFieldType((String)Mockito.eq((Object)"Person"), (String)Mockito.eq((Object)"name"))).thenReturn((Object)"String");
        this.builder.generateDefinition(this.dtPresenter, (BaseColumn)asf, definition -> {
            calledBack.set(true);
            Assert.assertEquals((Object)"$p.setName( \"Michael\" );", (Object)definition);
        });
        Assert.assertTrue((boolean)calledBack.get());
    }

    @Test
    public void simpleActionUpdateField() {
        AtomicBoolean calledBack = new AtomicBoolean(false);
        this.setupLimitedEntryPatternAndCondition();
        LimitedEntryActionSetFieldCol52 asf = new LimitedEntryActionSetFieldCol52();
        asf.setBoundName("$p");
        asf.setFactField("name");
        asf.setValue(new DTCellValue52("Michael"));
        asf.setUpdate(true);
        this.model.getActionCols().add(asf);
        Mockito.when((Object)this.dmo.getFieldType((String)Mockito.eq((Object)"Person"), (String)Mockito.eq((Object)"name"))).thenReturn((Object)"String");
        this.builder.generateDefinition(this.dtPresenter, (BaseColumn)asf, definition -> {
            calledBack.set(true);
            Assert.assertEquals((Object)"modify( $p ) {<br/>setName( \"Michael\" )<br/>}", (Object)definition);
        });
        Assert.assertTrue((boolean)calledBack.get());
    }
}

