/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard;

import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.NewGuidedDecisionTableWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.ActionInsertFactFieldsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.ActionSetFieldsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.ColumnExpansionPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.FactPatternConstraintsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.FactPatternsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.ImportsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.SummaryPage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.core.client.wizards.WizardView;

@RunWith(value=MockitoJUnitRunner.class)
public class NewGuidedDecisionTableWizardTest {
    @Mock
    private SummaryPage summaryPage;
    @Mock
    private ImportsPage importsPage;
    @Mock
    private ColumnExpansionPage columnExpansionPage;
    @Mock
    private FactPatternsPage factPatternsPage;
    @Mock
    private FactPatternConstraintsPage factPatternConstraintsPage;
    @Mock
    private ActionSetFieldsPage actionSetFieldsPage;
    @Mock
    private ActionInsertFactFieldsPage actionInsertFactFieldsPage;
    @Mock
    private WizardView view;
    @InjectMocks
    private NewGuidedDecisionTableWizard wizard = new NewGuidedDecisionTableWizard();

    @Test
    public void resolvedHitColumnIsAdded() throws Exception {
        GuidedDecisionTable52 model = this.whenModelIsCreatedWithHitPolicy(GuidedDecisionTable52.HitPolicy.RESOLVED_HIT);
        Assert.assertEquals((long)1L, (long)model.getMetadataCols().size());
        MetadataCol52 metadataCol52 = (MetadataCol52)model.getMetadataCols().get(0);
        Assert.assertEquals((Object)"ResolvedHitPriorityOverRow", (Object)metadataCol52.getMetadata());
    }

    @Test
    public void noHitPolicy() throws Exception {
        GuidedDecisionTable52 model = this.whenModelIsCreatedWithHitPolicy(GuidedDecisionTable52.HitPolicy.NONE);
        Assert.assertEquals((long)0L, (long)model.getMetadataCols().size());
    }

    private GuidedDecisionTable52 whenModelIsCreatedWithHitPolicy(GuidedDecisionTable52.HitPolicy hitPolicy) {
        Mockito.when((Object)this.summaryPage.getBaseFileName()).thenReturn((Object)"basefilename");
        NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler handler = (NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler)Mockito.mock(NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler.class);
        Path path = (Path)Mockito.mock(Path.class);
        this.wizard.setContent(path, "filename", GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, hitPolicy, (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class), handler);
        this.wizard.complete();
        ArgumentCaptor dtableArgumentCaptor = ArgumentCaptor.forClass(GuidedDecisionTable52.class);
        ((NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler)Mockito.verify((Object)handler)).save((Path)Mockito.eq((Object)path), (String)Mockito.eq((Object)"basefilename"), (GuidedDecisionTable52)dtableArgumentCaptor.capture());
        return (GuidedDecisionTable52)dtableArgumentCaptor.getValue();
    }
}

