/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.SummaryPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.BaseDecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class SummaryPageTest {
    @Mock
    private ConditionColumnPlugin plugin;
    @Mock
    private SummaryPage.View view;
    @Mock
    private SimplePanel content;
    @Mock
    private TranslationService translationService;
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private ManagedInstance<DecisionTableColumnPlugin> pluginManagedInstance;
    @InjectMocks
    private SummaryPage page;

    public SummaryPageTest() {
        this.page = (SummaryPage)Mockito.spy((Object)new SummaryPage(this.pluginManagedInstance, this.view, this.translationService));
    }

    @BeforeClass
    public static void setupPreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd/mm/yyyy");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
        GWTMockUtilities.disarm();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)this.plugin);
    }

    @Test
    public void testIsComplete() {
        this.page.isComplete(Assert::assertTrue);
    }

    @Test
    public void testOpenPageWhenSelectedItemIsBlank() {
        String selectedItem = "";
        this.page.openPage("");
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard, (VerificationMode)Mockito.never())).start((DecisionTableColumnPlugin)Mockito.any(BaseDecisionTableColumnPlugin.class));
    }

    @Test
    public void testOpenPageWhenTableIsReadOnly() {
        Mockito.when((Object)this.presenter.isReadOnly()).thenReturn((Object)true);
        String selectedItem = "page";
        this.page.openPage("page");
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard, (VerificationMode)Mockito.never())).start((DecisionTableColumnPlugin)Mockito.any(BaseDecisionTableColumnPlugin.class));
    }

    @Test
    public void testOpenPageWhenTheWizardCanBeOpened() {
        DecisionTableColumnPlugin plugin = this.pluginMock("plugin");
        String selectedItem = "page";
        ((SummaryPage)Mockito.doReturn((Object)plugin).when((Object)this.page)).findPluginByIdentifier("page");
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isReadOnly();
        this.page.openPage("page");
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).start(plugin);
    }

    @Test
    public void testPluginsSortedByTitle() {
        List<String> expectedTitles = Arrays.asList("Plugin A", "Plugin B", "Plugin C");
        List<String> actualTitles = this.mapTitles(this.page.sortByTitle((List)new ArrayList<DecisionTableColumnPlugin>(){
            {
                this.add(SummaryPageTest.this.pluginMock("Plugin A"));
                this.add(SummaryPageTest.this.pluginMock("Plugin C"));
                this.add(SummaryPageTest.this.pluginMock("Plugin B"));
            }
        }));
        Assert.assertEquals(expectedTitles, actualTitles);
    }

    private DecisionTableColumnPlugin pluginMock(String title) {
        DecisionTableColumnPlugin mock = (DecisionTableColumnPlugin)Mockito.mock(DecisionTableColumnPlugin.class);
        Mockito.when((Object)mock.getTitle()).thenReturn((Object)title);
        return mock;
    }

    private List<String> mapTitles(List<DecisionTableColumnPlugin> plugins) {
        return plugins.stream().map(DecisionTableColumnPlugin::getTitle).collect(Collectors.toList());
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "SummaryPage.NewColumn";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("SummaryPage.NewColumn", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        this.page.prepareView();
        ((SummaryPage.View)Mockito.verify((Object)this.view)).init((Object)this.page);
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }
}

