/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.table.pages;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.event.Event;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.AvailableField;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.FactPatternConstraintsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.FactPatternConstraintsPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.events.ConditionsDefinedEvent;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodel.service.IncrementalDataModelService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class FactPatternConstraintsPageTest {
    private List<ConditionCol52> conditions;
    private AsyncPackageDataModelOracleImpl oracle;
    @Mock
    private IncrementalDataModelService incrementalDataModelService;
    private Caller<IncrementalDataModelService> incrementalDataModelServiceCaller;
    @Mock
    private Pattern52 pattern;
    @Mock
    private Pattern52 secondPattern;
    @Mock
    private ConditionCol52 conditionCol;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private FactPatternConstraintsPageView view;
    @Mock
    private Validator validator;
    private Event<ConditionsDefinedEvent> conditionsDefinedEvent = (Event)Mockito.mock(EventSourceMock.class);
    @Captor
    private ArgumentCaptor<ConditionsDefinedEvent> conditionsDefinedEventCaptor;
    @Spy
    @InjectMocks
    private FactPatternConstraintsPage page;
    @Captor
    private ArgumentCaptor<List<AvailableField>> availableFieldsCaptor;
    private ModelField[] modelFields;

    @Before
    public void setUp() throws Exception {
        this.incrementalDataModelServiceCaller = new CallerMock((Object)this.incrementalDataModelService);
        this.oracle = new AsyncPackageDataModelOracleImpl(this.incrementalDataModelServiceCaller, null);
        this.page.oracle = this.oracle;
        this.page.model = this.model;
        this.page.validator = this.validator;
        Mockito.when((Object)this.pattern.getFactType()).thenReturn((Object)"org.Address");
        Mockito.when((Object)this.conditionCol.getFactField()).thenReturn((Object)"street");
        Mockito.when((Object)this.model.getPatterns()).thenReturn(Arrays.asList(this.pattern, this.secondPattern));
        this.modelFields = new ModelField[]{new ModelField("this", "org.Address", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.ACCESSOR, "this"), new ModelField("street", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, "String"), new ModelField("homeAddress", Boolean.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, "Boolean"), new ModelField("number", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, "Integer")};
        HashMap<String, ModelField[]> fields = new HashMap<String, ModelField[]>();
        fields.put("org.Address", this.modelFields);
        this.oracle.addModelFields(fields);
        this.conditions = new ArrayList<ConditionCol52>();
        this.conditions.add((ConditionCol52)Mockito.mock(ConditionCol52.class));
        Mockito.when((Object)this.pattern.getChildColumns()).thenReturn(this.conditions);
        Mockito.when((Object)this.secondPattern.getChildColumns()).thenReturn(this.conditions);
    }

    @Test
    public void testPrepareView() throws Exception {
        this.page.prepareView();
        ((FactPatternConstraintsPageView)Mockito.verify((Object)this.view)).setAvailablePatterns(Arrays.asList(this.pattern, this.secondPattern));
    }

    @Test
    public void testIsComplete() throws Exception {
        this.testConditionCompletion(true);
    }

    @Test
    public void testIsNotComplete() throws Exception {
        this.testConditionCompletion(false);
    }

    private void testConditionCompletion(boolean conditionsCompleted) {
        Mockito.when((Object)this.validator.isConditionValid((ConditionCol52)Matchers.any(ConditionCol52.class))).thenReturn((Object)conditionsCompleted);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.page.isComplete(callback);
        ((Event)Mockito.verify(this.conditionsDefinedEvent)).fire(this.conditionsDefinedEventCaptor.capture());
        Assert.assertEquals((Object)conditionsCompleted, (Object)((ConditionsDefinedEvent)this.conditionsDefinedEventCaptor.getValue()).getAreConditionsDefined());
        ((Callback)Mockito.verify((Object)callback)).callback((Object)conditionsCompleted);
    }

    @Test
    public void testSelectPattern() throws Exception {
        this.page.selectPattern(this.pattern);
        ((FactPatternConstraintsPageView)Mockito.verify((Object)this.view)).setAvailableFields((List)this.availableFieldsCaptor.capture());
        List availableFields = (List)this.availableFieldsCaptor.getValue();
        Assert.assertEquals((long)4L, (long)availableFields.size());
        Assert.assertTrue((boolean)availableFields.stream().allMatch(field -> field.getCalculationType() == 1 && (field.getName().compareTo("this") == 0 && field.getType().compareTo("this") == 0 || field.getName().compareTo("street") == 0 && field.getType().compareTo(String.class.getSimpleName()) == 0 || field.getName().compareTo("homeAddress") == 0 && field.getType().compareTo(Boolean.class.getSimpleName()) == 0 || field.getName().compareTo("number") == 0 && field.getType().compareTo(Integer.class.getSimpleName()) == 0)));
        ((FactPatternConstraintsPageView)Mockito.verify((Object)this.view)).setChosenConditions(this.conditions);
    }

    @Test
    public void testGetOperatorCompletionsLiteral() throws Exception {
        Mockito.when((Object)this.conditionCol.getConstraintValueType()).thenReturn((Object)1);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.page.getOperatorCompletions(this.pattern, this.conditionCol, callback);
        ((Callback)Mockito.verify((Object)callback)).callback((Object)new String[]{"==", "!=", "<", ">", "<=", ">=", "matches", "soundslike", "== null", "!= null", "in", "not in"});
    }

    @Test
    public void testGetOperatorCompletionsPredicate() throws Exception {
        Mockito.when((Object)this.conditionCol.getConstraintValueType()).thenReturn((Object)5);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.page.getOperatorCompletions(this.pattern, this.conditionCol, callback);
        ((Callback)Mockito.verify((Object)callback)).callback((Object)new String[]{"==", "!=", "<", ">", "<=", ">=", "matches", "soundslike", "== null", "!= null"});
    }

    @Test
    public void testSetChosenConditions() throws Exception {
        ConditionCol52 a = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        ConditionCol52 b = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        Assert.assertEquals((long)1L, (long)this.conditions.size());
        this.page.setChosenConditions(this.pattern, Arrays.asList(a, b));
        Assert.assertEquals((long)2L, (long)this.conditions.size());
        Assert.assertEquals((Object)a, (Object)this.conditions.get(0));
        Assert.assertEquals((Object)b, (Object)this.conditions.get(1));
    }
}

