/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import com.ait.lienzo.client.core.shape.Attributes;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTablePinnedEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class RadarMenuBuilderTest {
    @Mock
    private RadarMenuView view;
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter;
    @Mock
    private GuidedDecisionTableView dtPresenterView;
    @Mock
    private GuidedDecisionTableModellerView.Presenter modeller;
    @Mock
    private GuidedDecisionTableModellerView modellerView;
    @Mock
    private GridLayer modellerLayer;
    @Mock
    private Viewport modellerViewport;
    @Mock
    private Attributes attributes;
    @Mock
    private Bounds bounds;
    @Mock
    private Bounds visibleBounds;
    private Transform transform;
    private RadarMenuBuilder builder;
    private Set<GuidedDecisionTableView.Presenter> dtables = new HashSet<GuidedDecisionTableView.Presenter>();

    @Before
    public void setup() {
        this.transform = new Transform();
        this.builder = new RadarMenuBuilder(this.view);
        this.builder.setup();
        this.builder.setModeller(this.modeller);
        Mockito.when((Object)this.modeller.getView()).thenReturn((Object)this.modellerView);
        Mockito.when((Object)this.modeller.getView().getGridLayerView()).thenReturn((Object)this.modellerLayer);
        Mockito.when((Object)this.modellerLayer.getViewport()).thenReturn((Object)this.modellerViewport);
        Mockito.when((Object)this.modellerViewport.getTransform()).thenReturn((Object)this.transform);
        Mockito.when((Object)this.modellerViewport.getAttributes()).thenReturn((Object)this.attributes);
        Mockito.when((Object)this.modeller.getView().getBounds()).thenReturn((Object)this.bounds);
        Mockito.when((Object)this.modeller.getView().getGridLayerView().getVisibleBounds()).thenReturn((Object)this.visibleBounds);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn(this.dtables);
    }

    @Test
    public void testOnClick() {
        this.builder.onClick();
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).reset();
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModellerBounds((Bounds)Mockito.eq((Object)this.bounds));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setAvailableDecisionTables((Set)Mockito.eq(this.dtables));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVisibleBounds((Bounds)Mockito.eq((Object)this.visibleBounds));
    }

    @Test
    public void testOnDragVisibleBounds() {
        ArgumentCaptor transformArgumentCaptor = ArgumentCaptor.forClass(Transform.class);
        this.builder.onDragVisibleBounds(10.0, 10.0);
        ((Viewport)Mockito.verify((Object)this.modellerViewport, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)transformArgumentCaptor.capture());
        Transform result = (Transform)transformArgumentCaptor.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)-10.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)-10.0, (double)result.getTranslateY(), (double)0.0);
        ((GridLayer)Mockito.verify((Object)this.modellerLayer, (VerificationMode)Mockito.times((int)1))).batch();
    }

    @Test
    public void testOnDragVisibleBoundsScaled50pct() {
        ArgumentCaptor transformArgumentCaptor = ArgumentCaptor.forClass(Transform.class);
        this.transform.scale(0.5, 0.5);
        this.builder.onDragVisibleBounds(10.0, 10.0);
        ((Viewport)Mockito.verify((Object)this.modellerViewport, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)transformArgumentCaptor.capture());
        Transform result = (Transform)transformArgumentCaptor.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)-5.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)-5.0, (double)result.getTranslateY(), (double)0.0);
        ((GridLayer)Mockito.verify((Object)this.modellerLayer, (VerificationMode)Mockito.times((int)1))).batch();
    }

    @Test
    public void testOnUpdateRadarEventNullModeller() {
        this.builder.onUpdateRadarEvent(new RadarMenuBuilder.UpdateRadarEvent(null));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setVisibleBounds((Bounds)Mockito.any(Bounds.class));
    }

    @Test
    public void testOnUpdateRadarEventDifferentModeller() {
        this.builder.onUpdateRadarEvent(new RadarMenuBuilder.UpdateRadarEvent((GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class)));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setVisibleBounds((Bounds)Mockito.any(Bounds.class));
    }

    @Test
    public void testOnUpdateRadarEventAssociatedModeller() {
        this.builder.onUpdateRadarEvent(new RadarMenuBuilder.UpdateRadarEvent(this.modeller));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).reset();
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModellerBounds((Bounds)Mockito.eq((Object)this.bounds));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setAvailableDecisionTables((Set)Mockito.eq(this.dtables));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVisibleBounds((Bounds)Mockito.eq((Object)this.visibleBounds));
    }

    @Test
    public void testEnableDrag_Pinned() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent(this.modeller, true));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableDrag(Mockito.eq((boolean)false));
    }

    @Test
    public void testEnableDrag_Pinned_DifferentModeller() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent((GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class), true));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableDrag(((Boolean)Mockito.any(Boolean.class)).booleanValue());
    }

    @Test
    public void testEnableDrag_Unpinned() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent(this.modeller, false));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableDrag(Mockito.eq((boolean)true));
    }

    @Test
    public void testEnableDrag_Unpinned_DifferentModeller() {
        this.builder.onDecisionTablePinnedEvent(new DecisionTablePinnedEvent((GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class), false));
        ((RadarMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableDrag(((Boolean)Mockito.any(Boolean.class)).booleanValue());
    }
}

