/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.guided.dtable.client.handlers.NewGuidedDecisionTableGraphHandler;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableGraphResourceType;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableGraphEditorService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewGuidedDecisionTableGraphHandlerTest {
    @Mock
    private PlaceManager placeManager;
    @Mock
    private GuidedDecisionTableGraphEditorService service;
    private Caller<GuidedDecisionTableGraphEditorService> serviceCaller;
    @Mock
    private BusyIndicatorView busyIndicatorView;
    @Mock
    private NewResourcePresenter newResourcePresenter;
    @Mock
    private EventSourceMock<NotificationEvent> mockNotificationEvent;
    @Mock
    private EventSourceMock<NewResourceSuccessEvent> newResourceSuccessEventMock;
    @Captor
    private ArgumentCaptor<Path> pathCaptor;
    @Captor
    private ArgumentCaptor<String> fileNameCaptor;
    private NewGuidedDecisionTableGraphHandler handler;
    private GuidedDTableGraphResourceType resourceType = new GuidedDTableGraphResourceType();

    @Before
    public void setup() {
        this.serviceCaller = new CallerMock((Object)this.service);
        NewGuidedDecisionTableGraphHandler wrapped = new NewGuidedDecisionTableGraphHandler(this.placeManager, this.serviceCaller, this.resourceType, this.busyIndicatorView){
            {
                this.notificationEvent = NewGuidedDecisionTableGraphHandlerTest.this.mockNotificationEvent;
                this.newResourceSuccessEvent = NewGuidedDecisionTableGraphHandlerTest.this.newResourceSuccessEventMock;
            }
        };
        this.handler = (NewGuidedDecisionTableGraphHandler)Mockito.spy((Object)wrapped);
        Mockito.when((Object)this.service.create((Path)Mockito.any(Path.class), (String)Mockito.any(String.class), Mockito.any(GuidedDecisionTableEditorGraphModel.class), (String)Mockito.any(String.class))).thenAnswer(invocation -> {
            Path path = (Path)invocation.getArguments()[0];
            String fileName = (String)invocation.getArguments()[1];
            Path newPath = PathFactory.newPath((String)fileName, (String)(path.toURI() + "/" + fileName));
            return newPath;
        });
    }

    @Test
    public void testCreate() {
        String fileName = "fileName";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://project/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        this.handler.create(pkg, "fileName", this.newResourcePresenter);
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify(this.newResourceSuccessEventMock, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NewResourceSuccessEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.pathCaptor.capture());
        Assert.assertEquals((Object)("default://project/src/main/resources/fileName." + this.resourceType.getSuffix()), (Object)((Path)this.pathCaptor.getValue()).toURI());
        ((GuidedDecisionTableGraphEditorService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).create((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("fileName." + this.resourceType.getSuffix())), Mockito.any(GuidedDecisionTableEditorGraphModel.class), (String)Mockito.any(String.class));
    }
}

