/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Image;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionPopup;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionPopupView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.rule.client.editor.CEPWindowOperatorsDropdown;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.i18n.HumanReadableConstants;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class, GuidedDecisionTableImageResources508.class, CEPWindowOperatorsDropdown.class})
public class ConditionPopupTest {
    private static final String COLUMN_HEADER = "Some Column Header";
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private ConditionColumnCommand refreshGrid;
    private ConditionPopup popup;
    private GuidedDecisionTable52 model;
    private Pattern52 pattern;
    private ConditionCol52 column;

    @BeforeClass
    public static void setupApplicationPreferences() {
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd-MM-yyyy");
            }
        });
    }

    @Before
    public void setUp() throws Exception {
        this.model = new GuidedDecisionTable52();
        this.pattern = new Pattern52();
        this.column = new ConditionCol52();
        this.pattern.setFactType("Pattern");
        this.pattern.setBoundName("$p2");
        this.column.setHeader(COLUMN_HEADER);
        this.column.setFactField("field2");
        this.column.setBinding("$p2");
        this.column.setOperator("==");
        this.column.setValueList("xyz");
        this.setUpPopup(this.model, this.pattern, this.column, false, false);
        this.popup.view = (ConditionPopupView)Mockito.spy((Object)new ConditionPopupView(this.popup){

            protected Image getEditImage() {
                return (Image)Mockito.mock(Image.class);
            }

            protected Image getDisabledImage() {
                return (Image)Mockito.mock(Image.class);
            }
        });
    }

    private void setUpPopup(GuidedDecisionTable52 model, Pattern52 pattern, ConditionCol52 column, boolean isNew, boolean isReadOnly) {
        this.popup = (ConditionPopup)Mockito.spy((Object)new ConditionPopup(model, this.oracle, this.presenter, this.refreshGrid, pattern, column, isNew, isReadOnly){

            protected ConditionPopupView getWidgets() {
                return (ConditionPopupView)Mockito.mock(ConditionPopupView.class);
            }
        });
    }

    @Test
    public void patternIsPreSelectedWhenBeingEdited() {
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("$p1");
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("$p2");
        this.model.getConditions().add(p1);
        this.model.getConditions().add(p2);
        this.popup.loadPatterns();
        ArgumentCaptor indexArgumentCaptor = ArgumentCaptor.forClass(Integer.class);
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).selectListBoxItem((ListBox)Mockito.any(ListBox.class), ((Integer)indexArgumentCaptor.capture()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)indexArgumentCaptor.getValue()).intValue());
    }

    @Test
    public void fieldIsPreSelectedWhenBeingEdited() {
        ModelField[] modelFields = new ModelField[]{new ModelField("field1", "java.lang.Integer", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.ACCESSOR, "Integer"), new ModelField("field2", "java.lang.Integer", ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.ACCESSOR, "Integer")};
        ((AsyncPackageDataModelOracle)Mockito.doAnswer(invocation -> {
            Callback callback = (Callback)invocation.getArguments()[2];
            callback.callback((Object)modelFields);
            return null;
        }).when((Object)this.oracle)).getFieldCompletions((String)Mockito.eq((Object)"Pattern"), (FieldAccessorsAndMutators)Mockito.eq((Object)FieldAccessorsAndMutators.ACCESSOR), (Callback)Mockito.any(Callback.class));
        this.popup.loadFields();
        ArgumentCaptor indexArgumentCaptor = ArgumentCaptor.forClass(Integer.class);
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).selectListBoxItem((ListBox)Mockito.any(ListBox.class), ((Integer)indexArgumentCaptor.capture()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)indexArgumentCaptor.getValue()).intValue());
    }

    @Test
    public void testConfirmFieldChangePopUp() throws Exception {
        FormStylePopup fieldChangePopUp = (FormStylePopup)Mockito.mock(FormStylePopup.class);
        this.popup.confirmFieldChangePopUp(fieldChangePopUp, "newSelectedField");
        Assert.assertEquals(null, (Object)this.popup.getEditingCol().getOperator());
        Assert.assertEquals(null, (Object)this.popup.getEditingCol().getValueList());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).setFieldLabelText("newSelectedField");
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).setValueListWidgetText("");
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableLiteral(true);
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableFormula(true);
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enablePredicate(true);
        Assert.assertEquals((long)1L, (long)this.popup.getEditingCol().getConstraintValueType());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).addLimitedEntryValue();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).setLimitedEntryVisibility(Mockito.anyBoolean());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).addDefaultValueIfNoPresent();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).setDefaultValueVisibility(false);
        Assert.assertEquals(null, (Object)this.popup.getEditingCol().getDefaultValue());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).setOperatorLabelText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAnOperator());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableEditField(true);
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableEditOperator(true);
        ((FormStylePopup)Mockito.verify((Object)fieldChangePopUp)).hide();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableFooter(true);
    }

    @Test
    public void testConfirmFieldChangePopUpNoChange() throws Exception {
        FormStylePopup fieldChangePopUp = (FormStylePopup)Mockito.mock(FormStylePopup.class);
        this.popup.confirmFieldChangePopUp(fieldChangePopUp, "field2");
        Assert.assertEquals((Object)"==", (Object)this.popup.getEditingCol().getOperator());
        Assert.assertEquals((Object)"xyz", (Object)this.popup.getEditingCol().getValueList());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).setFieldLabelText("field2");
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).setValueListWidgetText("xyz");
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableLiteral(true);
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableFormula(true);
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enablePredicate(true);
        Assert.assertEquals((long)1L, (long)this.popup.getEditingCol().getConstraintValueType());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).addLimitedEntryValue();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).setLimitedEntryVisibility(Mockito.anyBoolean());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).addDefaultValueIfNoPresent();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).setDefaultValueVisibility(true);
        Assert.assertEquals(null, (Object)this.popup.getEditingCol().getDefaultValue().getStringValue());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).setOperatorLabelText(HumanReadableConstants.INSTANCE.isEqualTo());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableEditField(true);
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableEditOperator(true);
        ((FormStylePopup)Mockito.verify((Object)fieldChangePopUp)).hide();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableFooter(true);
    }

    @Test
    public void testCancelFieldChangePopUp() throws Exception {
        FormStylePopup fieldChangePopUp = (FormStylePopup)Mockito.mock(FormStylePopup.class);
        this.popup.cancelFieldChangePopUp(fieldChangePopUp);
        Assert.assertEquals((Object)"==", (Object)this.popup.getEditingCol().getOperator());
        Assert.assertEquals((Object)"xyz", (Object)this.popup.getEditingCol().getValueList());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).setFieldLabelText(Mockito.anyString());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).setValueListWidgetText(Mockito.anyString());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).enableLiteral(Mockito.anyBoolean());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).enableFormula(Mockito.anyBoolean());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).enablePredicate(Mockito.anyBoolean());
        Assert.assertEquals((long)1L, (long)this.popup.getEditingCol().getConstraintValueType());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).addLimitedEntryValue();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).setLimitedEntryVisibility(Mockito.anyBoolean());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).addDefaultValueIfNoPresent();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).setDefaultValueVisibility(Mockito.anyBoolean());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).setOperatorLabelText(Mockito.anyString());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).enableEditField(Mockito.anyBoolean());
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).enableEditOperator(Mockito.anyBoolean());
        ((FormStylePopup)Mockito.verify((Object)fieldChangePopUp)).hide();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).enableFooter(true);
    }

    @Test
    public void testApplyChangesMissingHeader() {
        this.column.setHeader(null);
        this.setUpPopup(this.model, this.pattern, this.column, false, false);
        this.popup.view = (ConditionPopupView)Mockito.spy((Object)new ConditionPopupView(this.popup){

            protected Image getEditImage() {
                return (Image)Mockito.mock(Image.class);
            }

            protected Image getDisabledImage() {
                return (Image)Mockito.mock(Image.class);
            }
        });
        this.popup.applyChanges();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).warnAboutMissingColumnHeaderDescription();
    }

    @Test
    public void testApplyChangesMissingFactField() {
        this.column.setFactField(null);
        this.setUpPopup(this.model, this.pattern, this.column, false, false);
        this.popup.view = (ConditionPopupView)Mockito.spy((Object)new ConditionPopupView(this.popup){

            protected Image getEditImage() {
                return (Image)Mockito.mock(Image.class);
            }

            protected Image getDisabledImage() {
                return (Image)Mockito.mock(Image.class);
            }
        });
        this.popup.applyChanges();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).warnAboutMissingFactField();
    }

    @Test
    public void testApplyChangesMissingOperator() {
        this.column.setOperator(null);
        this.setUpPopup(this.model, this.pattern, this.column, false, false);
        this.popup.view = (ConditionPopupView)Mockito.spy((Object)new ConditionPopupView(this.popup){

            protected Image getEditImage() {
                return (Image)Mockito.mock(Image.class);
            }

            protected Image getDisabledImage() {
                return (Image)Mockito.mock(Image.class);
            }
        });
        this.popup.applyChanges();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).warnAboutMissingOperator();
    }

    @Test
    public void testApplyChangesPredicate() {
        this.column.setConstraintValueType(5);
        this.setUpPopup(this.model, this.pattern, this.column, false, false);
        this.popup.applyChanges();
        Assert.assertNull((Object)this.popup.getEditingCol().getOperator());
    }

    @Test
    public void testBindingSameFactAndField() {
        this.popup.applyChanges();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).warnAboutAlreadyUsedBinding();
    }

    @Test
    public void testBindingNullFact() {
        this.pattern.setBoundName(null);
        this.setUpPopup(this.model, this.pattern, this.column, false, false);
        this.popup.view = (ConditionPopupView)Mockito.spy((Object)new ConditionPopupView(this.popup){

            protected Image getEditImage() {
                return (Image)Mockito.mock(Image.class);
            }

            protected Image getDisabledImage() {
                return (Image)Mockito.mock(Image.class);
            }
        });
        this.popup.applyChanges();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).warnAboutAlreadyUsedBinding();
    }

    @Test
    public void testBindingNullField() {
        this.column.setBinding(null);
        this.setUpPopup(this.model, this.pattern, this.column, false, false);
        this.popup.view = (ConditionPopupView)Mockito.spy((Object)new ConditionPopupView(this.popup){

            protected Image getEditImage() {
                return (Image)Mockito.mock(Image.class);
            }

            protected Image getDisabledImage() {
                return (Image)Mockito.mock(Image.class);
            }
        });
        this.popup.applyChanges();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).warnAboutAlreadyUsedBinding();
    }

    @Test
    public void testBindingDifferentFactAndField() {
        this.column.setBinding("$field");
        this.setUpPopup(this.model, this.pattern, this.column, false, false);
        this.popup.view = (ConditionPopupView)Mockito.spy((Object)new ConditionPopupView(this.popup){

            protected Image getEditImage() {
                return (Image)Mockito.mock(Image.class);
            }

            protected Image getDisabledImage() {
                return (Image)Mockito.mock(Image.class);
            }
        });
        this.popup.applyChanges();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view, (VerificationMode)Mockito.never())).warnAboutAlreadyUsedBinding();
    }

    @Test
    public void testDuplicateHeader() throws Exception {
        this.column.setBinding("$field");
        BaseColumn baseColumn = (BaseColumn)Mockito.mock(BaseColumn.class);
        Mockito.when((Object)baseColumn.getHeader()).thenReturn((Object)COLUMN_HEADER);
        CompositeColumn compositeColumn = (CompositeColumn)Mockito.mock(CompositeColumn.class);
        Mockito.when((Object)compositeColumn.getChildColumns()).thenReturn(Arrays.asList(baseColumn));
        this.model.getConditions().add(compositeColumn);
        this.setUpPopup(this.model, this.pattern, this.column, true, false);
        this.popup.view = (ConditionPopupView)Mockito.spy((Object)new ConditionPopupView(this.popup){

            protected Image getEditImage() {
                return (Image)Mockito.mock(Image.class);
            }

            protected Image getDisabledImage() {
                return (Image)Mockito.mock(Image.class);
            }
        });
        this.popup.applyChanges();
        ((ConditionPopupView)Mockito.verify((Object)this.popup.view)).warnAboutAlreadyUsedColumnHeaderName();
    }

    @Test
    public void testClearBindingWhenPredicate() throws Exception {
        this.column.setBinding("$field");
        this.column.setConstraintValueType(5);
        this.setUpPopup(this.model, this.pattern, this.column, true, false);
        this.popup.applyChanges();
        Assert.assertNull((Object)this.popup.getEditingCol().getBinding());
    }

    @Test
    public void extractEditingPatternWithBoundPatterns() {
        Pattern52 p = new Pattern52();
        p.setFactType("Applicant");
        p.setBoundName("$a");
        this.model.getConditions().add(p);
        String[] metadata = new String[]{"Applicant", "$a", "false"};
        Optional found = this.popup.extractEditingPattern(metadata);
        Assert.assertTrue((boolean)found.isPresent());
        Assert.assertEquals((Object)p, found.get());
    }

    @Test
    public void extractEditingPatternWithoutBoundPatterns() {
        String[] metadata = new String[]{"Applicant", "$a", "false"};
        Optional found = this.popup.extractEditingPattern(metadata);
        Assert.assertFalse((boolean)found.isPresent());
    }

    @Test
    public void extractEditingPatternWithNotPatterns() {
        Pattern52 p = new Pattern52();
        p.setFactType("Applicant");
        p.setBoundName("");
        p.setNegated(true);
        this.model.getConditions().add(p);
        String[] metadata = new String[]{"Applicant", "", "true"};
        Optional found = this.popup.extractEditingPattern(metadata);
        Assert.assertTrue((boolean)found.isPresent());
        Assert.assertEquals((Object)p, found.get());
    }

    @Test
    public void extractEditingPatternWithoutNotPatterns() {
        String[] metadata = new String[]{"Applicant", "", "true"};
        Optional found = this.popup.extractEditingPattern(metadata);
        Assert.assertFalse((boolean)found.isPresent());
    }

    @Test(expected=IllegalStateException.class)
    public void showPatternChangeIllegalStateException() {
        ListBox pats = (ListBox)Mockito.mock(ListBox.class);
        FormStylePopup pop = (FormStylePopup)Mockito.mock(FormStylePopup.class);
        Mockito.when((Object)pats.getSelectedIndex()).thenReturn((Object)0);
        Mockito.when((Object)pats.getValue(Mockito.eq((int)0))).thenReturn((Object)"not Applicant []");
        Command c = this.popup.getShowPatternOKCommand(pats, pop);
        c.execute();
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).makeLimitedValueWidget();
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).makeDefaultValueWidget();
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).displayCEPOperators();
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).doPatternLabel();
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).doValueList();
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).doCalculationType();
        ((ConditionPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.never())).doImageButtons();
        ((FormStylePopup)Mockito.verify((Object)pop, (VerificationMode)Mockito.never())).hide();
    }
}

