/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.BaseGuidedDecisionTablePresenterTest;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerPresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshAttributesPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMetaDataPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTablePresenterAttributesAndMetadataTest
extends BaseGuidedDecisionTablePresenterTest {
    @Captor
    private ArgumentCaptor<Set<String>> reservedAttributesCaptor;
    @Captor
    private ArgumentCaptor<Map<String, String>> callbackValueCaptor;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.dtPresenter.onAppendRow();
        this.dtPresenter.onAppendRow();
        this.dtPresenter.onAppendRow();
    }

    @Test
    public void newAttributeOrMetaDataColumn() {
        this.dtPresenter.newAttributeOrMetaDataColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newAttributeOrMetaDataColumn((Set)Mockito.any());
    }

    @Test
    public void isMetaDataUnique() {
        MetadataCol52 metadata = new MetadataCol52();
        metadata.setMetadata("metadata");
        this.dtPresenter.getModel().getMetadataCols().add(metadata);
        Assert.assertFalse((boolean)this.dtPresenter.isMetaDataUnique("metadata"));
        Assert.assertTrue((boolean)this.dtPresenter.isMetaDataUnique("cheese"));
    }

    @Test
    public void getExistingAttributeNames() {
        AttributeCol52 attribute1 = new AttributeCol52();
        attribute1.setAttribute("enabled");
        AttributeCol52 attribute2 = new AttributeCol52();
        attribute2.setAttribute("auto-focus");
        this.dtPresenter.getModel().getAttributeCols().add(attribute1);
        this.dtPresenter.getModel().getAttributeCols().add(attribute2);
        this.dtPresenter.newAttributeOrMetaDataColumn();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Set.class);
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).newAttributeOrMetaDataColumn((Set)argumentCaptor.capture());
        Set existingAttributeNames = (Set)argumentCaptor.getValue();
        Assert.assertEquals((long)2L, (long)existingAttributeNames.size());
        Assert.assertTrue((boolean)existingAttributeNames.contains("enabled"));
        Assert.assertTrue((boolean)existingAttributeNames.contains("auto-focus"));
    }

    @Test
    public void appendAttributeColumn() throws ModelSynchronizer.MoveColumnVetoException {
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute("auto-focus");
        this.dtPresenter.appendColumn(column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendColumn((BaseColumn)Mockito.eq((Object)column));
        ((Event)Mockito.verify((Object)this.refreshAttributesPanelEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RefreshAttributesPanelEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void appendMetadataColumn() throws ModelSynchronizer.MoveColumnVetoException {
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        MetadataCol52 column = new MetadataCol52();
        column.setMetadata("metadata");
        this.dtPresenter.appendColumn(column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendColumn((BaseColumn)Mockito.eq((Object)column));
        ((Event)Mockito.verify((Object)this.refreshMetaDataPanelEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RefreshMetaDataPanelEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void deleteAttributeColumn() throws ModelSynchronizer.MoveColumnVetoException {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute("auto-focus");
        this.dtPresenter.appendColumn(column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        this.dtPresenter.deleteColumn(column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)column));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void deleteMetadataColumn() throws ModelSynchronizer.MoveColumnVetoException {
        MetadataCol52 column = new MetadataCol52();
        column.setMetadata("metadata");
        this.dtPresenter.appendColumn(column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        this.dtPresenter.deleteColumn(column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)column));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void updateAttributeColumn() throws ModelSynchronizer.MoveColumnVetoException {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute("auto-focus");
        this.dtPresenter.appendColumn(column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        AttributeCol52 update = new AttributeCol52();
        update.setAttribute("enabled");
        this.dtPresenter.updateColumn(column, update);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).updateColumn((BaseColumn)Mockito.eq((Object)column), (BaseColumn)Mockito.eq((Object)update));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void updateMetadataColumn() throws ModelSynchronizer.MoveColumnVetoException {
        MetadataCol52 column = new MetadataCol52();
        column.setMetadata("metadata");
        this.dtPresenter.appendColumn(column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        MetadataCol52 update = new MetadataCol52();
        column.setMetadata("update");
        this.dtPresenter.updateColumn(column, update);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).updateColumn((BaseColumn)Mockito.eq((Object)column), (BaseColumn)Mockito.eq((Object)update));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void testNewAttributeOrMetaDataColumnUniqueHitPolicy() throws Exception {
        this.testReservedAttributes(GuidedDecisionTable52.HitPolicy.UNIQUE_HIT, "activation-group");
    }

    @Test
    public void testNewAttributeOrMetaDataColumnFirstHitPolicy() throws Exception {
        this.testReservedAttributes(GuidedDecisionTable52.HitPolicy.FIRST_HIT, "activation-group", "salience");
    }

    @Test
    public void testNewAttributeOrMetaDataColumnResolvedHitPolicy() throws Exception {
        this.testReservedAttributes(GuidedDecisionTable52.HitPolicy.RESOLVED_HIT, "activation-group", "salience");
    }

    @Test
    public void testNewAttributeOrMetaDataColumnRuleOrderHitPolicy() throws Exception {
        this.testReservedAttributes(GuidedDecisionTable52.HitPolicy.RULE_ORDER, "salience");
    }

    private void testReservedAttributes(GuidedDecisionTable52.HitPolicy policy, String ... attributes) {
        this.model.setHitPolicy(policy);
        this.dtPresenter.newAttributeOrMetaDataColumn();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view)).newAttributeOrMetaDataColumn((Set)this.reservedAttributesCaptor.capture());
        Assert.assertEquals((long)attributes.length, (long)((Set)this.reservedAttributesCaptor.getValue()).size());
        for (String attribute : attributes) {
            Assert.assertTrue((boolean)((Set)this.reservedAttributesCaptor.getValue()).contains(attribute));
        }
    }
}

