/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.fakes.FakeProvider;
import java.util.Arrays;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.models.datamodel.rule.HasParameterizedOperator;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.OperatorPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.css.GuidedRuleEditorCss;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages;
import org.gwtbootstrap3.client.ui.ListBox;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.ItemImages;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class OperatorPageTest {
    @Captor
    ArgumentCaptor<Callback<String[]>> callbackArgumentCaptor;
    @Captor
    ArgumentCaptor<String[]> stringArrayArgumentCaptor;
    @Mock
    private ConditionColumnPlugin plugin;
    @Mock
    private TranslationService translationService;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private Pattern52 pattern52;
    @Mock
    private ConditionCol52 editingCol;
    @Mock
    private OperatorPage.View view;
    @Mock
    private SimplePanel content;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> eventSourceMock;
    @InjectMocks
    private OperatorPage page;

    public OperatorPageTest() {
        this.page = (OperatorPage)Mockito.spy((Object)new OperatorPage(this.view, this.eventSourceMock, this.translationService));
    }

    @BeforeClass
    public static void setupPreferences() {
        GWTMockUtilities.disarm();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)this.editingCol);
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)this.plugin);
    }

    @Test
    public void testIsConstraintValuePredicateWhenConstraintValueIsPredicate() {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)5);
        Assert.assertTrue((boolean)this.page.isConstraintValuePredicate());
    }

    @Test
    public void testIsConstraintValuePredicateWhenConstraintValueIsNotPredicate() {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)1);
        Assert.assertFalse((boolean)this.page.isConstraintValuePredicate());
    }

    @Test
    public void testCanSetOperatorWhenEditingColIsBlank() {
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"");
        Assert.assertFalse((boolean)this.page.hasFactField());
    }

    @Test
    public void testCanSetOperatorWhenEditingColIsNull() {
        Mockito.when((Object)this.plugin.getFactField()).thenReturn(null);
        Assert.assertFalse((boolean)this.page.hasFactField());
    }

    @Test
    public void testCanSetOperatorWhenEditingColIsNotNull() {
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Assert.assertTrue((boolean)this.page.hasFactField());
    }

    @Test
    public void testGetOperator() {
        String expectedOperator = "operator";
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)this.editingCol);
        Mockito.when((Object)this.editingCol.getOperator()).thenReturn((Object)"operator");
        String operator = this.page.getOperator();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).editingCol();
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).getOperator();
        Assert.assertEquals((Object)"operator", (Object)operator);
    }

    @Test
    public void testOperatorDropdownWhenOperatorCanBeSet() {
        this.registerFakeProvider();
        Mockito.when((Object)this.translationService.format("OperatorPage.NoOperator", new Object[0])).thenReturn((Object)"(no operator)");
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)this.editingCol);
        this.mockGetOperatorCompletionsToReturn(OperatorsOracle.STANDARD_OPERATORS);
        this.spyOperatorsDropdown();
        this.page.operatorDropdown(widget -> {
            Assert.assertTrue((boolean)(widget instanceof CEPOperatorsDropdown));
            CEPOperatorsDropdown operatorsDropdown = (CEPOperatorsDropdown)widget;
            ((CEPOperatorsDropdown)Mockito.verify((Object)operatorsDropdown)).insertItem("(no operator)", "", 1);
            ((CEPOperatorsDropdown)Mockito.verify((Object)operatorsDropdown)).addValueChangeHandler((ValueChangeHandler)Mockito.any());
        });
    }

    @Test
    public void testOperatorDropdownWhenOperatorCanNotBeSet() {
        Element elementMock = (Element)Mockito.mock(Element.class);
        ListBox listBoxMock = (ListBox)Mockito.mock(ListBox.class);
        Mockito.when((Object)listBoxMock.getElement()).thenReturn((Object)elementMock);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"");
        Mockito.when((Object)this.translationService.format("OperatorPage.PleaseChoose", new Object[0])).thenReturn((Object)"Choose...");
        ((OperatorPage)Mockito.doReturn((Object)listBoxMock).when((Object)this.page)).newListBox();
        this.page.operatorDropdown(widget -> {
            Assert.assertTrue((boolean)(widget instanceof ListBox));
            ((ListBox)Mockito.verify((Object)listBoxMock)).addItem("Choose...");
            ((Element)Mockito.verify((Object)elementMock)).setAttribute("disabled", "disabled");
        });
    }

    @Test
    public void testFilterOptionsForConstraintTypeLiteralWhenConstraintValueIsLiteral() {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)1);
        String[] result = this.page.filterOptionsForConstraintTypeLiteral(OperatorsOracle.EXPLICIT_LIST_OPERATORS);
        List<String> operators = Arrays.asList(result);
        Assert.assertTrue((boolean)operators.contains("in"));
        Assert.assertTrue((boolean)operators.contains("not in"));
        Assert.assertEquals((long)2L, (long)operators.size());
    }

    @Test
    public void testFilterOptionsForConstraintTypeLiteralWhenConstraintValueIsNotLiteral() {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)5);
        String[] result = this.page.filterOptionsForConstraintTypeLiteral(OperatorsOracle.EXPLICIT_LIST_OPERATORS);
        List<String> operators = Arrays.asList(result);
        Assert.assertFalse((boolean)operators.contains("in"));
        Assert.assertFalse((boolean)operators.contains("not in"));
        Assert.assertEquals((long)0L, (long)operators.size());
    }

    @Test
    public void testGetOperatorCompletions() {
        Mockito.when((Object)this.plugin.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        this.page.getOperatorCompletions(s -> {});
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle)).getOperatorCompletions((String)Mockito.eq((Object)"factType"), (String)Mockito.eq((Object)"factField"), (Callback)Mockito.any());
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "OperatorPage.Operator";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("OperatorPage.Operator", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        this.page.prepareView();
        ((OperatorPage.View)Mockito.verify((Object)this.view)).init((Object)this.page);
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }

    @Test
    public void testIsCompleteWhenFactFieldIsNull() {
        Mockito.when((Object)this.editingCol.getOperator()).thenReturn((Object)"operator");
        Mockito.when((Object)this.plugin.getFactField()).thenReturn(null);
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testIsCompleteWhenOperatorIsNull() {
        Mockito.when((Object)this.editingCol.getOperator()).thenReturn(null);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factType");
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testIsCompleteWhenFactFieldAndOperatorAreNotNull() {
        Mockito.when((Object)this.editingCol.getOperator()).thenReturn((Object)"operator");
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factType");
        this.page.isComplete(Assert::assertTrue);
    }

    @Test
    public void testSetOperator() {
        String operator = "operator";
        this.page.setOperator("operator");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setOperator("operator");
    }

    @Test
    public void testNewListBox() {
        ListBox listBox = this.page.newListBox();
        Assert.assertNotNull((Object)listBox);
    }

    private void spyOperatorsDropdown() {
        ((OperatorPage)Mockito.doAnswer(answer -> {
            Object firstArgument = answer.getArguments()[0];
            String[] operators = (String[])firstArgument;
            return Mockito.spy((Object)new CEPOperatorsDropdown(operators, (HasParameterizedOperator)this.editingCol));
        }).when((Object)this.page)).newCepOperatorsDropdown((String[])Mockito.any());
    }

    private void mockGetOperatorCompletionsToReturn(final String[] standardOperators) {
        ((OperatorPage)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Callback callback = (Callback)OperatorPageTest.this.callbackArgumentCaptor.getValue();
                callback.callback((Object)standardOperators);
                return null;
            }
        }).when((Object)this.page)).getOperatorCompletions((Callback)this.callbackArgumentCaptor.capture());
    }

    private void registerFakeProvider() {
        GwtMockito.useProviderForType(GuidedRuleEditorResources.class, this.fakeProvider());
    }

    private FakeProvider<GuidedRuleEditorResources> fakeProvider() {
        return provider -> new GuidedRuleEditorResources(){

            public ItemImages itemImages() {
                return (ItemImages)Mockito.mock(ItemImages.class);
            }

            public GuidedRuleEditorCss css() {
                return (GuidedRuleEditorCss)Mockito.mock(GuidedRuleEditorCss.class);
            }

            public GuidedRuleEditorImages images() {
                return (GuidedRuleEditorImages)Mockito.mock(GuidedRuleEditorImages.class);
            }
        };
    }
}

