/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.RuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLActionColumnPlugin;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={RuleModeller.class})
public class RuleModellerPageTest {
    @Mock
    private BRLActionColumnPlugin plugin;
    @Mock
    private RuleModellerPage.View view;
    @Mock
    private SimplePanel content;
    @Mock
    private TranslationService translationService;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @InjectMocks
    private RuleModellerPage<BRLActionColumnPlugin> page;

    public RuleModellerPageTest() {
        this.page = (RuleModellerPage)Mockito.spy((Object)new RuleModellerPage(this.view, this.translationService));
    }

    @BeforeClass
    public static void setupPreferences() {
        GWTMockUtilities.disarm();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)this.plugin);
    }

    @Test
    public void testIsCompleteWhenRuleModellerPageIsCompleted() throws Exception {
        Mockito.when((Object)this.plugin.isRuleModellerPageCompleted()).thenReturn((Object)true);
        this.page.isComplete(Assert::assertTrue);
    }

    @Test
    public void testIsCompleteWhenRuleModellerPageIsNotCompleted() throws Exception {
        Mockito.when((Object)this.plugin.isRuleModellerPageCompleted()).thenReturn((Object)false);
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testRuleModeller() throws Exception {
        Mockito.when((Object)this.plugin.tableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn(Mockito.mock(AsyncPackageDataModelOracle.class));
        RuleModeller ruleModeller = this.page.ruleModeller();
        Assert.assertNotNull((Object)ruleModeller);
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "RuleModellerPage.RuleModeller";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("RuleModellerPage.RuleModeller", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        Mockito.when((Object)this.plugin.tableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        this.page.prepareView();
        ((RuleModellerPage.View)Mockito.verify((Object)this.view)).init(this.page);
        ((RuleModellerPage)Mockito.verify(this.page)).markAsViewed();
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }
}

