/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals.NewPatternPresenter;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewPatternPresenterTest {
    @Mock
    private NewPatternPresenter.View view;
    @Mock
    private TranslationService translationService;
    @Mock
    private PatternPage patternPage;
    @Mock
    private GuidedDecisionTableView.Presenter decisionTablePresenter;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private ConditionColumnPlugin plugin;
    @Mock
    private GuidedDecisionTable52 table52;
    private NewPatternPresenter presenter;

    @Before
    public void setup() {
        Mockito.when((Object)this.decisionTablePresenter.getModel()).thenReturn((Object)this.table52);
        Mockito.when((Object)this.decisionTablePresenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.patternPage.presenter()).thenReturn((Object)this.decisionTablePresenter);
        Mockito.when((Object)this.patternPage.plugin()).thenReturn((Object)this.plugin);
        this.presenter = (NewPatternPresenter)Mockito.spy((Object)new NewPatternPresenter(this.view, this.translationService){
            {
                this.init(NewPatternPresenterTest.this.patternPage);
            }
        });
    }

    @Test
    public void testSetup() throws Exception {
        this.presenter.setup();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testShow() {
        this.presenter.show();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view)).clear();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testHide() {
        this.presenter.hide();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testCancel() throws Exception {
        this.presenter.cancel();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testGetFactTypes() throws Exception {
        String[] fakeFactTypesArray = new String[]{"factType1", "factType2", "factType3"};
        List<String> expectedFactTypes = Arrays.asList(fakeFactTypesArray);
        Mockito.when((Object)this.oracle.getFactTypes()).thenReturn((Object)fakeFactTypesArray);
        List factTypes = this.presenter.getFactTypes();
        Assert.assertEquals(expectedFactTypes, (Object)factTypes);
    }

    @Test
    public void testAddPatternWhenPatternIsValid() throws Exception {
        PatternWrapper pattern52 = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((NewPatternPresenter.View)Mockito.doReturn((Object)"Applicant").when((Object)this.view)).getSelectedFactType();
        ((NewPatternPresenter.View)Mockito.doReturn((Object)"app").when((Object)this.view)).getBindingText();
        ((NewPatternPresenter.View)Mockito.doReturn((Object)false).when((Object)this.view)).isNegatePatternMatch();
        ((NewPatternPresenter)Mockito.doReturn((Object)pattern52).when((Object)this.presenter)).pattern52();
        this.presenter.addPattern();
        ((PatternPage)Mockito.verify((Object)this.patternPage)).setEditingPattern(pattern52);
        ((PatternPage)Mockito.verify((Object)this.patternPage)).prepareView();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view)).hide();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showError((String)Mockito.any());
    }

    @Test
    public void testAddPatternWhenIsNegatePatternMatch() throws Exception {
        PatternWrapper pattern52 = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((NewPatternPresenter.View)Mockito.doReturn((Object)"").when((Object)this.view)).getSelectedFactType();
        ((NewPatternPresenter.View)Mockito.doReturn((Object)"").when((Object)this.view)).getBindingText();
        ((NewPatternPresenter.View)Mockito.doReturn((Object)true).when((Object)this.view)).isNegatePatternMatch();
        ((NewPatternPresenter)Mockito.doReturn((Object)pattern52).when((Object)this.presenter)).pattern52();
        this.presenter.addPattern();
        ((PatternPage)Mockito.verify((Object)this.patternPage)).setEditingPattern(pattern52);
        ((PatternPage)Mockito.verify((Object)this.patternPage)).prepareView();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view)).hide();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showError((String)Mockito.any());
    }

    @Test
    public void testAddPatternWhenFactNameIsBlank() throws Exception {
        Mockito.when((Object)this.view.getSelectedFactType()).thenReturn((Object)"Applicant");
        Mockito.when((Object)this.view.getBindingText()).thenReturn((Object)"");
        Mockito.when((Object)this.view.isNegatePatternMatch()).thenReturn((Object)false);
        this.presenter.addPattern();
        ((PatternPage)Mockito.verify((Object)this.patternPage, (VerificationMode)Mockito.never())).setEditingPattern((PatternWrapper)Mockito.any(PatternWrapper.class));
        ((PatternPage)Mockito.verify((Object)this.patternPage, (VerificationMode)Mockito.never())).prepareView();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view)).showError((String)Mockito.any());
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("NewPatternPresenter.PleaseEnterANameForFact", new Object[0]);
    }

    @Test
    public void testAddPatternWhenFactNameIsEqualsToFactType() throws Exception {
        Mockito.when((Object)this.view.getSelectedFactType()).thenReturn((Object)"Applicant");
        Mockito.when((Object)this.view.getBindingText()).thenReturn((Object)"Applicant");
        Mockito.when((Object)this.view.isNegatePatternMatch()).thenReturn((Object)false);
        this.presenter.addPattern();
        ((PatternPage)Mockito.verify((Object)this.patternPage, (VerificationMode)Mockito.never())).setEditingPattern((PatternWrapper)Mockito.any(PatternWrapper.class));
        ((PatternPage)Mockito.verify((Object)this.patternPage, (VerificationMode)Mockito.never())).prepareView();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view)).showError((String)Mockito.any());
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("NewPatternPresenter.PleaseEnterANameThatIsNotTheSameAsTheFactType", new Object[0]);
    }

    @Test
    public void testAddPatternWhenFactNameIsAlreadyUsedByAnotherPattern() throws Exception {
        Mockito.when((Object)this.view.getSelectedFactType()).thenReturn((Object)"Applicant");
        Mockito.when((Object)this.view.getBindingText()).thenReturn((Object)"app");
        Mockito.when((Object)this.view.isNegatePatternMatch()).thenReturn((Object)false);
        ((NewPatternPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isBindingUnique("app");
        this.presenter.addPattern();
        ((PatternPage)Mockito.verify((Object)this.patternPage, (VerificationMode)Mockito.never())).setEditingPattern((PatternWrapper)Mockito.any(PatternWrapper.class));
        ((PatternPage)Mockito.verify((Object)this.patternPage, (VerificationMode)Mockito.never())).prepareView();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
        ((NewPatternPresenter.View)Mockito.verify((Object)this.view)).showError((String)Mockito.any());
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("NewPatternPresenter.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern", new Object[0]);
    }

    @Test
    public void testPattern52() throws Exception {
        Mockito.when((Object)this.view.getSelectedFactType()).thenReturn((Object)"Applicant");
        Mockito.when((Object)this.view.getBindingText()).thenReturn((Object)"app");
        Mockito.when((Object)this.view.isNegatePatternMatch()).thenReturn((Object)false);
        PatternWrapper pattern52 = this.presenter.pattern52();
        Assert.assertEquals((Object)"Applicant", (Object)pattern52.getFactType());
        Assert.assertEquals((Object)"app", (Object)pattern52.getBoundName());
        Assert.assertEquals((Object)false, (Object)pattern52.isNegated());
    }
}

