/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.impl.DefaultClipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.EditMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.menu.MenuItemFactory;
import org.uberfire.ext.widgets.common.client.menu.MenuItemView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIconView;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;

@RunWith(value=MockitoJUnitRunner.class)
public class EditMenuBuilderTest {
    private EditMenuBuilder builder;
    private GuidedDecisionTable52 model;
    private GuidedDecisionTableUiModel uiModel;
    private Clipboard clipboard;
    @Mock
    private TranslationService ts;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewProducer;
    private MenuItemFactory menuItemFactory;
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter;
    private GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
    @Mock
    private GuidedDecisionTableView dtPresenterView;

    @Before
    public void setup() {
        this.model = new GuidedDecisionTable52();
        this.uiModel = new GuidedDecisionTableUiModel((ModelSynchronizer)Mockito.mock(ModelSynchronizer.class));
        this.clipboard = new DefaultClipboard();
        this.menuItemFactory = new MenuItemFactory(this.menuItemViewProducer);
        Mockito.when((Object)this.dtPresenter.getView()).thenReturn((Object)this.dtPresenterView);
        Mockito.when((Object)this.dtPresenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.dtPresenter.getAccess()).thenReturn((Object)this.access);
        Mockito.when((Object)this.dtPresenterView.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.ts.getTranslation((String)Mockito.any(String.class))).thenReturn((Object)"i18n");
        Mockito.when((Object)this.menuItemViewProducer.select(new Annotation[]{(Annotation)Mockito.any(Annotation.class)})).thenReturn(this.menuItemViewProducer);
        Mockito.when((Object)this.menuItemViewProducer.get()).thenReturn(Mockito.mock(MenuItemWithIconView.class));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.builder = new EditMenuBuilder(this.clipboard, this.ts, this.menuItemFactory);
        this.builder.setup();
    }

    @Test
    public void testOnDecisionTableSelectedEventWithNoSelections() {
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertFalse((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectedEventWithNonOtherwiseColumnSelected() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        });
        this.uiModel.selectCell(0, 2);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithOtherwiseColumnSelected() {
        this.model.getConditions().add(new Pattern52(){
            {
                this.setFactType("Fact");
                this.getChildColumns().add(new ConditionCol52(){
                    {
                        this.setFactType("Fact");
                        this.setFactField("field1");
                        this.setFieldType("String");
                        this.setOperator("==");
                    }
                });
            }
        });
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        });
        this.uiModel.selectCell(0, 2);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithOtherwiseCellSelected() {
        this.model.getConditions().add(new Pattern52(){
            {
                this.setFactType("Fact");
                this.getChildColumns().add(new ConditionCol52(){
                    {
                        this.setFactType("Fact");
                        this.setFactField("field1");
                        this.setFieldType("String");
                        this.setOperator("==");
                    }
                });
            }
        });
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52(){
                    {
                        this.setOtherwise(true);
                    }
                });
            }
        });
        this.uiModel.selectCell(0, 2);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithSelectionsWithClipboardPopulated() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        });
        this.uiModel.selectCell(0, 2);
        this.clipboard.setData((Set)new HashSet<Clipboard.ClipboardData>(){
            {
                this.add(new DefaultClipboard.ClipboardDataImpl(0, 2, (DTCellValue52)((List)EditMenuBuilderTest.this.model.getData().get(0)).get(2)));
            }
        });
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithNoSelections() {
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertFalse((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithNonOtherwiseColumnSelected() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        });
        this.uiModel.selectCell(0, 2);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithOtherwiseColumnSelected() {
        this.model.getConditions().add(new Pattern52(){
            {
                this.setFactType("Fact");
                this.getChildColumns().add(new ConditionCol52(){
                    {
                        this.setFactType("Fact");
                        this.setFactField("field1");
                        this.setFieldType("String");
                        this.setOperator("==");
                    }
                });
            }
        });
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        });
        this.uiModel.selectCell(0, 2);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithOtherwiseCellSelected() {
        this.model.getConditions().add(new Pattern52(){
            {
                this.setFactType("Fact");
                this.getChildColumns().add(new ConditionCol52(){
                    {
                        this.setFactType("Fact");
                        this.setFactField("field1");
                        this.setFieldType("String");
                        this.setOperator("==");
                    }
                });
            }
        });
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52(){
                    {
                        this.setOtherwise(true);
                    }
                });
            }
        });
        this.uiModel.selectCell(0, 2);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithSelectionsWithClipboardPopulated() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        });
        this.uiModel.selectCell(0, 2);
        this.clipboard.setData((Set)new HashSet<Clipboard.ClipboardData>(){
            {
                this.add(new DefaultClipboard.ClipboardDataImpl(0, 2, (DTCellValue52)((List)EditMenuBuilderTest.this.model.getData().get(0)).get(2)));
            }
        });
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectedEventReadOnly() {
        this.dtPresenter.getAccess().setReadOnly(true);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertFalse((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
    }
}

