/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.handlers;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.handlers.GuidedDecisionTableOptions;
import org.drools.workbench.screens.guided.dtable.client.handlers.NewGuidedDecisionTableHandler;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.wizard.NewGuidedDecisionTableWizardHelper;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.NewGuidedDecisionTableWizard;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewGuidedDecisionTableHandlerTest {
    @Mock
    private PlaceManager placeManager;
    @Mock
    private GuidedDecisionTableEditorService service;
    private Caller<GuidedDecisionTableEditorService> serviceCaller;
    @Mock
    private BusyIndicatorView busyIndicatorView;
    @Mock
    private NewResourcePresenter newResourcePresenter;
    @Mock
    private EventSourceMock<NotificationEvent> mockNotificationEvent;
    @Mock
    private AsyncPackageDataModelOracleFactory oracleFactory;
    @Mock
    private SyncBeanManager beanManager;
    @Mock
    private SyncBeanDef<NewGuidedDecisionTableWizard> wizardBeanDef;
    @Mock
    private NewGuidedDecisionTableWizard wizardBean;
    @Mock
    private EventSourceMock<NewResourceSuccessEvent> newResourceSuccessEventMock;
    @GwtMock
    private GuidedDecisionTableOptions options;
    @Captor
    private ArgumentCaptor<Path> pathCaptor;
    @Captor
    private ArgumentCaptor<String> fileNameCaptor;
    private NewGuidedDecisionTableHandler handler;
    private NewGuidedDecisionTableWizardHelper helper;
    private GuidedDTableResourceType resourceType = new GuidedDTableResourceType();

    @Before
    public void setup() {
        this.serviceCaller = new CallerMock((Object)this.service);
        this.helper = new NewGuidedDecisionTableWizardHelper(this.serviceCaller, this.oracleFactory, this.beanManager);
        NewGuidedDecisionTableHandler wrapped = new NewGuidedDecisionTableHandler(this.placeManager, this.serviceCaller, this.resourceType, this.options, this.busyIndicatorView, this.helper){
            {
                this.notificationEvent = NewGuidedDecisionTableHandlerTest.this.mockNotificationEvent;
                this.newResourceSuccessEvent = NewGuidedDecisionTableHandlerTest.this.newResourceSuccessEventMock;
            }
        };
        this.handler = (NewGuidedDecisionTableHandler)Mockito.spy((Object)wrapped);
        Mockito.when((Object)this.beanManager.lookupBean((Class)Mockito.eq(NewGuidedDecisionTableWizard.class), new Annotation[0])).thenReturn(this.wizardBeanDef);
        Mockito.when((Object)this.wizardBeanDef.getInstance()).thenReturn((Object)this.wizardBean);
        Mockito.when((Object)this.service.create((Path)Mockito.any(Path.class), (String)Mockito.any(String.class), Mockito.any(GuidedDecisionTable52.class), (String)Mockito.any(String.class))).thenAnswer(invocation -> {
            Path path = (Path)invocation.getArguments()[0];
            String fileName = (String)invocation.getArguments()[1];
            Path newPath = PathFactory.newPath((String)fileName, (String)(path.toURI() + "/" + fileName));
            return newPath;
        });
    }

    @Test
    public void testCreate_WithWizard() {
        String fileName = "fileName";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://project/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        Mockito.when((Object)this.options.isUsingWizard()).thenReturn((Object)true);
        Mockito.when((Object)this.options.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.options.getHitPolicy()).thenReturn((Object)GuidedDecisionTable52.HitPolicy.FIRST_HIT);
        this.handler.create(pkg, "fileName", this.newResourcePresenter);
        ((NewGuidedDecisionTableWizard)Mockito.verify((Object)this.wizardBean, (VerificationMode)Mockito.times((int)1))).setContent((Path)this.pathCaptor.capture(), (String)this.fileNameCaptor.capture(), (GuidedDecisionTable52.TableFormat)Mockito.eq((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY), (GuidedDecisionTable52.HitPolicy)Mockito.eq((Object)GuidedDecisionTable52.HitPolicy.FIRST_HIT), (AsyncPackageDataModelOracle)Mockito.any(AsyncPackageDataModelOracle.class), (NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler)Mockito.any(NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler.class));
    }

    @Test
    public void testCreate_WithoutWizard() {
        String fileName = "fileName";
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://project/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        Mockito.when((Object)this.options.isUsingWizard()).thenReturn((Object)false);
        this.handler.create(pkg, "fileName", this.newResourcePresenter);
        ((BusyIndicatorView)Mockito.verify((Object)this.busyIndicatorView, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((NewResourcePresenter)Mockito.verify((Object)this.newResourcePresenter, (VerificationMode)Mockito.times((int)1))).complete();
        ((EventSourceMock)Mockito.verify(this.mockNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify(this.newResourceSuccessEventMock, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NewResourceSuccessEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((Path)this.pathCaptor.capture());
        Assert.assertEquals((Object)"default://project/src/main/resources/fileName.gdst", (Object)((Path)this.pathCaptor.getValue()).toURI());
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).create((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("fileName." + this.resourceType.getSuffix())), Mockito.any(GuidedDecisionTable52.class), (String)Mockito.any(String.class));
    }

    @Test
    public void testResolvedHitPolicy() throws Exception {
        Package pkg = (Package)Mockito.mock(Package.class);
        Path resourcesPath = PathFactory.newPath((String)"resources", (String)"default://project/src/main/resources");
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)resourcesPath);
        Mockito.when((Object)this.options.isUsingWizard()).thenReturn((Object)false);
        Mockito.when((Object)this.options.getHitPolicy()).thenReturn((Object)GuidedDecisionTable52.HitPolicy.RESOLVED_HIT);
        this.handler.create(pkg, "fileName", this.newResourcePresenter);
        ArgumentCaptor dtableArgumentCaptor = ArgumentCaptor.forClass(GuidedDecisionTable52.class);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).create((Path)Mockito.eq((Object)resourcesPath), (String)Mockito.eq((Object)("fileName." + this.resourceType.getSuffix())), dtableArgumentCaptor.capture(), (String)Mockito.any(String.class));
        GuidedDecisionTable52 model = (GuidedDecisionTable52)dtableArgumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)model.getMetadataCols().size());
        MetadataCol52 metadataCol52 = (MetadataCol52)model.getMetadataCols().get(0);
        Assert.assertEquals((Object)"ResolvedHitPriorityOverRow", (Object)metadataCol52.getMetadata());
    }
}

