/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.popovers;

import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashSet;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.ColumnHeaderPopOver;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.ColumnHeaderPopOverHandler;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ColumnHeaderPopOverHandlerTest {
    @Mock
    private GuidedDecisionTableModellerView.Presenter modellerPresenter;
    @Mock
    private ColumnHeaderPopOver columnPopOverPresenter;
    @Mock
    private Group header;
    @Mock
    private Viewport viewport;
    @Mock
    private DefaultGridLayer layer;
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter1;
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter2;
    @Mock
    private GuidedDecisionTableView dtView1;
    @Mock
    private GuidedDecisionTableView dtView2;
    @Mock
    private GridData uiModel;
    @Mock
    private GridColumn uiColumn;
    @Mock
    private GridRenderer renderer;
    @Mock
    private BaseGridRendererHelper helper;
    @Mock
    private BaseGridRendererHelper.ColumnInformation columnInformation;
    @Mock
    private NodeMouseMoveEvent event;
    private ColumnHeaderPopOverHandler handler;

    @Before
    public void setup() {
        Mockito.when((Object)this.renderer.getHeaderHeight()).thenReturn((Object)64.0);
        Mockito.when((Object)this.renderer.getHeaderRowHeight()).thenReturn((Object)32.0);
        Mockito.when((Object)this.helper.getColumnInformation(((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)this.columnInformation);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)this.uiColumn);
        Mockito.when((Object)this.uiModel.getHeaderRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.uiModel.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)this.uiModel.getColumns()).thenReturn((Object)new ArrayList<GridColumn<?>>(){
            {
                this.add(ColumnHeaderPopOverHandlerTest.this.uiColumn);
            }
        });
        Mockito.when((Object)this.uiColumn.getWidth()).thenReturn((Object)100.0);
        this.setupDecisionTable(this.dtPresenter1, this.dtView1);
        this.setupDecisionTable(this.dtPresenter2, this.dtView2);
        this.handler = new ColumnHeaderPopOverHandler(this.modellerPresenter, this.columnPopOverPresenter);
    }

    private void setupDecisionTable(GuidedDecisionTableView.Presenter dtPresenter, GuidedDecisionTableView dtView) {
        Mockito.when((Object)dtPresenter.getView()).thenReturn((Object)dtView);
        Mockito.when((Object)dtView.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)dtView.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)dtView.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)dtView.getRenderer()).thenReturn((Object)this.renderer);
        Mockito.when((Object)dtView.getRendererHelper()).thenReturn((Object)this.helper);
        Mockito.when((Object)dtView.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)dtView.getHeader()).thenReturn((Object)this.header);
        Mockito.when((Object)dtView.getWidth()).thenReturn((Object)100.0);
    }

    @Test
    public void popOverHiddenOnMouseMoveEvent() {
        this.handler.onNodeMouseMove(this.event);
        ((ColumnHeaderPopOver)Mockito.verify((Object)this.columnPopOverPresenter, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void noPopOverWhenNoDecisionTables() {
        this.handler.onNodeMouseMove(this.event);
        ((ColumnHeaderPopOver)Mockito.verify((Object)this.columnPopOverPresenter, (VerificationMode)Mockito.never())).show((GuidedDecisionTableModellerView)Mockito.any(GuidedDecisionTableModellerView.class), (GuidedDecisionTableView.Presenter)Mockito.any(GuidedDecisionTableView.Presenter.class), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void noPopOverWhenEventNotOverDecisionTableHeader() {
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(ColumnHeaderPopOverHandlerTest.this.dtPresenter1);
            }
        });
        Mockito.when((Object)this.event.getX()).thenReturn((Object)50);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)100);
        Mockito.when((Object)this.dtView1.getLocation()).thenReturn((Object)new Point2D(0.0, 0.0));
        this.handler.onNodeMouseMove(this.event);
        ((ColumnHeaderPopOver)Mockito.verify((Object)this.columnPopOverPresenter, (VerificationMode)Mockito.never())).show((GuidedDecisionTableModellerView)Mockito.any(GuidedDecisionTableModellerView.class), (GuidedDecisionTableView.Presenter)Mockito.any(GuidedDecisionTableView.Presenter.class), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void noPopOverWhenEventNotOverDecisionTableColumn() {
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(ColumnHeaderPopOverHandlerTest.this.dtPresenter1);
            }
        });
        Mockito.when((Object)this.event.getX()).thenReturn((Object)150);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)50);
        Mockito.when((Object)this.dtView1.getLocation()).thenReturn((Object)new Point2D(0.0, 0.0));
        this.handler.onNodeMouseMove(this.event);
        ((ColumnHeaderPopOver)Mockito.verify((Object)this.columnPopOverPresenter, (VerificationMode)Mockito.never())).show((GuidedDecisionTableModellerView)Mockito.any(GuidedDecisionTableModellerView.class), (GuidedDecisionTableView.Presenter)Mockito.any(GuidedDecisionTableView.Presenter.class), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void popOverWhenEventOverDecisionTableHeaderAndColumn() {
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(ColumnHeaderPopOverHandlerTest.this.dtPresenter1);
            }
        });
        Mockito.when((Object)this.event.getX()).thenReturn((Object)50);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)50);
        Mockito.when((Object)this.dtView1.getLocation()).thenReturn((Object)new Point2D(0.0, 0.0));
        this.handler.onNodeMouseMove(this.event);
        ((ColumnHeaderPopOver)Mockito.verify((Object)this.columnPopOverPresenter, (VerificationMode)Mockito.times((int)1))).show((GuidedDecisionTableModellerView)Mockito.any(GuidedDecisionTableModellerView.class), (GuidedDecisionTableView.Presenter)Mockito.eq((Object)this.dtPresenter1), Mockito.eq((int)0));
    }

    @Test
    public void popOverWhenEventOverDecisionTableHeaderAndColumnWithMultipleTables() {
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(ColumnHeaderPopOverHandlerTest.this.dtPresenter1);
                this.add(ColumnHeaderPopOverHandlerTest.this.dtPresenter2);
            }
        });
        Mockito.when((Object)this.dtView1.getLocation()).thenReturn((Object)new Point2D(0.0, 0.0));
        Mockito.when((Object)this.dtView2.getLocation()).thenReturn((Object)new Point2D(200.0, 200.0));
        Mockito.when((Object)this.event.getX()).thenReturn((Object)50);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)50);
        this.handler.onNodeMouseMove(this.event);
        ((ColumnHeaderPopOver)Mockito.verify((Object)this.columnPopOverPresenter, (VerificationMode)Mockito.times((int)1))).show((GuidedDecisionTableModellerView)Mockito.any(GuidedDecisionTableModellerView.class), (GuidedDecisionTableView.Presenter)Mockito.eq((Object)this.dtPresenter1), Mockito.eq((int)0));
        Mockito.when((Object)this.event.getX()).thenReturn((Object)250);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)250);
        this.handler.onNodeMouseMove(this.event);
        ((ColumnHeaderPopOver)Mockito.verify((Object)this.columnPopOverPresenter, (VerificationMode)Mockito.times((int)1))).show((GuidedDecisionTableModellerView)Mockito.any(GuidedDecisionTableModellerView.class), (GuidedDecisionTableView.Presenter)Mockito.eq((Object)this.dtPresenter2), Mockito.eq((int)0));
    }
}

