/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.BiConsumer;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.WorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionWorkItemPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.workitems.WorkItemParametersWidget;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkItemPageTest {
    @Mock
    private WorkItemPage.View view;
    @Mock
    private ActionWorkItemPlugin plugin;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private ActionWorkItemCol52 editingCol;
    @Mock
    private SimplePanel content;
    @Mock
    private TranslationService translationService;
    @Captor
    private ArgumentCaptor<BiConsumer<String, String>> consumer;
    @InjectMocks
    private WorkItemPage<ActionWorkItemPlugin> page;

    public WorkItemPageTest() {
        this.page = (WorkItemPage)Mockito.spy((Object)new WorkItemPage(this.view, this.translationService));
    }

    @BeforeClass
    public static void staticSetup() {
        GWTMockUtilities.disarm();
    }

    @Test
    public void testIsCompleteWhenWorkItemIsSet() {
        Mockito.when((Object)this.plugin.isWorkItemSet()).thenReturn((Object)true);
        this.page.isComplete(Assert::assertTrue);
    }

    @Test
    public void testIsCompleteWhenWorkItemIsNotSet() {
        Mockito.when((Object)this.plugin.isWorkItemSet()).thenReturn((Object)false);
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testEnableParameters() {
        this.page.enableParameters();
        Assert.assertTrue((boolean)this.page.isParametersEnabled());
    }

    @Test
    public void testForEachWorkItem() {
        BiConsumer<String, String> biConsumer = (displayName, name) -> {};
        this.page.forEachWorkItem(biConsumer);
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).forEachWorkItem(biConsumer);
    }

    @Test
    public void testHasWorkItemsWhenItIsFalse() {
        Mockito.when((Object)this.view.workItemsCount()).thenReturn((Object)1);
        boolean hasWorkItems = this.page.hasWorkItems();
        Assert.assertFalse((boolean)hasWorkItems);
    }

    @Test
    public void testHasWorkItemsWhenItIsTrue() {
        Mockito.when((Object)this.view.workItemsCount()).thenReturn((Object)2);
        boolean hasWorkItems = this.page.hasWorkItems();
        Assert.assertTrue((boolean)hasWorkItems);
    }

    @Test
    public void testSelectWorkItem() {
        String workItem = "workItem";
        Mockito.when((Object)this.view.getSelectedWorkItem()).thenReturn((Object)"workItem");
        this.page.selectWorkItem(this.view.getSelectedWorkItem());
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).setWorkItem("workItem");
        ((WorkItemPage)Mockito.verify(this.page)).showParameters();
    }

    @Test
    public void testShowParametersWhenParametersAreNotEnabled() {
        PortableWorkDefinition workDefinition = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        Mockito.when((Object)this.plugin.getWorkItemDefinition()).thenReturn((Object)workDefinition);
        this.page.showParameters();
        ((WorkItemPage.View)Mockito.verify((Object)this.view)).hideParameters();
    }

    @Test
    public void testShowParametersWhenItDoesNotHaveWorkItemDefinition() {
        Mockito.when((Object)this.plugin.getWorkItemDefinition()).thenReturn(null);
        this.page.enableParameters();
        this.page.showParameters();
        ((WorkItemPage.View)Mockito.verify((Object)this.view)).hideParameters();
    }

    @Test
    public void testShowParametersWhenItHasWorkItemDefinitionParametersAreEnabled() {
        PortableWorkDefinition workDefinition = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        Mockito.when((Object)this.plugin.getWorkItemDefinition()).thenReturn((Object)workDefinition);
        this.page.enableParameters();
        this.page.showParameters();
        ((WorkItemPage.View)Mockito.verify((Object)this.view)).showParameters((WorkItemParametersWidget)Mockito.any());
    }

    @Test
    public void testCurrentWorkItem() {
        String expectedWorkItem = "workItem";
        Mockito.when((Object)this.plugin.getWorkItem()).thenReturn((Object)"workItem");
        String actualWorkItem = this.page.currentWorkItem();
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).getWorkItem();
        Assert.assertEquals((Object)"workItem", (Object)actualWorkItem);
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "WorkItemPage.WorkItem";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("WorkItemPage.WorkItem", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        this.page.prepareView();
        ((WorkItemPage.View)Mockito.verify((Object)this.view)).init(this.page);
        ((WorkItemPage)Mockito.verify(this.page)).markAsViewed();
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }

    @Test
    public void testSetupWorkItemsListWhenPageHasWorkItems() {
        String displayName = "displayName";
        String name = "name";
        ((WorkItemPage)Mockito.doReturn((Object)true).when(this.page)).hasWorkItems();
        ((WorkItemPage)Mockito.doNothing().when(this.page)).forEachWorkItem((BiConsumer)this.consumer.capture());
        ((WorkItemPage)Mockito.doReturn((Object)"displayName").when(this.page)).currentWorkItem();
        this.page.setupWorkItemsList();
        BiConsumer consumer = (BiConsumer)this.consumer.getValue();
        consumer.accept("displayName", "name");
        ((WorkItemPage.View)Mockito.verify((Object)this.view)).addItem("displayName", "name");
        ((WorkItemPage.View)Mockito.verify((Object)this.view)).selectWorkItem("displayName");
        ((WorkItemPage)Mockito.verify(this.page)).showParameters();
    }

    @Test
    public void testSetupWorkItemsListWhenPageDoesNotHaveWorkItems() {
        ((WorkItemPage)Mockito.doReturn((Object)false).when(this.page)).hasWorkItems();
        ((WorkItemPage)Mockito.doNothing().when(this.page)).forEachWorkItem((s1, s2) -> {});
        this.page.setupWorkItemsList();
        ((WorkItemPage.View)Mockito.verify((Object)this.view)).setupEmptyWorkItemList();
        ((WorkItemPage)Mockito.verify(this.page, (VerificationMode)Mockito.never())).showParameters();
        ((WorkItemPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addItem((String)Mockito.any(), (String)Mockito.any());
    }

    private PortableWorkDefinition newPortableWorkDefinition(String displayName, String name) {
        PortableWorkDefinition mock = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        ((PortableWorkDefinition)Mockito.doReturn((Object)displayName).when((Object)mock)).getDisplayName();
        ((PortableWorkDefinition)Mockito.doReturn((Object)name).when((Object)mock)).getName();
        return mock;
    }
}

