/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.RuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLConditionColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={BRLRuleModel.class})
public class BRLConditionColumnPluginTest {
    @Mock
    private RuleModellerPage ruleModellerPage;
    @Mock
    private AdditionalInfoPage additionalInfoPage;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private TranslationService translationService;
    @Mock
    private BRLConditionColumn editingCol;
    @Mock
    private HandlerRegistration registration;
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @InjectMocks
    private BRLConditionColumnPlugin plugin;

    public BRLConditionColumnPluginTest() {
        this.plugin = (BRLConditionColumnPlugin)Mockito.spy((Object)new BRLConditionColumnPlugin(this.ruleModellerPage, this.additionalInfoPage, this.changeEvent, this.translationService));
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "BRLConditionColumnPlugin.AddConditionBRL";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("BRLConditionColumnPlugin.AddConditionBRL", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testInit() throws Exception {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.plugin)).tableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)Mockito.mock(EventBus.class)).when((Object)this.presenter)).getEventBus();
        ((NewGuidedDecisionTableColumnWizard)Mockito.doReturn((Object)this.presenter).when((Object)this.wizard)).getPresenter();
        this.plugin.init(this.wizard);
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setupEditingCol();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setupRuleModellerEvents();
    }

    @Test
    public void testGetPages() throws Exception {
        List pages = this.plugin.getPages();
        Assert.assertEquals((long)2L, (long)pages.size());
    }

    @Test
    public void testOnClose() throws Exception {
        this.plugin.onClose();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).teardownRuleModellerEvents();
    }

    @Test
    public void testGenerateColumnWhenHeaderIsBlank() throws Exception {
        ((BRLConditionColumn)Mockito.doReturn((Object)"").when((Object)this.editingCol)).getHeader();
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("BRLConditionColumnPlugin.YouMustEnterAColumnHeaderValueDescription", new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenHeaderIsNotUnique() throws Exception {
        String header = "header";
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isHeaderUnique("header");
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((BRLConditionColumn)Mockito.doReturn((Object)"header").when((Object)this.editingCol)).getHeader();
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("BRLConditionColumnPlugin.ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenHeaderIsValid() throws Exception {
        String header = "header";
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isHeaderUnique("header");
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((BRLConditionColumn)Mockito.doReturn((Object)"header").when((Object)this.editingCol)).getHeader();
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).getDefinedVariables((RuleModel)Mockito.any());
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).setDefinition((List)Mockito.any());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn((ConditionCol52)this.editingCol);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testGetHeader() throws Exception {
        this.plugin.getHeader();
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).getHeader();
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "header";
        this.plugin.setHeader("header");
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).setHeader("header");
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.additionalInfoPage);
    }

    @Test
    public void testGetRuleModel() throws Exception {
        Assert.assertNotNull((Object)this.plugin.getRuleModel());
    }

    @Test
    public void testSetRuleModellerPageAsCompletedWhenItIsCompleted() throws Exception {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isRuleModellerPageCompleted();
        this.plugin.setRuleModellerPageAsCompleted();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setRuleModellerPageCompleted();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.ruleModellerPage);
    }

    @Test
    public void testSetRuleModellerPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isRuleModellerPageCompleted();
        this.plugin.setRuleModellerPageAsCompleted();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setRuleModellerPageCompleted();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.ruleModellerPage);
    }

    @Test
    public void testTableFormat() throws Exception {
        GuidedDecisionTable52.TableFormat expectedTableFormat = GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
        ((GuidedDecisionTable52)Mockito.doReturn((Object)expectedTableFormat).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        GuidedDecisionTable52.TableFormat actualTableFormat = this.plugin.tableFormat();
        Assert.assertEquals((Object)expectedTableFormat, (Object)actualTableFormat);
    }
}

