/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.page.accordion;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.screens.guided.dtable.client.editor.page.accordion.GuidedDecisionTableAccordion;
import org.drools.workbench.screens.guided.dtable.client.editor.page.accordion.GuidedDecisionTableAccordionItem;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTableAccordionTest {
    @Mock
    private GuidedDecisionTableAccordion.View view;
    @Mock
    private ManagedInstance<GuidedDecisionTableAccordionItem> itemManagedInstance;
    private GuidedDecisionTableAccordion accordion;

    @Before
    public void setup() throws Exception {
        this.accordion = (GuidedDecisionTableAccordion)Mockito.spy((Object)new GuidedDecisionTableAccordion(this.view, this.itemManagedInstance));
    }

    @Test
    public void testSetup() throws Exception {
        this.accordion.setup();
        ((GuidedDecisionTableAccordion.View)Mockito.verify((Object)this.view)).init((Object)this.accordion);
    }

    @Test
    public void testAddItem() throws Exception {
        String parentId = "uuid";
        GuidedDecisionTableAccordionItem item = (GuidedDecisionTableAccordionItem)Mockito.mock(GuidedDecisionTableAccordionItem.class);
        GuidedDecisionTableAccordionItem.Type type = GuidedDecisionTableAccordionItem.Type.CONDITION;
        Widget widget = (Widget)Mockito.mock(Widget.class);
        List itemsList = (List)Mockito.spy(new ArrayList());
        Mockito.when((Object)this.accordion.blankAccordionItem()).thenReturn((Object)item);
        Mockito.when((Object)this.accordion.getItems()).thenReturn((Object)itemsList);
        Mockito.when((Object)this.accordion.getParentId()).thenReturn((Object)"uuid");
        this.accordion.addItem(type, widget);
        ((GuidedDecisionTableAccordion.View)Mockito.verify((Object)this.view)).addItem(item);
        ((List)Mockito.verify((Object)itemsList)).add(item);
        ((GuidedDecisionTableAccordionItem)Mockito.verify((Object)item)).init("uuid", type, widget);
    }

    @Test
    public void testClear() throws Exception {
        List itemsList = (List)Mockito.spy(new ArrayList());
        Mockito.when((Object)this.accordion.getItems()).thenReturn((Object)itemsList);
        this.accordion.clear();
        ((List)Mockito.verify((Object)itemsList)).clear();
        ((GuidedDecisionTableAccordion.View)Mockito.verify((Object)this.view)).clear();
    }

    @Test
    public void testGetItemWhenItemExists() throws Exception {
        GuidedDecisionTableAccordionItem.Type type = GuidedDecisionTableAccordionItem.Type.CONDITION;
        final GuidedDecisionTableAccordionItem expectedItem = (GuidedDecisionTableAccordionItem)Mockito.mock(GuidedDecisionTableAccordionItem.class);
        List itemsList = (List)Mockito.spy((Object)new ArrayList<GuidedDecisionTableAccordionItem>(){
            {
                this.add(expectedItem);
            }
        });
        Mockito.when((Object)expectedItem.getType()).thenReturn((Object)type);
        Mockito.when((Object)this.accordion.getItems()).thenReturn((Object)itemsList);
        GuidedDecisionTableAccordionItem item = this.accordion.getItem(type);
        Assert.assertEquals((Object)expectedItem, (Object)item);
    }

    @Test
    public void testGetItemWhenItemDoesNotExist() throws Exception {
        GuidedDecisionTableAccordionItem.Type type = GuidedDecisionTableAccordionItem.Type.CONDITION;
        GuidedDecisionTableAccordionItem blankItem = (GuidedDecisionTableAccordionItem)Mockito.mock(GuidedDecisionTableAccordionItem.class);
        List itemsList = (List)Mockito.spy(new ArrayList());
        Mockito.when((Object)this.accordion.blankAccordionItem()).thenReturn((Object)blankItem);
        Mockito.when((Object)this.accordion.getItems()).thenReturn((Object)itemsList);
        GuidedDecisionTableAccordionItem item = this.accordion.getItem(type);
        Assert.assertEquals((Object)blankItem, (Object)item);
    }

    @Test
    public void testBlankAccordionItem() throws Exception {
        GuidedDecisionTableAccordionItem expectedItem = (GuidedDecisionTableAccordionItem)Mockito.mock(GuidedDecisionTableAccordionItem.class);
        Mockito.when((Object)this.itemManagedInstance.get()).thenReturn((Object)expectedItem);
        GuidedDecisionTableAccordionItem item = this.accordion.blankAccordionItem();
        ((ManagedInstance)Mockito.verify(this.itemManagedInstance)).get();
        Assert.assertEquals((Object)expectedItem, (Object)item);
    }
}

