/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.MouseDownHandler;
import java.util.HashSet;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.CellContextMenu;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RowContextMenu;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerContextMenuSupport;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerPresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GuidedDecisionTableModellerContextMenuSupportTest {
    @Mock
    private CellContextMenu cellContextMenu;
    @Mock
    private RowContextMenu rowContextMenu;
    @Mock
    private GuidedDecisionTableModellerPresenter modellerPresenter;
    @Mock
    private BaseGridRendererHelper.ColumnInformation columnInformation;
    @Mock
    private ContextMenuEvent event;
    @Mock
    private NativeEvent nativeEvent;
    @Mock
    private Element element;
    @Mock
    private Document document;
    @Mock
    private Viewport viewport;
    @Mock
    private Layer layer;
    @Mock
    private GridCell uiCell;
    @Mock
    private CellSelectionStrategy cellSelectionStrategy;
    @Captor
    private ArgumentCaptor<GridData> uiModelCaptor;
    private GuidedDecisionTableModellerContextMenuSupport contextMenuSupport;

    @Before
    public void setup() {
        this.contextMenuSupport = new GuidedDecisionTableModellerContextMenuSupport(this.cellContextMenu, this.rowContextMenu);
        Mockito.when((Object)this.event.getNativeEvent()).thenReturn((Object)this.nativeEvent);
        Mockito.when((Object)this.event.getRelativeElement()).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getAbsoluteLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getScrollLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getAbsoluteTop()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getScrollTop()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getOwnerDocument()).thenReturn((Object)this.document);
        Mockito.when((Object)this.document.getScrollLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.document.getScrollTop()).thenReturn((Object)0);
        Mockito.when((Object)this.nativeEvent.getShiftKey()).thenReturn((Object)false);
        Mockito.when((Object)this.nativeEvent.getCtrlKey()).thenReturn((Object)false);
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)50);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)50);
        Mockito.when((Object)this.uiCell.getSelectionStrategy()).thenReturn((Object)this.cellSelectionStrategy);
    }

    @Test
    public void getContextMenuHandler() {
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        Assert.assertNotNull((Object)handler);
    }

    @Test
    public void getContextMenuMouseDownHandler() {
        MouseDownHandler handler = this.contextMenuSupport.getContextMenuMouseDownHandler();
        Assert.assertNotNull((Object)handler);
    }

    @Test
    public void onContextMenu_RowContextMenu() {
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GridData uiModel = dtPresenter.getView().getModel();
        RowNumberColumn uiColumn = new RowNumberColumn();
        uiModel.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((RowContextMenu)Mockito.verify((Object)this.rowContextMenu, (VerificationMode)Mockito.times((int)1))).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
        ((CellContextMenu)Mockito.verify((Object)this.cellContextMenu, (VerificationMode)Mockito.never())).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onContextMenu_CellContextMenu() {
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GridData uiModel = dtPresenter.getView().getModel();
        BaseGridColumn uiColumn = new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0);
        uiModel.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((RowContextMenu)Mockito.verify((Object)this.rowContextMenu, (VerificationMode)Mockito.never())).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
        ((CellContextMenu)Mockito.verify((Object)this.cellContextMenu, (VerificationMode)Mockito.times((int)1))).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void testContextMenuCellIsSelectedCell() {
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GridData uiModel = dtPresenter.getView().getModel();
        RowNumberColumn uiColumn = new RowNumberColumn();
        uiModel.appendColumn((GridColumn)uiColumn);
        uiModel.selectCells(0, 0, 1, 1);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((CellSelectionStrategy)Mockito.verify((Object)this.cellSelectionStrategy, (VerificationMode)Mockito.never())).handleSelection((GridData)Mockito.any(GridData.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((RowContextMenu)Mockito.verify((Object)this.rowContextMenu, (VerificationMode)Mockito.times((int)1))).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
        ((CellContextMenu)Mockito.verify((Object)this.cellContextMenu, (VerificationMode)Mockito.never())).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void testContextMenuCellIsNotSelectedCell() {
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GridData uiModel = dtPresenter.getView().getModel();
        RowNumberColumn uiColumn = new RowNumberColumn();
        uiModel.appendColumn((GridColumn)uiColumn);
        uiModel.appendRow((GridRow)new BaseGridRow());
        uiModel.selectCells(1, 0, 1, 1);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        Mockito.when((Object)uiModel.getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)this.uiCell);
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((CellSelectionStrategy)Mockito.verify((Object)this.cellSelectionStrategy, (VerificationMode)Mockito.times((int)1))).handleSelection((GridData)Mockito.any(GridData.class), Mockito.eq((int)0), Mockito.eq((int)0), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        ((RowContextMenu)Mockito.verify((Object)this.rowContextMenu, (VerificationMode)Mockito.times((int)1))).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
        ((CellContextMenu)Mockito.verify((Object)this.cellContextMenu, (VerificationMode)Mockito.never())).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onContextMenuWithCellSelectionManagerWithChangeInSelection() {
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GridData uiModel = dtPresenter.getView().getModel();
        RowNumberColumn uiColumn = new RowNumberColumn();
        uiModel.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        Mockito.when((Object)uiModel.getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)this.uiCell);
        Mockito.when((Object)this.cellSelectionStrategy.handleSelection((GridData)Mockito.any(GridData.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((CellSelectionStrategy)Mockito.verify((Object)this.cellSelectionStrategy, (VerificationMode)Mockito.times((int)1))).handleSelection((GridData)Mockito.eq((Object)uiModel), Mockito.eq((int)0), Mockito.eq((int)0), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).batch();
    }

    @Test
    public void onContextMenuWithCellSelectionManagerWithoutChangeInSelection() {
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GridData uiModel = dtPresenter.getView().getModel();
        RowNumberColumn uiColumn = new RowNumberColumn();
        uiModel.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        Mockito.when((Object)uiModel.getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)this.uiCell);
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((CellSelectionStrategy)Mockito.verify((Object)this.cellSelectionStrategy, (VerificationMode)Mockito.times((int)1))).handleSelection((GridData)Mockito.eq((Object)uiModel), Mockito.eq((int)0), Mockito.eq((int)0), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.never())).batch();
    }

    @Test
    public void onContextMenuWithoutCellSelectionManager() {
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GridData uiModel = dtPresenter.getView().getModel();
        RowNumberColumn uiColumn = new RowNumberColumn();
        uiModel.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        GridCell uiCell = (GridCell)Mockito.mock(GridCell.class);
        Mockito.when((Object)uiModel.getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)uiCell);
        Mockito.when((Object)uiCell.getSelectionStrategy()).thenReturn(null);
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.never())).batch();
    }

    @Test
    public void onContextMenuWithMultipleTables() {
        final GuidedDecisionTableView.Presenter dtPresenter1 = this.makeDecisionTable(0.0, 0.0);
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeDecisionTable(200.0, 200.0);
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter1);
                this.add(dtPresenter2);
            }
        });
        GridData uiModel1 = dtPresenter1.getView().getModel();
        GridData uiModel2 = dtPresenter2.getView().getModel();
        BaseGridColumn uiColumn = new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0);
        uiModel1.appendColumn((GridColumn)uiColumn);
        uiModel2.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)uiModel1.getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)this.uiCell);
        Mockito.when((Object)uiModel2.getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)this.uiCell);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)50);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)50);
        handler.onContextMenu(this.event);
        ((CellSelectionStrategy)Mockito.verify((Object)this.cellSelectionStrategy, (VerificationMode)Mockito.times((int)1))).handleSelection((GridData)this.uiModelCaptor.capture(), ((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        Assert.assertEquals((Object)uiModel1, (Object)this.uiModelCaptor.getValue());
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)250);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)250);
        handler.onContextMenu(this.event);
        ((CellSelectionStrategy)Mockito.verify((Object)this.cellSelectionStrategy, (VerificationMode)Mockito.times((int)2))).handleSelection((GridData)this.uiModelCaptor.capture(), ((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        Assert.assertEquals((Object)uiModel2, (Object)this.uiModelCaptor.getValue());
    }

    private GuidedDecisionTableView.Presenter makeDecisionTable() {
        return this.makeDecisionTable(0.0, 0.0);
    }

    private GuidedDecisionTableView.Presenter makeDecisionTable(double x, double y) {
        GridData uiModel = (GridData)Mockito.spy((Object)new BaseGridData());
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTableView dtView = (GuidedDecisionTableView)Mockito.mock(GuidedDecisionTableView.class);
        GridRenderer renderer = (GridRenderer)Mockito.mock(GridRenderer.class);
        BaseGridRendererHelper helper = (BaseGridRendererHelper)Mockito.mock(BaseGridRendererHelper.class);
        uiModel.appendRow((GridRow)new BaseGridRow());
        Mockito.when((Object)dtPresenter.getView()).thenReturn((Object)dtView);
        Mockito.when((Object)dtPresenter.getAccess()).thenReturn(Mockito.mock(GuidedDecisionTablePresenter.Access.class));
        Mockito.when((Object)dtPresenter.getModel()).thenReturn(Mockito.mock(GuidedDecisionTable52.class));
        Mockito.when((Object)dtView.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)dtView.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)dtView.getLocation()).thenReturn((Object)new Point2D(x, y));
        Mockito.when((Object)dtView.getAbsoluteX()).thenReturn((Object)x);
        Mockito.when((Object)dtView.getAbsoluteY()).thenReturn((Object)y);
        Mockito.when((Object)dtView.getWidth()).thenReturn((Object)50.0);
        Mockito.when((Object)dtView.getHeight()).thenReturn((Object)52.0);
        Mockito.when((Object)dtView.getModel()).thenReturn((Object)uiModel);
        Mockito.when((Object)dtView.getRenderer()).thenReturn((Object)renderer);
        Mockito.when((Object)renderer.getHeaderHeight()).thenReturn((Object)32.0);
        Mockito.when((Object)dtView.getRendererHelper()).thenReturn((Object)helper);
        Mockito.when((Object)helper.getColumnInformation(((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)this.columnInformation);
        return dtPresenter;
    }
}

