/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.mediator.Mediators;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Map;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerViewImpl;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.ColumnLabelWidget;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={ColumnLabelWidget.class, GridLienzoPanel.class, DefaultGridLayer.class, GridWidget.class, RestrictedMousePanMediator.class})
public class GuidedDecisionTableModellerViewImplTest {
    @Mock
    private GridLienzoPanel mockGridPanel;
    @Mock
    private DefaultGridLayer defaultGridLayer;
    @Mock
    private RestrictedMousePanMediator restrictedMousePanMediator;
    @Mock
    private GuidedDecisionTableModellerView.Presenter presenter;
    @Mock
    private GuidedDecisionTableView dtableView;
    @Mock
    private HTMLPanel pinnedModeIndicator;
    @Captor
    private ArgumentCaptor<Command> commandArgumentCaptor;
    @Mock
    private RootPanel rootPanel;
    @Mock
    private TranslationService translationService;
    private GuidedDecisionTableModellerViewImpl view;

    @Before
    public void setup() {
        this.view = (GuidedDecisionTableModellerViewImpl)Mockito.spy((Object)((Object)new GuidedDecisionTableModellerViewImplFake(this.translationService)));
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd/mm/yy");
            }
        });
    }

    @Test
    public void testAddKeyDownHandlerAttachesToEditor() {
        KeyDownHandler handler = (KeyDownHandler)Mockito.mock(KeyDownHandler.class);
        this.view.addKeyDownHandler(handler);
        ((RootPanel)Mockito.verify((Object)this.rootPanel, (VerificationMode)Mockito.never())).addDomHandler((EventHandler)Mockito.eq((Object)handler), (DomEvent.Type)Mockito.eq((Object)KeyDownEvent.getType()));
        ((GridLienzoPanel)Mockito.verify((Object)this.mockGridPanel)).addKeyDownHandler((KeyDownHandler)Mockito.eq((Object)handler));
    }

    @Test
    public void testAddMouseDownHandlerAttachesToRootPanel() {
        MouseDownHandler handler = (MouseDownHandler)Mockito.mock(MouseDownHandler.class);
        this.view.addMouseDownHandler(handler);
        ((GridLienzoPanel)Mockito.verify((Object)this.mockGridPanel, (VerificationMode)Mockito.never())).addMouseDownHandler((MouseDownHandler)Mockito.eq((Object)handler));
        ((RootPanel)Mockito.verify((Object)this.rootPanel)).addDomHandler((EventHandler)Mockito.eq((Object)handler), (DomEvent.Type)Mockito.eq((Object)MouseDownEvent.getType()));
    }

    @Test
    public void testSelect() {
        GridWidget gridWidget = (GridWidget)Mockito.mock(GridWidget.class);
        DefaultGridLayer gridLayer = (DefaultGridLayer)Mockito.mock(DefaultGridLayer.class);
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)gridLayer).when((Object)this.view)).getGridLayer();
        this.view.select(gridWidget);
        ((DefaultGridLayer)Mockito.verify((Object)gridLayer)).select(gridWidget);
    }

    @Test
    public void testRefreshScrollPosition() {
        this.view.refreshScrollPosition();
        ((GridLienzoPanel)Mockito.verify((Object)this.mockGridPanel)).refreshScrollPosition();
    }

    @Test
    public void testSetup() throws Exception {
        AbsolutePanel mainPanel = (AbsolutePanel)Mockito.mock(AbsolutePanel.class);
        Transform transform = (Transform)Mockito.mock(Transform.class);
        Viewport viewport = (Viewport)Mockito.mock(Viewport.class);
        Mediators mediators = (Mediators)Mockito.mock(Mediators.class);
        Element element = (Element)Mockito.mock(Element.class);
        ((Transform)Mockito.doReturn((Object)transform).when((Object)transform)).scale(Mockito.anyDouble());
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)transform).when((Object)this.view)).newTransform();
        ((Viewport)Mockito.doReturn((Object)mediators).when((Object)viewport)).getMediators();
        ((GridLienzoPanel)Mockito.doReturn((Object)element).when((Object)this.mockGridPanel)).getElement();
        ((GridLienzoPanel)Mockito.doReturn((Object)mainPanel).when((Object)this.mockGridPanel)).getScrollPanel();
        ((GridLienzoPanel)Mockito.doReturn((Object)viewport).when((Object)this.mockGridPanel)).getViewport();
        this.view.setup();
        ((GuidedDecisionTableModellerViewImpl)Mockito.verify((Object)this.view)).setupGridPanel();
        ((Mediators)Mockito.verify((Object)mediators)).push((IMediator)this.restrictedMousePanMediator);
    }

    @Test
    public void testRadarIsUpdatedAfterScrolling() throws Exception {
        ArgumentCaptor scrollHandler = ArgumentCaptor.forClass(ScrollHandler.class);
        ScrollEvent scrollEvent = (ScrollEvent)Mockito.mock(ScrollEvent.class);
        AbsolutePanel mainPanel = (AbsolutePanel)Mockito.mock(AbsolutePanel.class);
        Transform transform = (Transform)Mockito.mock(Transform.class);
        Viewport viewport = (Viewport)Mockito.mock(Viewport.class);
        Mediators mediators = (Mediators)Mockito.mock(Mediators.class);
        Element element = (Element)Mockito.mock(Element.class);
        ((Transform)Mockito.doReturn((Object)transform).when((Object)transform)).scale(Mockito.anyDouble());
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)this.presenter).when((Object)this.view)).getPresenter();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)transform).when((Object)this.view)).newTransform();
        ((Viewport)Mockito.doReturn((Object)mediators).when((Object)viewport)).getMediators();
        ((GridLienzoPanel)Mockito.doReturn((Object)element).when((Object)this.mockGridPanel)).getElement();
        ((GridLienzoPanel)Mockito.doReturn((Object)mainPanel).when((Object)this.mockGridPanel)).getScrollPanel();
        ((GridLienzoPanel)Mockito.doReturn((Object)viewport).when((Object)this.mockGridPanel)).getViewport();
        this.view.setupGridPanel();
        ((AbsolutePanel)Mockito.verify((Object)mainPanel)).addDomHandler((EventHandler)scrollHandler.capture(), (DomEvent.Type)Mockito.eq((Object)ScrollEvent.getType()));
        ((ScrollHandler)scrollHandler.getValue()).onScroll(scrollEvent);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.presenter)).updateRadar();
    }

    @Test
    public void testScrollbarsUpdatedAfterZoom() throws Exception {
        double x = 10.0;
        double y = 20.0;
        int zoom = 70;
        Transform transform = (Transform)Mockito.mock(Transform.class);
        Viewport viewport = (Viewport)Mockito.mock(Viewport.class);
        TransformMediator mediator = (TransformMediator)Mockito.mock(TransformMediator.class);
        ((TransformMediator)Mockito.doReturn((Object)transform).when((Object)mediator)).adjust((Transform)Mockito.eq((Object)transform), (Bounds)Mockito.any());
        ((RestrictedMousePanMediator)Mockito.doReturn((Object)mediator).when((Object)this.restrictedMousePanMediator)).getTransformMediator();
        ((Transform)Mockito.doReturn((Object)10.0).when((Object)transform)).getTranslateX();
        ((Transform)Mockito.doReturn((Object)20.0).when((Object)transform)).getTranslateY();
        ((GuidedDecisionTableModellerViewImpl)Mockito.doReturn((Object)transform).when((Object)this.view)).newTransform();
        ((Viewport)Mockito.doReturn((Object)transform).when((Object)viewport)).getTransform();
        ((GridLienzoPanel)Mockito.doReturn((Object)viewport).when((Object)this.mockGridPanel)).getViewport();
        this.view.setZoom(70);
        ((Transform)Mockito.verify((Object)transform)).translate(10.0, 20.0);
        ((Transform)Mockito.verify((Object)transform)).scale(0.7);
        ((Viewport)Mockito.verify((Object)viewport, (VerificationMode)Mockito.times((int)2))).setTransform(transform);
        ((Viewport)Mockito.verify((Object)viewport)).batch();
        ((GridLienzoPanel)Mockito.verify((Object)this.mockGridPanel)).refreshScrollPosition();
    }

    @Test
    public void testPinnedModeVisible() throws Exception {
        Element element = (Element)Mockito.mock(Element.class);
        Style style = (Style)Mockito.mock(Style.class);
        ((HTMLPanel)Mockito.doReturn((Object)element).when((Object)this.pinnedModeIndicator)).getElement();
        ((Element)Mockito.doReturn((Object)style).when((Object)element)).getStyle();
        this.view.setPinnedModeIndicatorVisibility(true);
        ((Style)Mockito.verify((Object)style)).setTop(0.5, Style.Unit.EM);
    }

    @Test
    public void testPinnedModeHidden() throws Exception {
        Element element = (Element)Mockito.mock(Element.class);
        Style style = (Style)Mockito.mock(Style.class);
        ((HTMLPanel)Mockito.doReturn((Object)element).when((Object)this.pinnedModeIndicator)).getElement();
        ((Element)Mockito.doReturn((Object)style).when((Object)element)).getStyle();
        this.view.setPinnedModeIndicatorVisibility(false);
        ((Style)Mockito.verify((Object)style)).setTop(-2.0, Style.Unit.EM);
    }

    @Test
    public void testRemoveDecisionTableWhenPinned() {
        Command callback = (Command)Mockito.mock(Command.class);
        GridPinnedModeManager.PinnedContext context = (GridPinnedModeManager.PinnedContext)Mockito.mock(GridPinnedModeManager.PinnedContext.class);
        Mockito.when((Object)this.defaultGridLayer.isGridPinned()).thenReturn((Object)true);
        Mockito.when((Object)this.defaultGridLayer.getPinnedContext()).thenReturn((Object)context);
        Mockito.when((Object)context.getGridWidget()).thenReturn((Object)this.dtableView);
        this.view.removeDecisionTable(this.dtableView, callback);
        ((DefaultGridLayer)Mockito.verify((Object)this.defaultGridLayer, (VerificationMode)Mockito.times((int)1))).exitPinnedMode((Command)this.commandArgumentCaptor.capture());
        Command command = (Command)this.commandArgumentCaptor.getValue();
        Assert.assertNotNull((Object)command);
        command.execute();
        ((DefaultGridLayer)Mockito.verify((Object)this.defaultGridLayer, (VerificationMode)Mockito.times((int)1))).remove((IPrimitive)this.dtableView);
        ((Command)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).execute();
        ((DefaultGridLayer)Mockito.verify((Object)this.defaultGridLayer, (VerificationMode)Mockito.times((int)1))).batch();
    }

    @Test
    public void testRemoveDecisionTableWhenNotPinned() {
        Command callback = (Command)Mockito.mock(Command.class);
        this.view.removeDecisionTable(this.dtableView, callback);
        ((Command)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).execute();
    }

    class GuidedDecisionTableModellerViewImplFake
    extends GuidedDecisionTableModellerViewImpl {
        public GuidedDecisionTableModellerViewImplFake(TranslationService translationService) {
            super(translationService);
            this.gridPanel = GuidedDecisionTableModellerViewImplTest.this.mockGridPanel;
            this.pinnedModeIndicator = GuidedDecisionTableModellerViewImplTest.this.pinnedModeIndicator;
        }

        DefaultGridLayer defaultGridLayer() {
            return GuidedDecisionTableModellerViewImplTest.this.defaultGridLayer;
        }

        RestrictedMousePanMediator restrictedMousePanMediator() {
            return GuidedDecisionTableModellerViewImplTest.this.restrictedMousePanMediator;
        }

        RootPanel rootPanel() {
            return GuidedDecisionTableModellerViewImplTest.this.rootPanel;
        }

        GuidedDecisionTableModellerView.Presenter getPresenter() {
            return GuidedDecisionTableModellerViewImplTest.this.presenter;
        }
    }
}

