/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.BaseGuidedDecisionTablePresenterTest;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerPresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshAttributesPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMetaDataPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTablePresenterAttributesAndMetadataTest
extends BaseGuidedDecisionTablePresenterTest {
    @Captor
    private ArgumentCaptor<Set<String>> reservedAttributesCaptor;
    @Captor
    private ArgumentCaptor<Map<String, String>> callbackValueCaptor;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.dtPresenter.onAppendRow();
        this.dtPresenter.onAppendRow();
        this.dtPresenter.onAppendRow();
    }

    @Test
    public void isMetaDataUnique() {
        MetadataCol52 metadata = new MetadataCol52();
        metadata.setMetadata("metadata");
        this.dtPresenter.getModel().getMetadataCols().add(metadata);
        Assert.assertFalse((boolean)this.dtPresenter.isMetaDataUnique("metadata"));
        Assert.assertTrue((boolean)this.dtPresenter.isMetaDataUnique("cheese"));
    }

    @Test
    public void appendAttributeColumn() throws ModelSynchronizer.VetoException {
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute("auto-focus");
        this.dtPresenter.appendColumn(column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendColumn((BaseColumn)Mockito.eq((Object)column));
        ((Event)Mockito.verify((Object)this.refreshAttributesPanelEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RefreshAttributesPanelEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void appendMetadataColumn() throws ModelSynchronizer.VetoException {
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        MetadataCol52 column = new MetadataCol52();
        column.setMetadata("metadata");
        this.dtPresenter.appendColumn(column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendColumn((BaseColumn)Mockito.eq((Object)column));
        ((Event)Mockito.verify((Object)this.refreshMetaDataPanelEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RefreshMetaDataPanelEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void deleteAttributeColumn() throws ModelSynchronizer.VetoException {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute("auto-focus");
        this.dtPresenter.appendColumn(column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        this.dtPresenter.deleteColumn(column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)column));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void deleteMetadataColumn() throws ModelSynchronizer.VetoException {
        MetadataCol52 column = new MetadataCol52();
        column.setMetadata("metadata");
        this.dtPresenter.appendColumn(column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        this.dtPresenter.deleteColumn(column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)column));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void updateAttributeColumn() throws ModelSynchronizer.VetoException {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute("auto-focus");
        this.dtPresenter.appendColumn(column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        AttributeCol52 update = new AttributeCol52();
        update.setAttribute("enabled");
        this.dtPresenter.updateColumn(column, update);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).updateColumn((BaseColumn)Mockito.eq((Object)column), (BaseColumn)Mockito.eq((Object)update));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void updateMetadataColumn() throws ModelSynchronizer.VetoException {
        MetadataCol52 column = new MetadataCol52();
        column.setMetadata("metadata");
        this.dtPresenter.appendColumn(column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        MetadataCol52 update = new MetadataCol52();
        column.setMetadata("update");
        this.dtPresenter.updateColumn(column, update);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).updateColumn((BaseColumn)Mockito.eq((Object)column), (BaseColumn)Mockito.eq((Object)update));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }
}

