/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPathClipper;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwtmockito.GwtMockito;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableViewImpl;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.themes.GuidedDecisionTableTheme;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GuidedDecisionTableViewImplTest {
    private static final double HEADER_ROW_HEIGHT = 32.0;
    @Mock
    private GridRenderer renderer;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    private ModelSynchronizer modelSynchronizer;
    @Mock
    private GridColumn<?> uiRowNumberColumn;
    @Mock
    private GridColumn<?> uiDescriptionColumn;
    @Mock
    private GridColumn<?> uiColumn1;
    @Mock
    private GridColumn<?> uiColumn2;
    @Mock
    private GuidedDecisionTableTheme theme;
    @Mock
    private Rectangle rectangle;
    @Mock
    private MultiPath border;
    @Mock
    private Text caption;
    @Mock
    private IPathClipper clipper;
    @Mock
    private Group container;
    @Mock
    private Group header;
    @Mock
    private Group floatingHeader;
    private GridData uiModel;
    private GuidedDecisionTable52 model;
    private TestGuidedDecisionTableViewImpl view;
    private List<GridColumn<?>> allColumns;

    @Before
    public void setup() {
        Mockito.when((Object)this.renderer.getTheme()).thenReturn((Object)this.theme);
        Mockito.when((Object)this.theme.getBodyGridLine()).thenReturn((Object)this.border);
        Mockito.when((Object)this.theme.getHeaderText()).thenReturn((Object)this.caption);
        Mockito.when((Object)this.theme.getBaseRectangle((GuidedDecisionTableTheme.ModelColumnType)Matchers.any(GuidedDecisionTableTheme.ModelColumnType.class))).thenReturn((Object)this.rectangle);
        GwtMockito.useProviderForType(Group.class, clazz -> this.container);
        this.uiModel = new GuidedDecisionTableUiModel(this.modelSynchronizer);
        this.model = new GuidedDecisionTable52();
        this.view = new TestGuidedDecisionTableViewImpl(this.uiModel, this.renderer, this.presenter, this.model, (Event)this.notificationEvent){};
        this.allColumns = Arrays.asList(this.uiRowNumberColumn, this.uiDescriptionColumn, this.uiColumn1, this.uiColumn2);
    }

    @Test
    public void testDrawHeaderWithFloatingColumn() {
        BaseGridRendererHelper.RenderingInformation ri = this.makeRenderingInformation(Arrays.asList(this.uiDescriptionColumn, this.uiColumn1, this.uiColumn2), Collections.singletonList(this.uiRowNumberColumn));
        this.view.drawHeader(ri);
        this.view.executeRenderQueueCommands(true);
        ((Group)Mockito.verify((Object)this.header, (VerificationMode)Mockito.never())).add((IPrimitive)Matchers.any(Group.class));
        ((Group)Mockito.verify((Object)this.floatingHeader)).add((IPrimitive)Matchers.eq((Object)this.container));
    }

    @Test
    public void testDrawHeaderWithoutFloatingColumn() {
        BaseGridRendererHelper.RenderingInformation ri = this.makeRenderingInformation(Arrays.asList(this.uiRowNumberColumn, this.uiDescriptionColumn, this.uiColumn1, this.uiColumn2), Collections.emptyList());
        this.view.drawHeader(ri);
        this.view.executeRenderQueueCommands(true);
        ((Group)Mockito.verify((Object)this.header)).add((IPrimitive)Matchers.eq((Object)this.container));
        ((Group)Mockito.verify((Object)this.floatingHeader, (VerificationMode)Mockito.never())).add((IPrimitive)Matchers.any(Group.class));
    }

    @Test
    public void testDrawHeaderWithoutFloatingColumnOrRowNumberOrDescriptionColumns() {
        BaseGridRendererHelper.RenderingInformation ri = this.makeRenderingInformation(Arrays.asList(this.uiColumn1, this.uiColumn2), Collections.emptyList());
        this.view.drawHeader(ri);
        this.view.executeRenderQueueCommands(true);
        ((Group)Mockito.verify((Object)this.header, (VerificationMode)Mockito.never())).add((IPrimitive)Matchers.any(Group.class));
        ((Group)Mockito.verify((Object)this.floatingHeader, (VerificationMode)Mockito.never())).add((IPrimitive)Matchers.any(Group.class));
    }

    private BaseGridRendererHelper.RenderingInformation makeRenderingInformation(List<GridColumn<?>> bodyColumns, List<GridColumn<?>> floatingColumns) {
        this.view.setAllColumns(this.allColumns);
        this.view.setBodyColumns(bodyColumns);
        this.view.setFloatingColumns(floatingColumns);
        return new BaseGridRendererHelper.RenderingInformation((Bounds)new BaseBounds(0.0, 0.0, 1000.0, 2000.0), this.allColumns, this.makeRenderingBlockInformation(bodyColumns), this.makeRenderingBlockInformation(floatingColumns), 0, 1, Collections.singletonList(0.0), false, false, 32.0, 1.0, 0.0);
    }

    private BaseGridRendererHelper.RenderingBlockInformation makeRenderingBlockInformation(List<GridColumn<?>> columns) {
        return new BaseGridRendererHelper.RenderingBlockInformation(columns, 0.0, 0.0, 32.0, columns.stream().mapToDouble(GridColumn::getWidth).sum());
    }

    private class TestGuidedDecisionTableViewImpl
    extends GuidedDecisionTableViewImpl {
        public TestGuidedDecisionTableViewImpl(GridData uiModel, GridRenderer renderer, GuidedDecisionTableView.Presenter presenter, GuidedDecisionTable52 model, Event<NotificationEvent> notificationEvent) {
            super(uiModel, renderer, presenter, model, notificationEvent);
            this.header = GuidedDecisionTableViewImplTest.this.header;
            this.floatingHeader = GuidedDecisionTableViewImplTest.this.floatingHeader;
        }

        IPathClipper getPathClipper(BoundingBox bb) {
            return GuidedDecisionTableViewImplTest.this.clipper;
        }

        public void executeRenderQueueCommands(boolean isSelectionLayer) {
            super.executeRenderQueueCommands(isSelectionLayer);
        }

        void setAllColumns(List<GridColumn<?>> allColumns) {
            this.allColumns.clear();
            this.allColumns.addAll(allColumns);
        }

        void setBodyColumns(List<GridColumn<?>> bodyColumns) {
            this.bodyColumns.clear();
            this.bodyColumns.addAll(bodyColumns);
        }

        void setFloatingColumns(List<GridColumn<?>> floatingColumns) {
            this.floatingColumns.clear();
            this.floatingColumns.addAll(floatingColumns);
        }
    }
}

